/*
 * Decompiled with CFR 0.152.
 */
package net.xqj.core.xqitem;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import javax.xml.xquery.XQException;
import net.xqj.core.Text2XQuerySyntax;
import net.xqj.core.XQToolkit;
import net.xqj.core.exception.XQExceptionImpl;
import net.xqj.core.io.UTF8Reader;
import net.xqj.core.xqitem.AbstractAtomicXQItem;

public class StreamingAtomicXQItem
extends AbstractAtomicXQItem
implements Cloneable {
    private static int instanceCounter = 0;
    private int instanceId = ++instanceCounter;
    private InputStream in;
    private String cachedString = null;

    protected StreamingAtomicXQItem(InputStream in) {
        this.setInputStream(in);
    }

    public void setInputStream(InputStream in) {
        this.in = in;
    }

    static final StreamingAtomicXQItem newInstance(InputStream in) {
        return new StreamingAtomicXQItem(in);
    }

    private Reader getReader() {
        UTF8Reader reader = new UTF8Reader();
        reader.setInput(this.in);
        return reader;
    }

    @Override
    public void writeItem(Writer writer, Properties properties) throws XQException {
        if (!XQToolkit.isToWriteXQuery(properties)) {
            try {
                int read;
                char[] buffer = new char[2048];
                Reader reader = this.getReader();
                while ((read = reader.read(buffer)) != -1) {
                    writer.write(buffer, 0, read);
                }
            }
            catch (IOException e) {
                throw new XQExceptionImpl("IOException occurred whilst writing atomic item.", "XQJAXO04", e);
            }
        } else {
            char[] localBuffer = this.createString().toCharArray();
            Text2XQuerySyntax.writeItem(writer, localBuffer, 0, localBuffer.length, this.getItemType().getBaseType(), this.nodeUriString);
        }
        try {
            writer.flush();
        }
        catch (IOException e) {
            throw new XQExceptionImpl(e.getMessage(), "XQJAXO05", e);
        }
    }

    public String toString() {
        return "StreamingAtomicXQItem(" + this.xqItemType + ")-" + this.instanceId;
    }

    @Override
    public String createString() {
        if (this.cachedString != null) {
            return this.cachedString;
        }
        StringWriter writer = new StringWriter();
        try {
            this.writeItem(writer, null);
            this.cachedString = writer.toString();
            return this.cachedString;
        }
        catch (XQException e) {
            throw new RuntimeException("Exception occured whilst trying to create String from streaming atomic item.", e);
        }
    }

    @Override
    public Object clone() {
        throw new UnsupportedOperationException("Unable to clone a StreamingAtomicXQItem object.");
    }
}

