/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core;

import java.util.Locale;
import org.basex.io.IOFile;
import org.basex.io.IOUrl;
import org.basex.util.Prop;
import org.basex.util.list.StringList;
import org.basex.util.options.BooleanOption;
import org.basex.util.options.Comment;
import org.basex.util.options.EnumOption;
import org.basex.util.options.NumberOption;
import org.basex.util.options.Options;
import org.basex.util.options.StringOption;

public final class StaticOptions
extends Options {
    public static final Comment C_GENERAL = new Comment("General Options");
    public static final BooleanOption DEBUG = new BooleanOption("DEBUG", false);
    public static final StringOption DBPATH = new StringOption("DBPATH", Prop.HOMEDIR + "data");
    public static final StringOption LOGPATH = new StringOption("LOGPATH", ".logs");
    public static final StringOption REPOPATH = new StringOption("REPOPATH", Prop.HOMEDIR + "repo");
    public static final StringOption LANG = new StringOption("LANG", Prop.language);
    public static final BooleanOption FAIRLOCK = new BooleanOption("FAIRLOCK", false);
    public static final NumberOption CACHETIMEOUT = new NumberOption("CACHETIMEOUT", 3600);
    public static final BooleanOption WRITESTORE = new BooleanOption("WRITESTORE", true);
    public static final Comment C_CLIENT = new Comment("Client/Server Architecture");
    public static final StringOption HOST = new StringOption("HOST", "localhost");
    public static final NumberOption PORT = new NumberOption("PORT", 1984);
    public static final NumberOption SERVERPORT = new NumberOption("SERVERPORT", 1984);
    public static final StringOption USER = new StringOption("USER", "");
    public static final StringOption PASSWORD = new StringOption("PASSWORD", "");
    public static final StringOption SERVERHOST = new StringOption("SERVERHOST", "");
    public static final StringOption PROXYHOST = new StringOption("PROXYHOST", "");
    public static final NumberOption PROXYPORT = new NumberOption("PROXYPORT", 0);
    public static final StringOption NONPROXYHOSTS = new StringOption("NONPROXYHOSTS", "");
    public static final BooleanOption IGNORECERT = new BooleanOption("IGNORECERT", false);
    public static final NumberOption TIMEOUT = new NumberOption("TIMEOUT", 30);
    public static final NumberOption KEEPALIVE = new NumberOption("KEEPALIVE", 600);
    public static final NumberOption PARALLEL = new NumberOption("PARALLEL", 8);
    public static final StringOption LOG = new StringOption("LOG", "data");
    public static final StringOption LOGEXCLUDE = new StringOption("LOGEXCLUDE", "");
    public static final StringOption LOGCUT = new StringOption("LOGCUT", "");
    public static final NumberOption LOGMSGMAXLEN = new NumberOption("LOGMSGMAXLEN", 5000);
    public static final BooleanOption LOGTRACE = new BooleanOption("LOGTRACE", true);
    public static final BooleanOption LOGMASKIP = new BooleanOption("LOGMASKIP", false);
    public static final Comment C_HTTP = new Comment("HTTP Services");
    public static final StringOption WEBPATH = new StringOption("WEBPATH", Prop.HOMEDIR + "webapp");
    public static final BooleanOption GZIP = new BooleanOption("GZIP", false);
    public static final StringOption RESTPATH = new StringOption("RESTPATH", "");
    public static final StringOption RESTXQPATH = new StringOption("RESTXQPATH", "");
    public static final NumberOption PARSERESTXQ = new NumberOption("PARSERESTXQ", 3);
    public static final BooleanOption RESTXQERRORS = new BooleanOption("RESTXQERRORS", true);
    public static final BooleanOption HTTPLOCAL = new BooleanOption("HTTPLOCAL", false);
    public static final NumberOption STOPPORT = new NumberOption("STOPPORT", 8081);
    public static final EnumOption<AuthMethod> AUTHMETHOD = new EnumOption<AuthMethod>("AUTHMETHOD", AuthMethod.BASIC);

    public StaticOptions(boolean file) {
        super(file ? new IOFile(Prop.HOMEDIR, ".basex") : null);
        this.setSystem();
    }

    @Override
    public void setSystem() {
        String nph;
        String pp;
        super.setSystem();
        Prop.language = this.get(LANG);
        Prop.debug = this.get(DEBUG);
        String ph = this.get(PROXYHOST);
        if (!ph.isEmpty()) {
            Prop.setSystem("http.proxyHost", ph);
            Prop.setSystem("https.proxyHost", ph);
        }
        if (!(pp = Integer.toString(this.get(PROXYPORT))).equals("0")) {
            Prop.setSystem("http.proxyPort", pp);
            Prop.setSystem("https.proxyPort", pp);
        }
        if (!(nph = this.get(NONPROXYHOSTS)).isEmpty()) {
            Prop.setSystem("http.nonProxyHosts", nph);
        }
        if (this.get(IGNORECERT).booleanValue()) {
            IOUrl.ignoreCertificates();
        }
    }

    public String createTempDb(String name) {
        String db;
        IOFile io;
        int c = 0;
        while ((io = this.dbPath(db = name + "." + c++)).exists()) {
        }
        io.md();
        return db;
    }

    public IOFile dbPath() {
        return new IOFile(this.get(DBPATH));
    }

    public IOFile dbPath(String name) {
        return name.isEmpty() ? this.dbPath() : new IOFile(this.get(DBPATH), name);
    }

    public boolean dbExists(String db) {
        return !db.isEmpty() && this.dbPath(db).exists();
    }

    public StringList dbFiles(String db) {
        if (db.isEmpty()) {
            StringList list = new StringList();
            String pattern = ".*(\\.xml|\\.basex)$";
            for (IOFile file : this.dbPath().children(".*(\\.xml|\\.basex)$")) {
                list.add(file.name());
            }
            return list;
        }
        return this.dbPath(db).descendants();
    }

    public static enum AuthMethod {
        BASIC,
        DIGEST,
        CUSTOM;


        public String toString() {
            String name = this.name();
            return name.charAt(0) + name.substring(1).toLowerCase(Locale.ENGLISH);
        }
    }
}

