/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view;

import java.awt.Window;
import java.util.Objects;
import org.basex.core.Context;
import org.basex.core.Text;
import org.basex.data.Data;
import org.basex.gui.GUI;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.view.View;
import org.basex.gui.view.ViewData;
import org.basex.query.value.seq.DBNodes;
import org.basex.util.Array;
import org.basex.util.Performance;
import org.basex.util.Token;
import org.basex.util.Util;

public final class ViewNotifier {
    private static final long LARGEDB = 200000000L;
    public static final int MAXHIST = 20;
    public int hist;
    final GUI gui;
    private final DBNodes[] marked = new DBNodes[20];
    private final DBNodes[] cont = new DBNodes[20];
    private final String[] queries = new String[20];
    private View[] views = new View[0];
    private int histsize;

    public ViewNotifier(GUI gui) {
        this.gui = gui;
    }

    void add(View vw) {
        this.views = Array.add(this.views, vw);
    }

    public void init() {
        Data data = this.initHistory(this.gui.context);
        if (data != null) {
            long size = data.meta.dbSize();
            boolean open = false;
            for (View view : this.views) {
                open |= view.visible() && view.db();
            }
            if (open && size > 200000000L && BaseXDialog.confirm(this.gui, Util.info(Text.H_LARGE_DB, Performance.formatHuman(size)))) {
                for (View view : this.views) {
                    if (!view.visible() || !view.db()) continue;
                    view.visible(false);
                }
            }
        } else {
            for (Window win : this.gui.getOwnedWindows()) {
                BaseXDialog dialog;
                if (!win.isVisible() || !(win instanceof BaseXDialog) || !(dialog = (BaseXDialog)win).modal()) continue;
                dialog.cancel();
            }
        }
        this.gui.context.focused = -1;
        for (View view : this.views) {
            view.refreshInit();
        }
        this.gui.layoutViews();
        this.gui.setTitle();
    }

    public void focus(int pre, View vw) {
        if (this.gui.context.focused == pre) {
            return;
        }
        this.gui.context.focused = pre;
        for (View view : this.views) {
            if (view == vw || !view.visible()) continue;
            view.refreshFocus();
        }
        if (pre != -1) {
            this.gui.status.setText(Token.string(ViewData.path(this.gui.context.data(), pre)), true);
        }
    }

    public void mark(DBNodes mark, View vw) {
        Context ctx = this.gui.context;
        ctx.marked = mark;
        for (View view : this.views) {
            if (view == vw || !view.visible()) continue;
            view.refreshMark();
        }
        this.gui.refreshControls(true);
    }

    public void mark(int mode, View vw) {
        int f = this.gui.context.focused;
        if (f == -1) {
            return;
        }
        Context ctx = this.gui.context;
        DBNodes nodes = ctx.marked;
        if (mode == 0) {
            nodes = new DBNodes(ctx.data(), f);
        } else if (mode == 1) {
            nodes.union(new int[]{f});
        } else {
            nodes.toggle(f);
        }
        this.mark(nodes, vw);
    }

    public void hist(boolean forward) {
        String query;
        Context ctx = this.gui.context;
        if (forward) {
            if (this.hist == this.histsize) {
                return;
            }
            query = this.queries[++this.hist];
        } else {
            if (this.hist == 0) {
                return;
            }
            this.marked[this.hist] = ctx.marked;
            query = this.queries[--this.hist];
        }
        ctx.set(this.cont[this.hist], this.marked[this.hist]);
        this.gui.input.setText(query);
        for (View view : this.views) {
            if (!view.visible()) continue;
            view.refreshContext(forward, false);
        }
        this.gui.refreshControls(true);
    }

    public void context(DBNodes nodes, boolean quick, View vw) {
        DBNodes cmp;
        Context ctx = this.gui.context;
        DBNodes newn = nodes.discardDocs();
        DBNodes empty = new DBNodes(ctx.data(), new int[0]).ftpos(ctx.marked.ftpos());
        DBNodes curr = quick ? ctx.current() : null;
        DBNodes dBNodes = cmp = quick ? curr : ctx.marked;
        if (!Objects.equals(this.cont[this.hist], cmp)) {
            this.checkHist();
            if (quick) {
                this.queries[this.hist] = "";
                this.marked[this.hist] = new DBNodes(ctx.data(), new int[0]);
                this.cont[++this.hist] = curr;
            } else {
                String in;
                this.queries[this.hist] = in = this.gui.input.getText();
                this.marked[this.hist] = ctx.marked;
                this.cont[++this.hist] = newn;
                this.queries[this.hist] = in;
                this.marked[this.hist] = empty;
            }
            this.histsize = this.hist;
        }
        ctx.set(newn, empty);
        for (View view : this.views) {
            if (view == vw || !view.visible()) continue;
            view.refreshContext(true, quick);
        }
        this.gui.refreshControls(true);
    }

    public void update() {
        Data data = this.initHistory(this.gui.context);
        if (data == null) {
            return;
        }
        this.gui.context.marked = new DBNodes(data, new int[0]);
        for (View view : this.views) {
            if (!view.visible()) continue;
            view.refreshUpdate();
        }
        this.gui.refreshControls(true);
    }

    public void layout() {
        for (View view : this.views) {
            view.refreshLayout();
        }
    }

    public String query(boolean back) {
        return back ? (this.hist > 0 ? (this.hist > 1 ? this.queries[this.hist - 2] : "") : null) : (this.hist < this.histsize ? this.queries[this.hist + 1] : null);
    }

    private void checkHist() {
        int hl = this.queries.length;
        if (this.hist + 1 == hl) {
            Array.remove(this.queries, 0, 1, hl);
            Array.remove(this.cont, 0, 1, hl);
            Array.remove(this.marked, 0, 1, hl);
            --this.hist;
        }
    }

    private Data initHistory(Context ctx) {
        for (int h = 0; h < this.histsize; ++h) {
            this.marked[h] = null;
            this.cont[h] = null;
            this.queries[h] = null;
        }
        this.hist = 0;
        this.histsize = 0;
        Data data = ctx.data();
        if (data != null) {
            this.marked[0] = new DBNodes(data, new int[0]);
            this.queries[0] = "";
        }
        return data;
    }
}

