/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.map;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.array.ArrayBuilder;
import org.basex.query.value.array.XQArray;
import org.basex.query.value.item.Item;
import org.basex.query.value.map.XQMap;

public final class MapFind
extends StandardFunc {
    @Override
    public XQArray value(QueryContext qc) throws QueryException {
        Iter input = this.arg(0).iter(qc);
        Item key = this.toAtomItem(this.arg(1), qc);
        ArrayBuilder ab = new ArrayBuilder(qc);
        MapFind.find(input, key, ab, qc);
        return ab.array(this);
    }

    @Override
    protected Expr opt(CompileContext cc) throws QueryException {
        Expr input = this.arg(0);
        if (input.seqType().zero()) {
            return cc.voidAndReturn(input, XQArray.empty(), this.info);
        }
        return input == XQMap.empty() || input == XQArray.empty() ? XQArray.empty() : this;
    }

    private static void find(Iter iter, Item key, ArrayBuilder builder, QueryContext qc) throws QueryException {
        Item item;
        while ((item = qc.next(iter)) != null) {
            if (item instanceof XQMap) {
                XQMap map = (XQMap)item;
                Value value = map.get(key);
                if (!value.isEmpty()) {
                    builder.add(value);
                }
                map.forEach((k, val) -> MapFind.find(val.iter(), key, builder, qc));
                continue;
            }
            if (!(item instanceof XQArray)) continue;
            XQArray array = (XQArray)item;
            for (Value value : array.iterable()) {
                MapFind.find(value.iter(), key, builder, qc);
            }
        }
    }
}

