/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.var;

import org.basex.data.Data;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ExprInfo;
import org.basex.query.expr.TypeCheck;
import org.basex.query.value.Value;
import org.basex.query.value.item.QNm;
import org.basex.query.value.type.ExprType;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.SeqType;
import org.basex.util.InputInfo;
import org.basex.util.Strings;
import org.basex.util.Token;

public final class Var
extends ExprInfo {
    public final QNm name;
    public final int id;
    public final InputInfo info;
    public SeqType declType;
    int slot;
    private final ExprType exprType;
    private Expr ex;

    public Var(QNm name, SeqType declType, QueryContext qc, InputInfo info, int slot, ExprType exprType) {
        this.name = name;
        this.info = info;
        this.slot = slot;
        this.declType = declType == null || declType.eq(SeqType.ITEM_ZM) ? null : declType;
        this.exprType = exprType != null ? exprType : new ExprType(SeqType.ITEM_ZM);
        this.id = qc.varIDs++;
    }

    public Var(QNm name, SeqType declType, QueryContext qc, InputInfo info) {
        this(name, declType, qc, info, -1, null);
    }

    public Var(Var var, QueryContext qc) {
        this(var.name, var.declType, qc, var.info, -1, new ExprType(var.exprType));
    }

    public SeqType seqType() {
        SeqType it;
        SeqType st = this.exprType.seqType();
        SeqType dt = this.declType;
        SeqType seqType = it = dt != null ? dt.intersect(st) : null;
        return it != null ? it : (dt != null ? dt : st);
    }

    public void expr(Expr expr) {
        this.ex = expr;
    }

    public long size() {
        return this.exprType.size();
    }

    public boolean ddo() {
        if (this.ex != null) {
            return this.ex.ddo();
        }
        SeqType st = this.seqType();
        return st.zeroOrOne() && st.type instanceof NodeType;
    }

    public Data data() {
        return this.ex != null ? this.ex.data() : null;
    }

    public SeqType declaredType() {
        return this.declType == null ? SeqType.ITEM_ZM : this.declType;
    }

    public void refineType(SeqType st, CompileContext cc) throws QueryException {
        this.refineType(st, st.zero() ? 0L : (st.one() ? 1L : -1L), cc);
    }

    public void refineType(SeqType st, long size, CompileContext cc) throws QueryException {
        SeqType it;
        SeqType dt;
        if (this.declType != null) {
            if (this.declType.occ.intersect(st.occ) == null) {
                throw QueryError.INVCONVERT_X_X_X.get(this.info, st, this.declType, Token.concat(Character.valueOf('$'), this.name.string()));
            }
            if (st.instanceOf(this.declType)) {
                if (cc != null) {
                    cc.info("remove type check: %", this);
                }
                this.declType = null;
            } else if (!st.promotable(this.declType)) {
                return;
            }
        }
        if (!(dt = this.exprType.seqType()).instanceOf(st) && (it = dt.intersect(st)) != null) {
            this.exprType.assign(it, size);
        }
    }

    public Expr checked(Expr expr, CompileContext cc) throws QueryException {
        return this.declType != null ? new TypeCheck(this.info, expr, this.declType).optimize(cc) : expr;
    }

    public Value checkType(Value value, QueryContext qc, CompileContext cc) throws QueryException {
        return this.declType != null ? this.declType.coerce(value, this.name, qc, cc, this.info) : value;
    }

    public void checkType(Expr expr) throws QueryException {
        SeqType et = expr.seqType();
        SeqType vt = this.seqType();
        if (this.declType == null || vt.type.instanceOf(et.type) || et.type.instanceOf(vt.type) && et.occ.instanceOf(vt.occ)) {
            return;
        }
        if (!(et.type instanceof NodeType) && !et.promotable(vt)) {
            throw vt.type.nsSensitive() ? QueryError.NSSENS_X_X.get(this.info, et, vt) : QueryError.typeError(expr, vt, this.name, this.info);
        }
    }

    public boolean adoptCheck(SeqType st) {
        if (this.declType != null && !st.instanceOf(this.declType)) {
            return this.declType.instanceOf(st);
        }
        this.declType = st;
        return true;
    }

    @Override
    public void toXml(QueryPlan plan) {
        plan.add(plan.attachVariable(plan.create(this, new Object[0]), this, true), new ExprInfo[0]);
    }

    public byte[] id() {
        return Token.concat("$", this.name.string(), "_", this.id);
    }

    @Override
    public void toString(QueryString qs) {
        qs.token(this.id());
        if (this.declType != null) {
            qs.token("as").token(this.declType);
        }
    }

    @Override
    public String toErrorString() {
        return Strings.concat("$", this.name.string());
    }
}

