/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.gflwor;

import java.util.Objects;
import org.basex.query.CompileContext;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Single;
import org.basex.query.util.collation.Collation;
import org.basex.query.value.type.Types;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.hash.IntObjectMap;

public final class OrderKey
extends Single {
    final boolean desc;
    final boolean least;
    final Collation coll;

    public OrderKey(InputInfo info, Expr key, boolean desc, boolean least, Collation coll) {
        super(info, key, Types.ITEM_ZM);
        this.desc = desc;
        this.least = least;
        this.coll = coll;
    }

    @Override
    public OrderKey copy(CompileContext cc, IntObjectMap<Var> vm) {
        return this.copyType(new OrderKey(this.info, this.expr.copy(cc, vm), this.desc, this.least, this.coll));
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        this.expr = this.expr.simplifyFor(CompileContext.Simplify.DATA, cc);
        return this;
    }

    @Override
    public int exprSize() {
        return this.expr.exprSize();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof OrderKey)) return false;
        OrderKey k = (OrderKey)obj;
        if (this.desc != k.desc) return false;
        if (this.least != k.least) return false;
        if (!Objects.equals(this.coll, k.coll)) return false;
        if (!super.equals(obj)) return false;
        return true;
    }

    @Override
    public void toXml(QueryPlan plan) {
        plan.add(plan.create(this, "dir", Token.token(this.desc ? "descending" : "ascending"), Token.token("empty"), Token.token(this.least ? "least" : "greatest")), this.expr);
    }

    @Override
    public void toString(QueryString qs) {
        qs.token(this.expr);
        if (this.desc) {
            qs.token("descending");
        }
        qs.token("empty").token(this.least ? "least" : "greatest");
        if (this.coll != null) {
            qs.token("collation").token("\"").token(this.coll.uri()).token('\"');
        }
    }
}

