/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "kok" locale.
 */
public class LocalizedNamesImpl_kok extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "XA",
        "XB",
        "AI",
        "AO",
        "AQ",
        "AD",
        "AZ",
        "AF",
        "AS",
        "AW",
        "AR",
        "AX",
        "DZ",
        "AL",
        "AC",
        "EH",
        "IS",
        "IE",
        "AM",
        "QO",
        "ID",
        "EC",
        "GQ",
        "IL",
        "IT",
        "ET",
        "IQ",
        "IR",
        "ER",
        "IM",
        "EG",
        "UZ",
        "KP",
        "MP",
        "UY",
        "AG",
        "SV",
        "EE",
        "AT",
        "AU",
        "OM",
        "KH",
        "KZ",
        "QA",
        "KI",
        "KG",
        "CK",
        "CW",
        "KW",
        "CA",
        "IC",
        "CM",
        "BQ",
        "KE",
        "CV",
        "KY",
        "CD",
        "CG",
        "CC",
        "CI",
        "KM",
        "CO",
        "XK",
        "CR",
        "CU",
        "CX",
        "HR",
        "CP",
        "GY",
        "GG",
        "GW",
        "GU",
        "GN",
        "GA",
        "GM",
        "GL",
        "GR",
        "GD",
        "GT",
        "GP",
        "GH",
        "TD",
        "CL",
        "CN",
        "CZ",
        "JP",
        "JM",
        "DE",
        "JE",
        "DJ",
        "GI",
        "ZW",
        "GE",
        "JO",
        "ZM",
        "TV",
        "TO",
        "TK",
        "TG",
        "TN",
        "TT",
        "DK",
        "DO",
        "DM",
        "TJ",
        "TZ",
        "TW",
        "TL",
        "TM",
        "TR",
        "TC",
        "TA",
        "TH",
        "ZA",
        "KR",
        "GS",
        "SS",
        "DG",
        "NA",
        "NE",
        "NG",
        "NR",
        "NI",
        "NU",
        "NL",
        "NP",
        "NF",
        "NO",
        "NZ",
        "NC",
        "PA",
        "PW",
        "PK",
        "PG",
        "PN",
        "PR",
        "PT",
        "PE",
        "PS",
        "PY",
        "PL",
        "FK",
        "FJ",
        "FI",
        "PH",
        "FO",
        "FR",
        "TF",
        "GF",
        "PF",
        "BM",
        "BG",
        "BS",
        "BD",
        "BB",
        "BI",
        "BF",
        "BJ",
        "BY",
        "BZ",
        "BE",
        "BH",
        "BW",
        "BO",
        "BV",
        "BA",
        "BR",
        "VG",
        "IO",
        "BN",
        "IN",
        "BT",
        "MN",
        "MO",
        "CF",
        "MW",
        "MY",
        "MG",
        "FM",
        "MQ",
        "MH",
        "MV",
        "ML",
        "MT",
        "MD",
        "MK",
        "MX",
        "YT",
        "MZ",
        "MS",
        "ME",
        "MR",
        "MU",
        "MC",
        "MA",
        "MM",
        "UM",
        "VI",
        "UA",
        "UG",
        "AE",
        "GB",
        "UN",
        "US",
        "EZ",
        "EU",
        "YE",
        "RW",
        "RE",
        "RU",
        "RO",
        "LU",
        "LA",
        "LR",
        "LI",
        "LT",
        "LS",
        "LY",
        "LV",
        "LB",
        "VU",
        "WF",
        "VE",
        "VA",
        "VN",
        "LK",
        "PM",
        "LC",
        "SA",
        "RS",
        "WS",
        "CY",
        "ST",
        "SG",
        "SX",
        "SL",
        "EA",
        "SN",
        "SY",
        "SR",
        "SD",
        "BL",
        "MF",
        "SM",
        "KN",
        "VC",
        "SH",
        "SC",
        "SO",
        "SB",
        "ES",
        "SK",
        "SI",
        "SZ",
        "SJ",
        "CH",
        "SE",
        "HU",
        "HM",
        "HK",
        "HT",
        "HN",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "जग");
    namesMap.put("002", "आफ्रिका");
    namesMap.put("003", "उत्तर अमेरिका");
    namesMap.put("005", "दक्षिण अमेरिका");
    namesMap.put("009", "ओसेनिया");
    namesMap.put("011", "अस्तंत आफ्रिका");
    namesMap.put("013", "मध्य अमेरिका");
    namesMap.put("014", "उदेंत आफ्रिका");
    namesMap.put("015", "उत्तरीय आफ्रिका");
    namesMap.put("017", "मध्य आफ्रिका");
    namesMap.put("018", "दक्षिण आफ्रिका");
    namesMap.put("019", "अमेरिकास");
    namesMap.put("021", "उत्तरीय अमेरिका");
    namesMap.put("029", "कॅरिबियन");
    namesMap.put("030", "उदेंत आशिया");
    namesMap.put("034", "दक्षिण आशिया");
    namesMap.put("035", "आग्नेय आशिया");
    namesMap.put("039", "दक्षिण येवरोप");
    namesMap.put("053", "ऑस्ट्रेलेसिया");
    namesMap.put("054", "मेलानेसिया");
    namesMap.put("057", "मायक्रोनेशियन प्रांत");
    namesMap.put("061", "पोलिनेशिया");
    namesMap.put("142", "आशिया");
    namesMap.put("143", "मध्य आशिया");
    namesMap.put("145", "अस्तंत आशिया");
    namesMap.put("150", "येवरोप");
    namesMap.put("151", "उदेंत येवरोप");
    namesMap.put("154", "उत्तर येवरोप");
    namesMap.put("155", "अस्तंत येवरोप");
    namesMap.put("202", "उप-सहाराई आफ्रिका");
    namesMap.put("419", "लॅटीन अमेरिका");
    namesMap.put("AC", "असेशन आयलँड");
    namesMap.put("AD", "अंडोरा");
    namesMap.put("AE", "युनाइटेड अरब इमीरॅट्स");
    namesMap.put("AF", "अफगानिस्तान");
    namesMap.put("AG", "एँटिगुआ आनी बारबुडा");
    namesMap.put("AI", "अंगुला");
    namesMap.put("AL", "अल्बानीया");
    namesMap.put("AM", "आर्मीनीया");
    namesMap.put("AO", "अंगोला");
    namesMap.put("AQ", "अंटार्क्टिका");
    namesMap.put("AR", "अर्जेंटिना");
    namesMap.put("AS", "अमेरिकी सामोआ");
    namesMap.put("AT", "ऑस्ट्रिया");
    namesMap.put("AU", "ऑस्ट्रेलीया");
    namesMap.put("AW", "अरुबा");
    namesMap.put("AX", "अलांड जुवे");
    namesMap.put("AZ", "अजरबैजान");
    namesMap.put("BA", "बोस्निया आनी हेर्जेगोविना");
    namesMap.put("BB", "बारबाडोस");
    namesMap.put("BD", "बांगलादेश");
    namesMap.put("BE", "बेल्जियम");
    namesMap.put("BF", "बुर्किना फॅसो");
    namesMap.put("BG", "बल्गेरीया");
    namesMap.put("BH", "बेहरेन");
    namesMap.put("BI", "बुरुंडी");
    namesMap.put("BJ", "बेनीन");
    namesMap.put("BL", "सॅंट बार्थेल्मी");
    namesMap.put("BM", "बर्मुडा");
    namesMap.put("BN", "ब्रूनेई");
    namesMap.put("BO", "बोलिव्हिया");
    namesMap.put("BQ", "कॅरिबियन निदरलँड");
    namesMap.put("BR", "ब्राझील");
    namesMap.put("BS", "बहामास");
    namesMap.put("BT", "भूतान");
    namesMap.put("BV", "बोवट आयलँड");
    namesMap.put("BW", "बोत्सवाना");
    namesMap.put("BY", "बेलारूस");
    namesMap.put("BZ", "बेलिझ");
    namesMap.put("CA", "कॅनडा");
    namesMap.put("CC", "कोकोस (कीलिंग) आयलँड");
    namesMap.put("CD", "कोंगो - किंशासा");
    namesMap.put("CF", "मध्य अफ्रीकी लोकसत्तकराज्य");
    namesMap.put("CG", "कोंगो - ब्राझाविला");
    namesMap.put("CH", "स्विट्ज़रलैंड");
    namesMap.put("CI", "कोत द’ईवोआर");
    namesMap.put("CK", "कुक आयलँड्स");
    namesMap.put("CL", "चिली");
    namesMap.put("CM", "कॅमेरून");
    namesMap.put("CN", "चीन");
    namesMap.put("CO", "कोलंबिया");
    namesMap.put("CP", "क्लिपरटॉन आयलँड");
    namesMap.put("CR", "कोस्ता रिका");
    namesMap.put("CU", "क्युबा");
    namesMap.put("CV", "केप वर्दी");
    namesMap.put("CW", "कुरसावो");
    namesMap.put("CX", "क्रिसमस आयलँड");
    namesMap.put("CY", "सायप्रस");
    namesMap.put("CZ", "चेकिया");
    namesMap.put("DE", "जर्मनी");
    namesMap.put("DG", "दिगो गार्सिया");
    namesMap.put("DJ", "जिबूती");
    namesMap.put("DK", "डेनमार्क");
    namesMap.put("DM", "डोमिनीका");
    namesMap.put("DO", "डोमिनिकन प्रजासत्ताक");
    namesMap.put("DZ", "अल्जेरिया");
    namesMap.put("EA", "सिटा आनी मेलिल्ला");
    namesMap.put("EC", "इक्वाडोर");
    namesMap.put("EE", "एस्टोनिया");
    namesMap.put("EG", "ईजिप्त");
    namesMap.put("EH", "अस्तंत सहारा");
    namesMap.put("ER", "इरिट्रिया");
    namesMap.put("ES", "स्पेन");
    namesMap.put("ET", "इथियोपिया");
    namesMap.put("EU", "युरोपियन युनियन");
    namesMap.put("EZ", "युरोझोन");
    namesMap.put("FI", "फिनलँड");
    namesMap.put("FJ", "फिजी");
    namesMap.put("FK", "फ़ॉकलैंड आइलैंड्स");
    namesMap.put("FM", "मायक्रोनेशिया");
    namesMap.put("FO", "फैरो आयलँड्स");
    namesMap.put("FR", "फ्रान्स");
    namesMap.put("GA", "गॅबोन");
    namesMap.put("GB", "युनायटेड किंगडम");
    namesMap.put("GD", "ग्रेनॅडा");
    namesMap.put("GE", "जॉर्जिया");
    namesMap.put("GF", "फ्रेन्च गयाना");
    namesMap.put("GG", "गर्नसी");
    namesMap.put("GH", "घाना");
    namesMap.put("GI", "जिब्राल्टर");
    namesMap.put("GL", "ग्रीनलँड");
    namesMap.put("GM", "गॅम्बिया");
    namesMap.put("GN", "गुएनिया");
    namesMap.put("GP", "ग्वाडेलोप");
    namesMap.put("GQ", "इक्वेटोरियल गुएनिया");
    namesMap.put("GR", "ग्रीस");
    namesMap.put("GS", "दक्षिण जोर्जिया आनी दक्षिण सॅण्डविच आयलँड्स");
    namesMap.put("GT", "ग्वाटेमाला");
    namesMap.put("GU", "गुआम");
    namesMap.put("GW", "गुअनिया-बिसाउ");
    namesMap.put("GY", "गयाना");
    namesMap.put("HK", "हाँग काँग SAR चीन");
    namesMap.put("HM", "हर्ड आयलँड्स ऍंड मॅक्डोनाल्ड आयलँड्स");
    namesMap.put("HN", "हॉनडुरस");
    namesMap.put("HR", "क्रोयेशीया");
    namesMap.put("HT", "हैती");
    namesMap.put("HU", "हंगेरी");
    namesMap.put("IC", "कॅनरी आयलैंड्स");
    namesMap.put("ID", "इंडोनेशीया");
    namesMap.put("IE", "आयरलँड");
    namesMap.put("IL", "इज़राइल");
    namesMap.put("IM", "इसले ऑफ मॅन");
    namesMap.put("IN", "भारत");
    namesMap.put("IO", "ब्रिटिश हिंद महासागरीय क्षेत्र");
    namesMap.put("IQ", "इराक");
    namesMap.put("IR", "इरान");
    namesMap.put("IS", "आइसलैंड");
    namesMap.put("IT", "इटली");
    namesMap.put("JE", "जर्सी");
    namesMap.put("JM", "जमैका");
    namesMap.put("JO", "जॉर्डन");
    namesMap.put("JP", "जपान");
    namesMap.put("KE", "केनया");
    namesMap.put("KG", "किर्गिज़स्तान");
    namesMap.put("KH", "कंबोडिया");
    namesMap.put("KI", "किरिबाती");
    namesMap.put("KM", "कोमोरोस");
    namesMap.put("KN", "सेंट किट्स आनी नेविस");
    namesMap.put("KP", "उत्तर कोरिया");
    namesMap.put("KR", "दक्षिण कोरिया");
    namesMap.put("KW", "कुवेत");
    namesMap.put("KY", "कैमेन आइलैंड्स");
    namesMap.put("KZ", "कझाकस्तान");
    namesMap.put("LA", "लाओस");
    namesMap.put("LB", "लेबनान");
    namesMap.put("LC", "सँट लुसिया");
    namesMap.put("LI", "लिचेंस्टीन");
    namesMap.put("LK", "श्री लंका");
    namesMap.put("LR", "लायबेरीया");
    namesMap.put("LS", "लिसोथो");
    namesMap.put("LT", "लिथुआनिया");
    namesMap.put("LU", "लक्सेमबर्ग");
    namesMap.put("LV", "लॅटविया");
    namesMap.put("LY", "लीबिया");
    namesMap.put("MA", "मोरोक्को");
    namesMap.put("MC", "मोनॅको");
    namesMap.put("MD", "माल्डोवा");
    namesMap.put("ME", "मॉन्टॅनग्रो");
    namesMap.put("MF", "सॅंट मार्टिन");
    namesMap.put("MG", "माडागास्कर");
    namesMap.put("MH", "मार्शल आयलँड्स");
    namesMap.put("MK", "मॅसिडोनिया");
    namesMap.put("ML", "माली");
    namesMap.put("MM", "म्यानमार (बर्मा)");
    namesMap.put("MN", "मंगोलिया");
    namesMap.put("MO", "मकाव SAR चीन");
    namesMap.put("MP", "उत्तरी मरिना आयसलैण्ड");
    namesMap.put("MQ", "मार्टीनिक");
    namesMap.put("MR", "मॉरिटानिया");
    namesMap.put("MS", "मॉन्टसेराट");
    namesMap.put("MT", "माल्टा");
    namesMap.put("MU", "मॉरिशस");
    namesMap.put("MV", "मालदीव");
    namesMap.put("MW", "मलावी");
    namesMap.put("MX", "मेक्सिको");
    namesMap.put("MY", "मलेशिया");
    namesMap.put("MZ", "मॉझांबीक");
    namesMap.put("NA", "नामीबिया");
    namesMap.put("NC", "न्यू कॅलिडोनिया");
    namesMap.put("NE", "नायजर");
    namesMap.put("NF", "नॉरफॉक आयलँड");
    namesMap.put("NG", "नायजेरिया");
    namesMap.put("NI", "निकारगुवा");
    namesMap.put("NL", "नॅदरलँड");
    namesMap.put("NO", "नॉर्वे");
    namesMap.put("NP", "नेपाळ");
    namesMap.put("NR", "नावरू");
    namesMap.put("NU", "नीयू");
    namesMap.put("NZ", "न्युझीलॅन्ड");
    namesMap.put("OM", "ओमान");
    namesMap.put("PA", "पनामा");
    namesMap.put("PE", "पेरू");
    namesMap.put("PF", "फ्रेन्च पोलिनेसिया");
    namesMap.put("PG", "पापुआ न्यु गिनी");
    namesMap.put("PH", "फिलीपिन्झ");
    namesMap.put("PK", "पाकिस्तान");
    namesMap.put("PL", "पोलंड");
    namesMap.put("PM", "सँ. पायरे आनी मिकेलन");
    namesMap.put("PN", "पिटकॅरन आयलँड्स");
    namesMap.put("PR", "पिर्टो रिको");
    namesMap.put("PS", "पेलेस्टीनियन प्रांत");
    namesMap.put("PT", "पुर्तगाल");
    namesMap.put("PW", "पलाऊ");
    namesMap.put("PY", "पैराग्वे");
    namesMap.put("QA", "कतार");
    namesMap.put("QO", "आवटलायींग ओशेनिया");
    namesMap.put("RE", "रीयूनियन");
    namesMap.put("RO", "रोमानीया");
    namesMap.put("RS", "सर्बिया");
    namesMap.put("RU", "रूस");
    namesMap.put("RW", "रवांडा");
    namesMap.put("SA", "सऊदी अरेबिया");
    namesMap.put("SB", "सोलोमन आइलँड्स");
    namesMap.put("SC", "सेशेल्स");
    namesMap.put("SD", "सूडान");
    namesMap.put("SE", "स्वीडन");
    namesMap.put("SG", "सिंगापूर");
    namesMap.put("SH", "सेंट हेलिना");
    namesMap.put("SI", "स्लोवेनिया");
    namesMap.put("SJ", "स्वालबार्ड आनी जान मेयन");
    namesMap.put("SK", "स्लोवाकिया");
    namesMap.put("SL", "सिएरा लियॉन");
    namesMap.put("SM", "सॅन मारीनो");
    namesMap.put("SN", "सिनिगल");
    namesMap.put("SO", "सोमालिया");
    namesMap.put("SR", "सुरीनाम");
    namesMap.put("SS", "दक्षिण सुडान");
    namesMap.put("ST", "सावो टोमे आनी प्रिंसिपल");
    namesMap.put("SV", "एल साल्वाडोर");
    namesMap.put("SX", "सिंट मार्टेन");
    namesMap.put("SY", "सिरिया");
    namesMap.put("SZ", "स्वाजीलँड");
    namesMap.put("TA", "त्रिस्तान दा कुन्हा");
    namesMap.put("TC", "तुर्क्स आनी कॅकोज आयलँड्स");
    namesMap.put("TD", "चाड");
    namesMap.put("TF", "फ्रेंच दक्षिणी प्रांत");
    namesMap.put("TG", "टोगो");
    namesMap.put("TH", "थायलँड");
    namesMap.put("TJ", "तजीकिस्तान");
    namesMap.put("TK", "टोकलाऊ");
    namesMap.put("TL", "तिमोर-लेस्ते");
    namesMap.put("TM", "तुर्कमेनिस्तान");
    namesMap.put("TN", "ट्यूनीशिया");
    namesMap.put("TO", "टोंगा");
    namesMap.put("TR", "तुर्की");
    namesMap.put("TT", "ट्रिनीडाड आनी टोबॅगो");
    namesMap.put("TV", "टुवालू");
    namesMap.put("TW", "तायवान");
    namesMap.put("TZ", "तांझानिया");
    namesMap.put("UA", "युक्रेन");
    namesMap.put("UG", "युगांडा");
    namesMap.put("UM", "यु. एस. मायनर आवटलायींग आयलँड्‍स");
    namesMap.put("UN", "युनायटेड नेशन्स");
    namesMap.put("US", "युनायटेड स्टेट्स");
    namesMap.put("UY", "उरूग्वे");
    namesMap.put("UZ", "उज़्बेकिस्तान");
    namesMap.put("VA", "वॅटिकन सिटी");
    namesMap.put("VC", "सेंट विंसेंट ऐंड द ग्रेनेडाइंस");
    namesMap.put("VE", "विनेझुएला");
    namesMap.put("VG", "ब्रिटिश वर्जिन आयलँड्स");
    namesMap.put("VI", "यु. एस. वर्जिन आयलँड्‍स");
    namesMap.put("VN", "व्हिएतनाम");
    namesMap.put("VU", "वनातू");
    namesMap.put("WF", "वालिस आनी फ्यूचूना");
    namesMap.put("WS", "सामोआ");
    namesMap.put("XK", "कोसोवो");
    namesMap.put("YE", "येमेन");
    namesMap.put("YT", "मेयोट");
    namesMap.put("ZA", "दक्षिण आफ्रीका");
    namesMap.put("ZM", "झांबिया");
    namesMap.put("ZW", "जिम्बाब्वे");
    namesMap.put("ZZ", "अज्ञात प्रांत");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "जग",
        "002": "आफ्रिका",
        "003": "उत्तर अमेरिका",
        "005": "दक्षिण अमेरिका",
        "009": "ओसेनिया",
        "011": "अस्तंत आफ्रिका",
        "013": "मध्य अमेरिका",
        "014": "उदेंत आफ्रिका",
        "015": "उत्तरीय आफ्रिका",
        "017": "मध्य आफ्रिका",
        "018": "दक्षिण आफ्रिका",
        "019": "अमेरिकास",
        "021": "उत्तरीय अमेरिका",
        "029": "कॅरिबियन",
        "030": "उदेंत आशिया",
        "034": "दक्षिण आशिया",
        "035": "आग्नेय आशिया",
        "039": "दक्षिण येवरोप",
        "053": "ऑस्ट्रेलेसिया",
        "054": "मेलानेसिया",
        "057": "मायक्रोनेशियन प्रांत",
        "061": "पोलिनेशिया",
        "142": "आशिया",
        "143": "मध्य आशिया",
        "145": "अस्तंत आशिया",
        "150": "येवरोप",
        "151": "उदेंत येवरोप",
        "154": "उत्तर येवरोप",
        "155": "अस्तंत येवरोप",
        "202": "उप-सहाराई आफ्रिका",
        "419": "लॅटीन अमेरिका",
        "AC": "असेशन आयलँड",
        "AD": "अंडोरा",
        "AE": "युनाइटेड अरब इमीरॅट्स",
        "AF": "अफगानिस्तान",
        "AG": "एँटिगुआ आनी बारबुडा",
        "AI": "अंगुला",
        "AL": "अल्बानीया",
        "AM": "आर्मीनीया",
        "AO": "अंगोला",
        "AQ": "अंटार्क्टिका",
        "AR": "अर्जेंटिना",
        "AS": "अमेरिकी सामोआ",
        "AT": "ऑस्ट्रिया",
        "AU": "ऑस्ट्रेलीया",
        "AW": "अरुबा",
        "AX": "अलांड जुवे",
        "AZ": "अजरबैजान",
        "BA": "बोस्निया आनी हेर्जेगोविना",
        "BB": "बारबाडोस",
        "BD": "बांगलादेश",
        "BE": "बेल्जियम",
        "BF": "बुर्किना फॅसो",
        "BG": "बल्गेरीया",
        "BH": "बेहरेन",
        "BI": "बुरुंडी",
        "BJ": "बेनीन",
        "BL": "सॅंट बार्थेल्मी",
        "BM": "बर्मुडा",
        "BN": "ब्रूनेई",
        "BO": "बोलिव्हिया",
        "BQ": "कॅरिबियन निदरलँड",
        "BR": "ब्राझील",
        "BS": "बहामास",
        "BT": "भूतान",
        "BV": "बोवट आयलँड",
        "BW": "बोत्सवाना",
        "BY": "बेलारूस",
        "BZ": "बेलिझ",
        "CA": "कॅनडा",
        "CC": "कोकोस (कीलिंग) आयलँड",
        "CD": "कोंगो - किंशासा",
        "CF": "मध्य अफ्रीकी लोकसत्तकराज्य",
        "CG": "कोंगो - ब्राझाविला",
        "CH": "स्विट्ज़रलैंड",
        "CI": "कोत द’ईवोआर",
        "CK": "कुक आयलँड्स",
        "CL": "चिली",
        "CM": "कॅमेरून",
        "CN": "चीन",
        "CO": "कोलंबिया",
        "CP": "क्लिपरटॉन आयलँड",
        "CR": "कोस्ता रिका",
        "CU": "क्युबा",
        "CV": "केप वर्दी",
        "CW": "कुरसावो",
        "CX": "क्रिसमस आयलँड",
        "CY": "सायप्रस",
        "CZ": "चेकिया",
        "DE": "जर्मनी",
        "DG": "दिगो गार्सिया",
        "DJ": "जिबूती",
        "DK": "डेनमार्क",
        "DM": "डोमिनीका",
        "DO": "डोमिनिकन प्रजासत्ताक",
        "DZ": "अल्जेरिया",
        "EA": "सिटा आनी मेलिल्ला",
        "EC": "इक्वाडोर",
        "EE": "एस्टोनिया",
        "EG": "ईजिप्त",
        "EH": "अस्तंत सहारा",
        "ER": "इरिट्रिया",
        "ES": "स्पेन",
        "ET": "इथियोपिया",
        "EU": "युरोपियन युनियन",
        "EZ": "युरोझोन",
        "FI": "फिनलँड",
        "FJ": "फिजी",
        "FK": "फ़ॉकलैंड आइलैंड्स",
        "FM": "मायक्रोनेशिया",
        "FO": "फैरो आयलँड्स",
        "FR": "फ्रान्स",
        "GA": "गॅबोन",
        "GB": "युनायटेड किंगडम",
        "GD": "ग्रेनॅडा",
        "GE": "जॉर्जिया",
        "GF": "फ्रेन्च गयाना",
        "GG": "गर्नसी",
        "GH": "घाना",
        "GI": "जिब्राल्टर",
        "GL": "ग्रीनलँड",
        "GM": "गॅम्बिया",
        "GN": "गुएनिया",
        "GP": "ग्वाडेलोप",
        "GQ": "इक्वेटोरियल गुएनिया",
        "GR": "ग्रीस",
        "GS": "दक्षिण जोर्जिया आनी दक्षिण सॅण्डविच आयलँड्स",
        "GT": "ग्वाटेमाला",
        "GU": "गुआम",
        "GW": "गुअनिया-बिसाउ",
        "GY": "गयाना",
        "HK": "हाँग काँग SAR चीन",
        "HM": "हर्ड आयलँड्स ऍंड मॅक्डोनाल्ड आयलँड्स",
        "HN": "हॉनडुरस",
        "HR": "क्रोयेशीया",
        "HT": "हैती",
        "HU": "हंगेरी",
        "IC": "कॅनरी आयलैंड्स",
        "ID": "इंडोनेशीया",
        "IE": "आयरलँड",
        "IL": "इज़राइल",
        "IM": "इसले ऑफ मॅन",
        "IN": "भारत",
        "IO": "ब्रिटिश हिंद महासागरीय क्षेत्र",
        "IQ": "इराक",
        "IR": "इरान",
        "IS": "आइसलैंड",
        "IT": "इटली",
        "JE": "जर्सी",
        "JM": "जमैका",
        "JO": "जॉर्डन",
        "JP": "जपान",
        "KE": "केनया",
        "KG": "किर्गिज़स्तान",
        "KH": "कंबोडिया",
        "KI": "किरिबाती",
        "KM": "कोमोरोस",
        "KN": "सेंट किट्स आनी नेविस",
        "KP": "उत्तर कोरिया",
        "KR": "दक्षिण कोरिया",
        "KW": "कुवेत",
        "KY": "कैमेन आइलैंड्स",
        "KZ": "कझाकस्तान",
        "LA": "लाओस",
        "LB": "लेबनान",
        "LC": "सँट लुसिया",
        "LI": "लिचेंस्टीन",
        "LK": "श्री लंका",
        "LR": "लायबेरीया",
        "LS": "लिसोथो",
        "LT": "लिथुआनिया",
        "LU": "लक्सेमबर्ग",
        "LV": "लॅटविया",
        "LY": "लीबिया",
        "MA": "मोरोक्को",
        "MC": "मोनॅको",
        "MD": "माल्डोवा",
        "ME": "मॉन्टॅनग्रो",
        "MF": "सॅंट मार्टिन",
        "MG": "माडागास्कर",
        "MH": "मार्शल आयलँड्स",
        "MK": "मॅसिडोनिया",
        "ML": "माली",
        "MM": "म्यानमार (बर्मा)",
        "MN": "मंगोलिया",
        "MO": "मकाव SAR चीन",
        "MP": "उत्तरी मरिना आयसलैण्ड",
        "MQ": "मार्टीनिक",
        "MR": "मॉरिटानिया",
        "MS": "मॉन्टसेराट",
        "MT": "माल्टा",
        "MU": "मॉरिशस",
        "MV": "मालदीव",
        "MW": "मलावी",
        "MX": "मेक्सिको",
        "MY": "मलेशिया",
        "MZ": "मॉझांबीक",
        "NA": "नामीबिया",
        "NC": "न्यू कॅलिडोनिया",
        "NE": "नायजर",
        "NF": "नॉरफॉक आयलँड",
        "NG": "नायजेरिया",
        "NI": "निकारगुवा",
        "NL": "नॅदरलँड",
        "NO": "नॉर्वे",
        "NP": "नेपाळ",
        "NR": "नावरू",
        "NU": "नीयू",
        "NZ": "न्युझीलॅन्ड",
        "OM": "ओमान",
        "PA": "पनामा",
        "PE": "पेरू",
        "PF": "फ्रेन्च पोलिनेसिया",
        "PG": "पापुआ न्यु गिनी",
        "PH": "फिलीपिन्झ",
        "PK": "पाकिस्तान",
        "PL": "पोलंड",
        "PM": "सँ. पायरे आनी मिकेलन",
        "PN": "पिटकॅरन आयलँड्स",
        "PR": "पिर्टो रिको",
        "PS": "पेलेस्टीनियन प्रांत",
        "PT": "पुर्तगाल",
        "PW": "पलाऊ",
        "PY": "पैराग्वे",
        "QA": "कतार",
        "QO": "आवटलायींग ओशेनिया",
        "RE": "रीयूनियन",
        "RO": "रोमानीया",
        "RS": "सर्बिया",
        "RU": "रूस",
        "RW": "रवांडा",
        "SA": "सऊदी अरेबिया",
        "SB": "सोलोमन आइलँड्स",
        "SC": "सेशेल्स",
        "SD": "सूडान",
        "SE": "स्वीडन",
        "SG": "सिंगापूर",
        "SH": "सेंट हेलिना",
        "SI": "स्लोवेनिया",
        "SJ": "स्वालबार्ड आनी जान मेयन",
        "SK": "स्लोवाकिया",
        "SL": "सिएरा लियॉन",
        "SM": "सॅन मारीनो",
        "SN": "सिनिगल",
        "SO": "सोमालिया",
        "SR": "सुरीनाम",
        "SS": "दक्षिण सुडान",
        "ST": "सावो टोमे आनी प्रिंसिपल",
        "SV": "एल साल्वाडोर",
        "SX": "सिंट मार्टेन",
        "SY": "सिरिया",
        "SZ": "स्वाजीलँड",
        "TA": "त्रिस्तान दा कुन्हा",
        "TC": "तुर्क्स आनी कॅकोज आयलँड्स",
        "TD": "चाड",
        "TF": "फ्रेंच दक्षिणी प्रांत",
        "TG": "टोगो",
        "TH": "थायलँड",
        "TJ": "तजीकिस्तान",
        "TK": "टोकलाऊ",
        "TL": "तिमोर-लेस्ते",
        "TM": "तुर्कमेनिस्तान",
        "TN": "ट्यूनीशिया",
        "TO": "टोंगा",
        "TR": "तुर्की",
        "TT": "ट्रिनीडाड आनी टोबॅगो",
        "TV": "टुवालू",
        "TW": "तायवान",
        "TZ": "तांझानिया",
        "UA": "युक्रेन",
        "UG": "युगांडा",
        "UM": "यु. एस. मायनर आवटलायींग आयलँड्‍स",
        "UN": "युनायटेड नेशन्स",
        "US": "युनायटेड स्टेट्स",
        "UY": "उरूग्वे",
        "UZ": "उज़्बेकिस्तान",
        "VA": "वॅटिकन सिटी",
        "VC": "सेंट विंसेंट ऐंड द ग्रेनेडाइंस",
        "VE": "विनेझुएला",
        "VG": "ब्रिटिश वर्जिन आयलँड्स",
        "VI": "यु. एस. वर्जिन आयलँड्‍स",
        "VN": "व्हिएतनाम",
        "VU": "वनातू",
        "WF": "वालिस आनी फ्यूचूना",
        "WS": "सामोआ",
        "XK": "कोसोवो",
        "YE": "येमेन",
        "YT": "मेयोट",
        "ZA": "दक्षिण आफ्रीका",
        "ZM": "झांबिया",
        "ZW": "जिम्बाब्वे",
        "ZZ": "अज्ञात प्रांत"
    };
  }-*/;
}
