/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network;

import java.util.UUID;
import org.apache.ignite.network.ClusterNode;
import org.apache.ignite.network.NetworkAddress;
import org.apache.ignite.network.NodeMetadata;
import org.jetbrains.annotations.Nullable;

public class ClusterNodeImpl
implements ClusterNode {
    private final UUID id;
    private final String name;
    private final NetworkAddress address;
    @Nullable
    private final NodeMetadata nodeMetadata;

    public ClusterNodeImpl(UUID id, String name, NetworkAddress address, @Nullable NodeMetadata nodeMetadata) {
        this.id = id;
        this.name = name;
        this.address = address;
        this.nodeMetadata = nodeMetadata;
    }

    public ClusterNodeImpl(UUID id, String name, NetworkAddress address) {
        this(id, name, address, null);
    }

    public UUID id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public NetworkAddress address() {
        return this.address;
    }

    @Nullable
    public NodeMetadata nodeMetadata() {
        return this.nodeMetadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterNodeImpl that = (ClusterNodeImpl)o;
        return this.name.equals(that.name) && this.address.equals((Object)that.address);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.address.hashCode();
        return result;
    }

    public String toString() {
        return String.format("{id=%s, name=%s, address=%s}", this.id, this.name, this.address);
    }
}

