/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.sql;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.ignite.internal.catalog.sql.AbstractCatalogQuery;
import org.apache.ignite.internal.catalog.sql.Option;
import org.apache.ignite.internal.catalog.sql.QueryContext;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.sql.IgniteSql;
import org.apache.ignite.sql.SqlRow;
import org.apache.ignite.sql.async.AsyncResultSet;

class SelectFromView<T>
extends AbstractCatalogQuery<List<T>> {
    private final String viewName;
    private final List<String> columns;
    private final List<Option> whereOptions = new ArrayList<Option>();
    private final Function<SqlRow, T> mapper;

    SelectFromView(IgniteSql sql, List<String> columns, String viewName, Option whereOption, Function<SqlRow, T> mapper) {
        this(sql, columns, viewName, List.of(whereOption), mapper);
    }

    SelectFromView(IgniteSql sql, List<String> columns, String viewName, List<Option> whereOptions, Function<SqlRow, T> mapper) {
        super(sql);
        this.viewName = viewName;
        this.columns = columns;
        this.whereOptions.addAll(whereOptions);
        this.mapper = mapper;
    }

    @Override
    public CompletableFuture<List<T>> executeAsync() {
        return this.sql.executeAsync(null, this.toString(), new Object[0]).thenCompose(resultSet -> {
            ArrayList result = new ArrayList();
            return this.iterate((AsyncResultSet<SqlRow>)resultSet, result).thenApply(unused -> result);
        });
    }

    private CompletableFuture<Void> iterate(AsyncResultSet<SqlRow> resultSet, List<T> result) {
        for (SqlRow row : resultSet.currentPage()) {
            result.add(this.mapper.apply(row));
        }
        if (resultSet.hasMorePages()) {
            return resultSet.fetchNextPage().thenCompose(nextPage -> this.iterate((AsyncResultSet<SqlRow>)nextPage, result));
        }
        return CompletableFutures.nullCompletedFuture();
    }

    @Override
    protected List<T> result() {
        return Collections.emptyList();
    }

    @Override
    protected void accept(QueryContext ctx) {
        ctx.sql("SELECT " + String.join((CharSequence)", ", this.columns) + " FROM SYSTEM." + this.viewName + " ");
        if (!this.whereOptions.isEmpty()) {
            ctx.sql("WHERE ");
            for (Option option : this.whereOptions) {
                option.accept(ctx);
            }
        }
        System.out.println("SELECT");
        System.out.println(ctx.getSql());
    }
}

