/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator.network.raft;

import java.util.List;
import java.util.UUID;
import org.apache.ignite3.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;
import org.apache.ignite3.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite3.internal.partition.replicator.network.raft.SnapshotTxDataResponse;
import org.apache.ignite3.internal.partition.replicator.network.raft.SnapshotTxDataResponseBuilder;
import org.apache.ignite3.internal.tx.message.TxMetaMessage;

class SnapshotTxDataResponseDeserializer
implements MessageDeserializer<SnapshotTxDataResponse> {
    private final SnapshotTxDataResponseBuilder msg;

    SnapshotTxDataResponseDeserializer(PartitionReplicationMessagesFactory messageFactory) {
        this.msg = messageFactory.snapshotTxDataResponse();
    }

    @Override
    public Class<SnapshotTxDataResponse> klass() {
        return SnapshotTxDataResponse.class;
    }

    @Override
    public SnapshotTxDataResponse getMessage() {
        return this.msg.build();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                boolean tmp = reader.readBoolean("finish");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.finish(tmp);
                reader.incrementState();
            }
            case 1: {
                Object tmp = reader.readList("txIds", MessageCollectionItemType.UUID);
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.txIds((List<UUID>)tmp);
                reader.incrementState();
            }
            case 2: {
                Object tmp = reader.readList("txMeta", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.txMeta((List<TxMetaMessage>)tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(SnapshotTxDataResponse.class);
    }
}

