/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public abstract class DataTypeDescription
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=14525");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=125");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=14796");
    public static final ExpandedNodeId JSON_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=15057");
    private final NodeId dataTypeId;
    private final QualifiedName name;

    public DataTypeDescription(NodeId dataTypeId, QualifiedName name) {
        this.dataTypeId = dataTypeId;
        this.name = name;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public NodeId getDataTypeId() {
        return this.dataTypeId;
    }

    public QualifiedName getName() {
        return this.name;
    }

    protected DataTypeDescription(DataTypeDescriptionBuilder<?, ?> b) {
        super(b);
        this.dataTypeId = ((DataTypeDescriptionBuilder)b).dataTypeId;
        this.name = ((DataTypeDescriptionBuilder)b).name;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataTypeDescription)) {
            return false;
        }
        DataTypeDescription other = (DataTypeDescription)o;
        if (!other.canEqual(this)) {
            return false;
        }
        NodeId this$dataTypeId = this.getDataTypeId();
        NodeId other$dataTypeId = other.getDataTypeId();
        if (this$dataTypeId == null ? other$dataTypeId != null : !((Object)this$dataTypeId).equals(other$dataTypeId)) {
            return false;
        }
        QualifiedName this$name = this.getName();
        QualifiedName other$name = other.getName();
        return !(this$name == null ? other$name != null : !((Object)this$name).equals(other$name));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataTypeDescription;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        NodeId $dataTypeId = this.getDataTypeId();
        result = result * 59 + ($dataTypeId == null ? 43 : ((Object)$dataTypeId).hashCode());
        QualifiedName $name = this.getName();
        result = result * 59 + ($name == null ? 43 : ((Object)$name).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "DataTypeDescription(dataTypeId=" + this.getDataTypeId() + ", name=" + this.getName() + ")";
    }

    public static abstract class DataTypeDescriptionBuilder<C extends DataTypeDescription, B extends DataTypeDescriptionBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private NodeId dataTypeId;
        private QualifiedName name;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            DataTypeDescriptionBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(DataTypeDescription instance, DataTypeDescriptionBuilder<?, ?> b) {
            b.dataTypeId(instance.dataTypeId);
            b.name(instance.name);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B dataTypeId(NodeId dataTypeId) {
            this.dataTypeId = dataTypeId;
            return (B)this.self();
        }

        public B name(QualifiedName name) {
            this.name = name;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "DataTypeDescription.DataTypeDescriptionBuilder(super=" + super.toString() + ", dataTypeId=" + this.dataTypeId + ", name=" + this.name + ")";
        }
    }
}

