/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.Serializable;
import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.LazyCharIterable;
import org.eclipse.collections.api.LazyFloatIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.primitive.MutableCharBag;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction0;
import org.eclipse.collections.api.block.function.primitive.CharToCharFunction;
import org.eclipse.collections.api.block.function.primitive.CharToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.FloatCharToCharFunction;
import org.eclipse.collections.api.block.function.primitive.FloatToCharFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.CharPredicate;
import org.eclipse.collections.api.block.predicate.primitive.FloatCharPredicate;
import org.eclipse.collections.api.block.procedure.primitive.CharProcedure;
import org.eclipse.collections.api.block.procedure.primitive.FloatCharProcedure;
import org.eclipse.collections.api.block.procedure.primitive.FloatProcedure;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.iterator.MutableCharIterator;
import org.eclipse.collections.api.list.primitive.MutableCharList;
import org.eclipse.collections.api.map.primitive.FloatCharMap;
import org.eclipse.collections.api.map.primitive.ImmutableFloatCharMap;
import org.eclipse.collections.api.map.primitive.MutableCharFloatMap;
import org.eclipse.collections.api.map.primitive.MutableFloatCharMap;
import org.eclipse.collections.api.set.primitive.MutableCharSet;
import org.eclipse.collections.api.set.primitive.MutableFloatSet;
import org.eclipse.collections.api.tuple.primitive.FloatCharPair;
import org.eclipse.collections.impl.SynchronizedRichIterable;
import org.eclipse.collections.impl.collection.mutable.primitive.SynchronizedCharCollection;
import org.eclipse.collections.impl.factory.primitive.FloatCharMaps;
import org.eclipse.collections.impl.map.mutable.primitive.UnmodifiableFloatCharMap;
import org.eclipse.collections.impl.set.mutable.primitive.SynchronizedFloatSet;

public class SynchronizedFloatCharMap
implements MutableFloatCharMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Object lock;
    private final MutableFloatCharMap map;

    public SynchronizedFloatCharMap(MutableFloatCharMap map) {
        this(map, null);
    }

    public SynchronizedFloatCharMap(MutableFloatCharMap map, Object newLock) {
        if (map == null) {
            throw new IllegalArgumentException("Cannot create a SynchronizedFloatCharMap on a null map");
        }
        this.map = map;
        this.lock = newLock == null ? this : newLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.map.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(float key, char value) {
        Object object = this.lock;
        synchronized (object) {
            this.map.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putPair(FloatCharPair keyValuePair) {
        Object object = this.lock;
        synchronized (object) {
            this.map.put(keyValuePair.getOne(), keyValuePair.getTwo());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(FloatCharMap map) {
        Object object = this.lock;
        synchronized (object) {
            this.map.putAll(map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateValues(FloatCharToCharFunction function) {
        Object object = this.lock;
        synchronized (object) {
            this.map.updateValues(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeKey(float key) {
        Object object = this.lock;
        synchronized (object) {
            this.map.removeKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(float key) {
        Object object = this.lock;
        synchronized (object) {
            this.map.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char removeKeyIfAbsent(float key, char value) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.removeKeyIfAbsent(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char getIfAbsentPut(float key, char value) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.getIfAbsentPut(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char getAndPut(float key, char putValue, char defaultValue) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.getAndPut(key, putValue, defaultValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char getIfAbsentPut(float key, CharFunction0 function) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.getIfAbsentPut(key, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char getIfAbsentPutWithKey(float key, FloatToCharFunction function) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.getIfAbsentPutWithKey(key, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <P> char getIfAbsentPutWith(float key, CharFunction<? super P> function, P parameter) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.getIfAbsentPutWith(key, function, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char updateValue(float key, char initialValueIfAbsent, CharToCharFunction function) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.updateValue(key, initialValueIfAbsent, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char get(float key) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char getIfAbsent(float key, char ifAbsent) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.getIfAbsent(key, ifAbsent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char getOrThrow(float key) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.getOrThrow(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(float key) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(char value) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.containsValue(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forEachValue(CharProcedure procedure) {
        Object object = this.lock;
        synchronized (object) {
            this.map.forEachValue(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forEachKey(FloatProcedure procedure) {
        Object object = this.lock;
        synchronized (object) {
            this.map.forEachKey(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forEachKeyValue(FloatCharProcedure procedure) {
        Object object = this.lock;
        synchronized (object) {
            this.map.forEachKeyValue(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LazyFloatIterable keysView() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.keysView();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RichIterable<FloatCharPair> keyValuesView() {
        Object object = this.lock;
        synchronized (object) {
            return SynchronizedRichIterable.of(this.map.keyValuesView(), this.lock).asLazy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableCharFloatMap flipUniqueValues() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.flipUniqueValues();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableFloatCharMap select(FloatCharPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.select(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableFloatCharMap reject(FloatCharPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.reject(predicate);
        }
    }

    @Override
    public MutableCharIterator charIterator() {
        return this.map.charIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void each(CharProcedure procedure) {
        Object object = this.lock;
        synchronized (object) {
            this.map.forEach(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int count(CharPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.count(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean anySatisfy(CharPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.anySatisfy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean allSatisfy(CharPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.allSatisfy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean noneSatisfy(CharPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.noneSatisfy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableCharBag select(CharPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.select(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableCharBag reject(CharPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.reject(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> MutableBag<V> collect(CharToObjectFunction<? extends V> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.collect((CharToObjectFunction)function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char detectIfNone(CharPredicate predicate, char ifNone) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.detectIfNone(predicate, ifNone);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long sum() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.sum();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char max() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.max();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char maxIfEmpty(char defaultValue) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.maxIfEmpty(defaultValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char min() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.min();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char minIfEmpty(char defaultValue) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.minIfEmpty(defaultValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double average() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.average();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double median() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.median();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char addToValue(float key, char toBeAdded) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.addToValue(key, toBeAdded);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char[] toSortedArray() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.toSortedArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableCharList toSortedList() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.toSortedList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char[] toArray() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char[] toArray(char[] target) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.toArray(target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(char value) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.contains(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(char ... source) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.containsAll(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(CharIterable source) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.containsAll(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableCharList toList() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.toList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableCharSet toSet() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.toSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableCharBag toBag() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.toBag();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LazyCharIterable asLazy() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.asLazy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableFloatCharMap withKeyValue(float key, char value) {
        Object object = this.lock;
        synchronized (object) {
            this.map.withKeyValue(key, value);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableFloatCharMap withoutKey(float key) {
        Object object = this.lock;
        synchronized (object) {
            this.map.withoutKey(key);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableFloatCharMap withoutAllKeys(FloatIterable keys) {
        Object object = this.lock;
        synchronized (object) {
            this.map.withoutAllKeys(keys);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableFloatCharMap asUnmodifiable() {
        Object object = this.lock;
        synchronized (object) {
            return new UnmodifiableFloatCharMap(this);
        }
    }

    @Override
    public MutableFloatCharMap asSynchronized() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutableFloatCharMap toImmutable() {
        Object object = this.lock;
        synchronized (object) {
            return FloatCharMaps.immutable.withAll(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean notEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.notEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableFloatSet keySet() {
        Object object = this.lock;
        synchronized (object) {
            return SynchronizedFloatSet.of(this.map.keySet(), this.lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableCharCollection values() {
        Object object = this.lock;
        synchronized (object) {
            return SynchronizedCharCollection.of(this.map.values(), this.lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object otherMap) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.equals(otherMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String makeString() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.makeString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String makeString(String separator) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.makeString(separator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String makeString(String start, String separator, String end) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.makeString(start, separator, end);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendString(Appendable appendable) {
        Object object = this.lock;
        synchronized (object) {
            this.map.appendString(appendable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendString(Appendable appendable, String separator) {
        Object object = this.lock;
        synchronized (object) {
            this.map.appendString(appendable, separator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        Object object = this.lock;
        synchronized (object) {
            this.map.appendString(appendable, start, separator, end);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T injectInto(T injectedValue, ObjectCharToObjectFunction<? super T, ? extends T> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.injectInto(injectedValue, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RichIterable<CharIterable> chunk(int size) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.chunk(size);
        }
    }
}

