/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.Rule;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.Util;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.Patterns;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.ProjectNode;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Capture;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Captures;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Pattern;

public abstract class ProjectOffPushDownRule<N extends PlanNode>
implements Rule<ProjectNode> {
    private final Capture<N> targetCapture = Capture.newCapture();
    private final Pattern<N> targetPattern;

    protected ProjectOffPushDownRule(Pattern<N> targetPattern) {
        this.targetPattern = targetPattern;
    }

    @Override
    public Pattern<ProjectNode> getPattern() {
        return Patterns.project().with(Patterns.source().matching(this.targetPattern.capturedAs(this.targetCapture)));
    }

    @Override
    public Rule.Result apply(ProjectNode parent, Captures captures, Rule.Context context) {
        PlanNode targetNode = (PlanNode)captures.get(this.targetCapture);
        return Util.pruneInputs(targetNode.getOutputSymbols(), parent.getAssignments().getExpressions()).flatMap(prunedOutputs -> this.pushDownProjectOff(context, (N)targetNode, (Set<Symbol>)prunedOutputs)).map(newChild -> parent.replaceChildren((List<PlanNode>)ImmutableList.of((Object)newChild))).map(Rule.Result::ofPlanNode).orElse(Rule.Result.empty());
    }

    protected abstract Optional<PlanNode> pushDownProjectOff(Rule.Context var1, N var2, Set<Symbol> var3);
}

