/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.pipe;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeMeta;
import org.apache.iotdb.confignode.manager.pipe.metric.overview.PipeProcedureMetrics;
import org.apache.iotdb.confignode.persistence.pipe.PipeTaskInfo;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.exception.ProcedureException;
import org.apache.iotdb.confignode.procedure.impl.StateMachineProcedure;
import org.apache.iotdb.confignode.procedure.impl.node.AbstractNodeProcedure;
import org.apache.iotdb.confignode.procedure.impl.pipe.PipeTaskOperation;
import org.apache.iotdb.confignode.procedure.impl.pipe.runtime.PipeMetaSyncProcedure;
import org.apache.iotdb.confignode.procedure.state.ProcedureLockState;
import org.apache.iotdb.confignode.procedure.state.pipe.task.OperatePipeTaskState;
import org.apache.iotdb.confignode.rpc.thrift.TDatabaseSchema;
import org.apache.iotdb.confignode.service.ConfigNode;
import org.apache.iotdb.db.pipe.source.dataregion.DataRegionListeningFilter;
import org.apache.iotdb.mpp.rpc.thrift.TPushPipeMetaResp;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOperatePipeProcedureV2
extends AbstractNodeProcedure<OperatePipeTaskState> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractOperatePipeProcedureV2.class);
    private static final int RETRY_THRESHOLD = 1;
    protected boolean isRollbackFromOperateOnDataNodesSuccessful = false;
    protected boolean isRollbackFromValidateTaskSuccessful = false;
    protected AtomicReference<PipeTaskInfo> pipeTaskInfo;
    private static final String SKIP_PIPE_PROCEDURE_MESSAGE = "Try to start a RUNNING pipe or stop a STOPPED pipe, do nothing.";

    protected AtomicReference<PipeTaskInfo> acquireLockInternal(ConfigNodeProcedureEnv configNodeProcedureEnv) {
        return configNodeProcedureEnv.getConfigManager().getPipeManager().getPipeTaskCoordinator().lock();
    }

    @Override
    protected ProcedureLockState acquireLock(ConfigNodeProcedureEnv configNodeProcedureEnv) {
        LOGGER.debug("ProcedureId {} try to acquire pipe lock.", (Object)this.getProcId());
        this.pipeTaskInfo = this.acquireLockInternal(configNodeProcedureEnv);
        if (this.pipeTaskInfo == null) {
            LOGGER.warn("ProcedureId {} failed to acquire pipe lock.", (Object)this.getProcId());
        } else {
            LOGGER.debug("ProcedureId {} acquired pipe lock.", (Object)this.getProcId());
        }
        ProcedureLockState procedureLockState = super.acquireLock(configNodeProcedureEnv);
        switch (procedureLockState) {
            case LOCK_ACQUIRED: {
                if (this.pipeTaskInfo == null) {
                    LOGGER.warn("ProcedureId {}: LOCK_ACQUIRED. The following procedure should not be executed without pipe lock.", (Object)this.getProcId());
                    break;
                }
                LOGGER.debug("ProcedureId {}: LOCK_ACQUIRED. The following procedure should be executed with pipe lock.", (Object)this.getProcId());
                break;
            }
            case LOCK_EVENT_WAIT: {
                if (this.pipeTaskInfo == null) {
                    LOGGER.warn("ProcedureId {}: LOCK_EVENT_WAIT. Without acquiring pipe lock.", (Object)this.getProcId());
                    break;
                }
                LOGGER.debug("ProcedureId {}: LOCK_EVENT_WAIT. Pipe lock will be released.", (Object)this.getProcId());
                configNodeProcedureEnv.getConfigManager().getPipeManager().getPipeTaskCoordinator().unlock();
                this.pipeTaskInfo = null;
                break;
            }
            default: {
                if (this.pipeTaskInfo == null) {
                    LOGGER.error("ProcedureId {}: {}. Invalid lock state. Without acquiring pipe lock.", (Object)this.getProcId(), (Object)procedureLockState);
                    break;
                }
                LOGGER.error("ProcedureId {}: {}. Invalid lock state. Pipe lock will be released.", (Object)this.getProcId(), (Object)procedureLockState);
                configNodeProcedureEnv.getConfigManager().getPipeManager().getPipeTaskCoordinator().unlock();
                this.pipeTaskInfo = null;
            }
        }
        return procedureLockState;
    }

    @Override
    protected void releaseLock(ConfigNodeProcedureEnv configNodeProcedureEnv) {
        super.releaseLock(configNodeProcedureEnv);
        if (this.pipeTaskInfo == null) {
            LOGGER.warn("ProcedureId {} release lock. No need to release pipe lock.", (Object)this.getProcId());
        } else {
            LOGGER.debug("ProcedureId {} release lock. Pipe lock will be released.", (Object)this.getProcId());
            if (this instanceof PipeMetaSyncProcedure) {
                configNodeProcedureEnv.getConfigManager().getPipeManager().getPipeTaskCoordinator().updateLastSyncedVersion();
            }
            PipeProcedureMetrics.getInstance().updateTimer(this.getOperation().getName(), this.elapsedTime());
            configNodeProcedureEnv.getConfigManager().getPipeManager().getPipeTaskCoordinator().unlock();
            this.pipeTaskInfo = null;
        }
    }

    protected abstract PipeTaskOperation getOperation();

    public abstract boolean executeFromValidateTask(ConfigNodeProcedureEnv var1) throws PipeException;

    public abstract void executeFromCalculateInfoForTask(ConfigNodeProcedureEnv var1);

    public abstract void executeFromWriteConfigNodeConsensus(ConfigNodeProcedureEnv var1) throws PipeException;

    public abstract void executeFromOperateOnDataNodes(ConfigNodeProcedureEnv var1) throws PipeException, IOException;

    @Override
    protected StateMachineProcedure.Flow executeFromState(ConfigNodeProcedureEnv env, OperatePipeTaskState state) throws InterruptedException {
        if (this.pipeTaskInfo == null) {
            LOGGER.warn("ProcedureId {}: Pipe lock is not acquired, executeFromState's execution will be skipped.", (Object)this.getProcId());
            return StateMachineProcedure.Flow.NO_MORE_STATE;
        }
        try {
            switch (state) {
                case VALIDATE_TASK: {
                    if (!this.executeFromValidateTask(env)) {
                        LOGGER.info("ProcedureId {}: {}", (Object)this.getProcId(), (Object)SKIP_PIPE_PROCEDURE_MESSAGE);
                        this.setResult(SKIP_PIPE_PROCEDURE_MESSAGE.getBytes(StandardCharsets.UTF_8));
                        return StateMachineProcedure.Flow.NO_MORE_STATE;
                    }
                    this.setNextState(OperatePipeTaskState.CALCULATE_INFO_FOR_TASK);
                    break;
                }
                case CALCULATE_INFO_FOR_TASK: {
                    this.executeFromCalculateInfoForTask(env);
                    this.setNextState(OperatePipeTaskState.WRITE_CONFIG_NODE_CONSENSUS);
                    break;
                }
                case WRITE_CONFIG_NODE_CONSENSUS: {
                    this.executeFromWriteConfigNodeConsensus(env);
                    this.setNextState(OperatePipeTaskState.OPERATE_ON_DATA_NODES);
                    break;
                }
                case OPERATE_ON_DATA_NODES: {
                    this.executeFromOperateOnDataNodes(env);
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                default: {
                    throw new UnsupportedOperationException(String.format("Unknown state during executing operatePipeProcedure, %s", new Object[]{state}));
                }
            }
        }
        catch (Exception e) {
            if (this.getCycles() < 1) {
                LOGGER.warn("ProcedureId {}: Encountered error when trying to {} at state [{}], retry [{}/{}]", new Object[]{this.getProcId(), this.getOperation(), state, this.getCycles() + 1, 1, e});
                this.setNextState((OperatePipeTaskState)((Object)this.getCurrentState()));
                TimeUnit.MILLISECONDS.sleep(3000L);
            }
            LOGGER.warn("ProcedureId {}: All {} retries failed when trying to {} at state [{}], will rollback...", new Object[]{this.getProcId(), 1, this.getOperation(), state, e});
            this.setFailure(new ProcedureException(String.format("ProcedureId %s: Fail to %s because %s", this.getProcId(), this.getOperation().name(), e.getMessage())));
            return StateMachineProcedure.Flow.NO_MORE_STATE;
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    @Override
    protected boolean isRollbackSupported(OperatePipeTaskState state) {
        return true;
    }

    @Override
    protected void rollbackState(ConfigNodeProcedureEnv env, OperatePipeTaskState state) throws IOException, InterruptedException, ProcedureException {
        if (this.pipeTaskInfo == null) {
            LOGGER.warn("ProcedureId {}: Pipe lock is not acquired, rollbackState({})'s execution will be skipped.", (Object)this.getProcId(), (Object)state);
            return;
        }
        switch (state) {
            case VALIDATE_TASK: {
                if (this.isRollbackFromValidateTaskSuccessful) break;
                try {
                    this.rollbackFromValidateTask(env);
                    this.isRollbackFromValidateTaskSuccessful = true;
                }
                catch (Exception e) {
                    LOGGER.warn("ProcedureId {}: Failed to rollback from validate task.", (Object)this.getProcId(), (Object)e);
                }
                break;
            }
            case CALCULATE_INFO_FOR_TASK: {
                try {
                    this.rollbackFromCalculateInfoForTask(env);
                }
                catch (Exception e) {
                    LOGGER.warn("ProcedureId {}: Failed to rollback from calculate info for task.", (Object)this.getProcId(), (Object)e);
                }
                break;
            }
            case WRITE_CONFIG_NODE_CONSENSUS: {
                try {
                    if (this.isRollbackFromOperateOnDataNodesSuccessful) break;
                    this.rollbackFromWriteConfigNodeConsensus(env);
                }
                catch (Exception e) {
                    LOGGER.warn("ProcedureId {}: Failed to rollback from write config node consensus.", (Object)this.getProcId(), (Object)e);
                }
                break;
            }
            case OPERATE_ON_DATA_NODES: {
                try {
                    this.rollbackFromWriteConfigNodeConsensus(env);
                    this.rollbackFromOperateOnDataNodes(env);
                    this.isRollbackFromOperateOnDataNodesSuccessful = true;
                }
                catch (Exception e) {
                    LOGGER.warn("ProcedureId {}: Failed to rollback from operate on data nodes.", (Object)this.getProcId(), (Object)e);
                }
                break;
            }
            default: {
                LOGGER.error("Unsupported roll back STATE [{}]", (Object)state);
            }
        }
    }

    public abstract void rollbackFromValidateTask(ConfigNodeProcedureEnv var1);

    public abstract void rollbackFromCalculateInfoForTask(ConfigNodeProcedureEnv var1);

    public abstract void rollbackFromWriteConfigNodeConsensus(ConfigNodeProcedureEnv var1);

    public abstract void rollbackFromOperateOnDataNodes(ConfigNodeProcedureEnv var1) throws IOException;

    @Override
    protected OperatePipeTaskState getState(int stateId) {
        return OperatePipeTaskState.values()[stateId];
    }

    @Override
    protected int getStateId(OperatePipeTaskState state) {
        return state.ordinal();
    }

    @Override
    protected OperatePipeTaskState getInitialState() {
        return OperatePipeTaskState.VALIDATE_TASK;
    }

    protected Map<Integer, TPushPipeMetaResp> pushPipeMetaToDataNodes(ConfigNodeProcedureEnv env) throws IOException {
        ArrayList<ByteBuffer> pipeMetaBinaryList = new ArrayList<ByteBuffer>();
        for (PipeMeta pipeMeta : this.pipeTaskInfo.get().getPipeMetaList()) {
            pipeMetaBinaryList.add(AbstractOperatePipeProcedureV2.copyAndFilterOutNonWorkingDataRegionPipeTasks(pipeMeta).serialize());
        }
        return env.pushAllPipeMetaToDataNodes(pipeMetaBinaryList);
    }

    public static Map<Integer, TPushPipeMetaResp> pushPipeMetaToDataNodes(ConfigNodeProcedureEnv env, AtomicReference<PipeTaskInfo> pipeTaskInfo) throws IOException {
        ArrayList<ByteBuffer> pipeMetaBinaryList = new ArrayList<ByteBuffer>();
        for (PipeMeta pipeMeta : pipeTaskInfo.get().getPipeMetaList()) {
            pipeMetaBinaryList.add(AbstractOperatePipeProcedureV2.copyAndFilterOutNonWorkingDataRegionPipeTasks(pipeMeta).serialize());
        }
        return env.pushAllPipeMetaToDataNodes(pipeMetaBinaryList);
    }

    public static String parsePushPipeMetaExceptionForPipe(String pipeName, Map<Integer, TPushPipeMetaResp> respMap) {
        StringBuilder exceptionMessageBuilder = new StringBuilder();
        StringBuilder enoughMemoryMessageBuilder = new StringBuilder();
        for (Map.Entry<Integer, TPushPipeMetaResp> respEntry : respMap.entrySet()) {
            int dataNodeId = respEntry.getKey();
            TPushPipeMetaResp resp = respEntry.getValue();
            if (resp.getStatus().getCode() == TSStatusCode.PIPE_PUSH_META_NOT_ENOUGH_MEMORY.getStatusCode()) {
                exceptionMessageBuilder.append(String.format("DataNodeId: %s,", dataNodeId));
                resp.getExceptionMessages().forEach(message -> {
                    if (pipeName == null) {
                        enoughMemoryMessageBuilder.append(String.format("PipeName: %s, Message: %s", message.getPipeName(), message.getMessage()));
                    } else if (pipeName.equals(message.getPipeName())) {
                        enoughMemoryMessageBuilder.append(String.format("Message: %s", message.getMessage()));
                    }
                });
                enoughMemoryMessageBuilder.append(".");
                continue;
            }
            if (resp.getStatus().getCode() == TSStatusCode.PIPE_PUSH_META_TIMEOUT.getStatusCode()) {
                exceptionMessageBuilder.append(String.format("DataNodeId: %s, Message: Timeout to wait for lock while processing pushPipeMeta on dataNodes.", dataNodeId));
                continue;
            }
            if (resp.getStatus().getCode() != TSStatusCode.PIPE_PUSH_META_ERROR.getStatusCode()) continue;
            if (!resp.isSetExceptionMessages()) {
                exceptionMessageBuilder.append(String.format("DataNodeId: %s, Message: Internal error while processing pushPipeMeta on dataNodes.", dataNodeId));
                continue;
            }
            AtomicBoolean hasException = new AtomicBoolean(false);
            resp.getExceptionMessages().forEach(message -> {
                if (pipeName == null) {
                    hasException.set(true);
                    exceptionMessageBuilder.append(String.format("PipeName: %s, Message: %s", message.getPipeName(), message.getMessage()));
                } else if (pipeName.equals(message.getPipeName())) {
                    hasException.set(true);
                    exceptionMessageBuilder.append(String.format("Message: %s", message.getMessage()));
                }
            });
            if (!hasException.get()) continue;
            exceptionMessageBuilder.insert(0, String.format("DataNodeId: %s, ", dataNodeId));
            exceptionMessageBuilder.append(". ");
        }
        String enoughMemoryMessage = enoughMemoryMessageBuilder.toString();
        if (!enoughMemoryMessage.isEmpty()) {
            throw new PipeException(enoughMemoryMessage);
        }
        return exceptionMessageBuilder.toString();
    }

    protected void pushPipeMetaToDataNodesIgnoreException(ConfigNodeProcedureEnv env) {
        try {
            this.pushPipeMetaToDataNodes(env);
        }
        catch (Exception e) {
            LOGGER.info("Failed to push pipe meta list to data nodes, will retry later.", (Throwable)e);
        }
    }

    protected Map<Integer, TPushPipeMetaResp> pushSinglePipeMetaToDataNodes(String pipeName, ConfigNodeProcedureEnv env) throws IOException {
        return env.pushSinglePipeMetaToDataNodes(AbstractOperatePipeProcedureV2.copyAndFilterOutNonWorkingDataRegionPipeTasks(this.pipeTaskInfo.get().getPipeMetaByPipeName(pipeName)).serialize());
    }

    protected Map<Integer, TPushPipeMetaResp> dropSinglePipeOnDataNodes(String pipeName, ConfigNodeProcedureEnv env) {
        return env.dropSinglePipeOnDataNodes(pipeName);
    }

    public static PipeMeta copyAndFilterOutNonWorkingDataRegionPipeTasks(PipeMeta originalPipeMeta) throws IOException {
        PipeMeta copiedPipeMeta = originalPipeMeta.deepCopy4TaskAgent();
        copiedPipeMeta.getRuntimeMeta().getConsensusGroupId2TaskMetaMap().entrySet().removeIf(consensusGroupId2TaskMeta -> {
            boolean isTableModel;
            String database;
            if (originalPipeMeta.getStaticMeta().isSourceExternal()) {
                return false;
            }
            try {
                database = ConfigNode.getInstance().getConfigManager().getPartitionManager().getRegionDatabase(new TConsensusGroupId(TConsensusGroupType.DataRegion, ((Integer)consensusGroupId2TaskMeta.getKey()).intValue()));
                if (database == null) {
                    return false;
                }
            }
            catch (Exception ignore) {
                return false;
            }
            try {
                TDatabaseSchema schema = ConfigNode.getInstance().getConfigManager().getClusterSchemaManager().getDatabaseSchemaByName(database);
                if (schema == null) {
                    return false;
                }
                isTableModel = schema.isIsTableModel();
            }
            catch (Exception ignore) {
                return false;
            }
            try {
                return !DataRegionListeningFilter.shouldDatabaseBeListened((PipeParameters)copiedPipeMeta.getStaticMeta().getSourceParameters(), (boolean)isTableModel, (String)database);
            }
            catch (Exception e) {
                return false;
            }
        });
        return copiedPipeMeta;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        super.serialize(stream);
        ReadWriteIOUtils.write((Boolean)this.isRollbackFromOperateOnDataNodesSuccessful, (OutputStream)stream);
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        super.deserialize(byteBuffer);
        this.isRollbackFromOperateOnDataNodesSuccessful = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
    }
}

