/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.extractor;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.james.mailbox.extractor.ParsedContent;
import org.apache.james.mailbox.extractor.TextExtractor;
import org.apache.james.mailbox.model.ContentType;

public class DefaultTextExtractor
implements TextExtractor {
    public ParsedContent extractContent(InputStream inputStream, ContentType contentType) throws Exception {
        if (contentType != null && contentType.asString().startsWith("text/")) {
            Charset charset = contentType.charset().orElse(StandardCharsets.UTF_8);
            return new ParsedContent(Optional.ofNullable(IOUtils.toString((InputStream)inputStream, (Charset)charset)), new HashMap());
        }
        return new ParsedContent(Optional.empty(), new HashMap());
    }
}

