/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public enum TransactionSettingsBackendLockBehavior {
    DO_NOT_ACQUIRE(0),
    ACQUIRE_AFTER_RETRIES(1),
    ACQUIRE_BEFORE_RETRIES(2),
    ACQUIRE_BEFORE_INITIAL_ATTEMPT(3);

    private final int intValue;

    private TransactionSettingsBackendLockBehavior(int intValue) {
        this.intValue = intValue;
    }

    public int intValue() {
        return this.intValue;
    }

    @Nullable
    public static TransactionSettingsBackendLockBehavior valueOf(int intValue) {
        for (TransactionSettingsBackendLockBehavior v : TransactionSettingsBackendLockBehavior.values()) {
            if (v.intValue != intValue) continue;
            return v;
        }
        return null;
    }

    @Nullable
    public static TransactionSettingsBackendLockBehavior forName(@NotNull String name) {
        switch (StaticUtils.toLowerCase(name)) {
            case "donotacquire": 
            case "do-not-acquire": 
            case "do_not_acquire": {
                return DO_NOT_ACQUIRE;
            }
            case "acquireafterretries": 
            case "acquire-after-retries": 
            case "acquire_after_retries": {
                return ACQUIRE_AFTER_RETRIES;
            }
            case "acquirebeforeretries": 
            case "acquire-before-retries": 
            case "acquire_before_retries": {
                return ACQUIRE_BEFORE_RETRIES;
            }
            case "acquirebeforeinitialattempt": 
            case "acquire-before-initial-attempt": 
            case "acquire_before_initial_attempt": {
                return ACQUIRE_BEFORE_INITIAL_ATTEMPT;
            }
        }
        return null;
    }
}

