/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail.utils;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.apache.james.mailbox.model.ComposedMessageId;
import org.apache.james.mailbox.model.UpdatedFlags;

public class FlagsUpdateStageResult {
    private final ImmutableList<ComposedMessageId> failed;
    private final ImmutableList<UpdatedFlags> succeeded;

    public static FlagsUpdateStageResult success(UpdatedFlags updatedFlags) {
        return new FlagsUpdateStageResult((ImmutableList<ComposedMessageId>)ImmutableList.of(), (ImmutableList<UpdatedFlags>)ImmutableList.of((Object)updatedFlags));
    }

    public static FlagsUpdateStageResult fail(ComposedMessageId ids) {
        return new FlagsUpdateStageResult((ImmutableList<ComposedMessageId>)ImmutableList.of((Object)ids), (ImmutableList<UpdatedFlags>)ImmutableList.of());
    }

    public static FlagsUpdateStageResult none() {
        return new FlagsUpdateStageResult((ImmutableList<ComposedMessageId>)ImmutableList.of(), (ImmutableList<UpdatedFlags>)ImmutableList.of());
    }

    @VisibleForTesting
    FlagsUpdateStageResult(ImmutableList<ComposedMessageId> failed, ImmutableList<UpdatedFlags> succeeded) {
        this.failed = failed;
        this.succeeded = succeeded;
    }

    public List<ComposedMessageId> getFailed() {
        return this.failed;
    }

    public List<UpdatedFlags> getSucceeded() {
        return this.succeeded;
    }

    public FlagsUpdateStageResult merge(FlagsUpdateStageResult other) {
        return new FlagsUpdateStageResult((ImmutableList<ComposedMessageId>)ImmutableList.builder().addAll(this.failed).addAll(other.failed).build(), (ImmutableList<UpdatedFlags>)ImmutableList.builder().addAll(this.succeeded).addAll(other.succeeded).build());
    }

    public boolean containsFailedResults() {
        return !this.failed.isEmpty();
    }

    public FlagsUpdateStageResult keepSucceded() {
        return new FlagsUpdateStageResult((ImmutableList<ComposedMessageId>)ImmutableList.of(), this.succeeded);
    }

    public final boolean equals(Object o) {
        if (o instanceof FlagsUpdateStageResult) {
            FlagsUpdateStageResult that = (FlagsUpdateStageResult)o;
            return Objects.equals(this.succeeded, that.succeeded) && Objects.equals(this.failed, that.failed);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.failed, this.succeeded);
    }
}

