/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.backup.zip;

import com.github.fge.lambdas.Throwing;
import com.google.common.base.Charsets;
import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.compress.archivers.zip.ExtraFieldUtils;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipExtraField;
import org.apache.commons.io.IOUtils;
import org.apache.james.mailbox.backup.ArchiveService;
import org.apache.james.mailbox.backup.Directory;
import org.apache.james.mailbox.backup.MailboxWithAnnotations;
import org.apache.james.mailbox.backup.zip.EntryTypeExtraField;
import org.apache.james.mailbox.backup.zip.FlagsExtraField;
import org.apache.james.mailbox.backup.zip.InternalDateExtraField;
import org.apache.james.mailbox.backup.zip.MailboxIdExtraField;
import org.apache.james.mailbox.backup.zip.MessageIdExtraField;
import org.apache.james.mailbox.backup.zip.SizeExtraField;
import org.apache.james.mailbox.backup.zip.UidExtraField;
import org.apache.james.mailbox.backup.zip.UidValidityExtraField;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.Content;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxAnnotation;
import org.apache.james.mailbox.model.MessageResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Zipper
implements ArchiveService {
    public static final String ANNOTATION_DIRECTORY = "annotations";
    private static final boolean AUTO_FLUSH = true;
    private static final Logger LOGGER = LoggerFactory.getLogger(Zipper.class);

    @Inject
    public Zipper() {
        ExtraFieldUtils.register(SizeExtraField.class);
        ExtraFieldUtils.register(UidExtraField.class);
        ExtraFieldUtils.register(MessageIdExtraField.class);
        ExtraFieldUtils.register(MailboxIdExtraField.class);
        ExtraFieldUtils.register(InternalDateExtraField.class);
        ExtraFieldUtils.register(UidValidityExtraField.class);
        ExtraFieldUtils.register(FlagsExtraField.class);
        ExtraFieldUtils.register(EntryTypeExtraField.class);
    }

    @Override
    public void archive(List<MailboxWithAnnotations> mailboxes, Stream<MessageResult> messages, OutputStream destination) throws IOException {
        try (ZipArchiveOutputStream archiveOutputStream = new ZipArchiveOutputStream(destination);){
            this.storeMailboxes(mailboxes, archiveOutputStream);
            this.storeMessages(messages, archiveOutputStream);
            archiveOutputStream.finish();
        }
    }

    private void storeMailboxes(List<MailboxWithAnnotations> mailboxes, ZipArchiveOutputStream archiveOutputStream) throws IOException {
        mailboxes.forEach(Throwing.consumer(mailbox -> this.storeInArchive((MailboxWithAnnotations)mailbox, archiveOutputStream)).sneakyThrow());
    }

    private void storeMessages(Stream<MessageResult> messages, ZipArchiveOutputStream archiveOutputStream) throws IOException {
        messages.forEach(Throwing.consumer(message -> this.storeInArchive((MessageResult)message, archiveOutputStream)).sneakyThrow());
    }

    private void storeInArchive(MailboxWithAnnotations mailboxWithAnnotations, ZipArchiveOutputStream archiveOutputStream) throws IOException {
        Mailbox mailbox = mailboxWithAnnotations.mailbox;
        List<MailboxAnnotation> annotations = mailboxWithAnnotations.annotations;
        String name = mailbox.getName();
        ZipArchiveEntry archiveEntry = archiveOutputStream.createArchiveEntry((File)new Directory(name), name);
        archiveEntry.addExtraField((ZipExtraField)EntryTypeExtraField.TYPE_MAILBOX);
        archiveEntry.addExtraField((ZipExtraField)new MailboxIdExtraField(mailbox.getMailboxId().serialize()));
        archiveEntry.addExtraField((ZipExtraField)new UidValidityExtraField(mailbox.getUidValidity().asLong()));
        archiveOutputStream.putArchiveEntry(archiveEntry);
        archiveOutputStream.closeArchiveEntry();
        this.storeAllAnnotationsInArchive(archiveOutputStream, annotations, name);
    }

    private void storeAllAnnotationsInArchive(ZipArchiveOutputStream archiveOutputStream, List<MailboxAnnotation> annotations, String name) throws IOException {
        if (!annotations.isEmpty()) {
            String annotationsDirectoryPath = name + "/annotations";
            ZipArchiveEntry annotationDirectory = archiveOutputStream.createArchiveEntry((File)new Directory(annotationsDirectoryPath), annotationsDirectoryPath);
            annotationDirectory.addExtraField((ZipExtraField)EntryTypeExtraField.TYPE_MAILBOX_ANNOTATION_DIR);
            archiveOutputStream.putArchiveEntry(annotationDirectory);
            archiveOutputStream.closeArchiveEntry();
            annotations.forEach(Throwing.consumer(annotation -> this.storeInArchive((MailboxAnnotation)annotation, annotationsDirectoryPath, archiveOutputStream)));
        }
    }

    private void storeInArchive(MailboxAnnotation annotation, String directory, ZipArchiveOutputStream archiveOutputStream) throws IOException {
        String entryId = directory + "/" + annotation.getKey().asString();
        ZipArchiveEntry archiveEntry = archiveOutputStream.createArchiveEntry(new File(entryId), entryId);
        archiveEntry.addExtraField((ZipExtraField)EntryTypeExtraField.TYPE_MAILBOX_ANNOTATION);
        archiveOutputStream.putArchiveEntry(archiveEntry);
        annotation.getValue().ifPresent(value -> {
            try (PrintWriter printWriter = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)archiveOutputStream, Charsets.UTF_8), true);){
                printWriter.print((String)value);
            }
        });
        archiveOutputStream.closeArchiveEntry();
    }

    private void storeInArchive(MessageResult message, ZipArchiveOutputStream archiveOutputStream) throws IOException {
        String entryId = message.getMessageId().serialize();
        ZipArchiveEntry archiveEntry = this.createMessageZipArchiveEntry(message, archiveOutputStream, entryId);
        archiveOutputStream.putArchiveEntry(archiveEntry);
        try {
            Content content = message.getFullContent();
            try (InputStream stream = content.getInputStream();){
                IOUtils.copy((InputStream)stream, (OutputStream)archiveOutputStream);
            }
        }
        catch (MailboxException e) {
            LOGGER.error("Error while storing message in archive", (Throwable)e);
        }
        archiveOutputStream.closeArchiveEntry();
    }

    private ZipArchiveEntry createMessageZipArchiveEntry(MessageResult message, ZipArchiveOutputStream archiveOutputStream, String entryId) throws IOException {
        ZipArchiveEntry archiveEntry = archiveOutputStream.createArchiveEntry(new File(entryId), entryId);
        archiveEntry.addExtraField((ZipExtraField)EntryTypeExtraField.TYPE_MESSAGE);
        archiveEntry.addExtraField((ZipExtraField)new SizeExtraField(message.getSize()));
        archiveEntry.addExtraField((ZipExtraField)new UidExtraField(message.getUid().asLong()));
        archiveEntry.addExtraField((ZipExtraField)new MessageIdExtraField(message.getMessageId().serialize()));
        archiveEntry.addExtraField((ZipExtraField)new MailboxIdExtraField(message.getMailboxId().serialize()));
        archiveEntry.addExtraField((ZipExtraField)new InternalDateExtraField(message.getInternalDate()));
        archiveEntry.addExtraField((ZipExtraField)new FlagsExtraField(message.getFlags()));
        return archiveEntry;
    }
}

