/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.server.blob.deduplication;

import java.time.Clock;
import java.time.Instant;
import java.util.Optional;
import java.util.Set;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BlobReferenceSource;
import org.apache.james.blob.api.BlobStoreDAO;
import org.apache.james.blob.api.BucketName;
import org.apache.james.server.blob.deduplication.BlobReferenceAggregate;
import org.apache.james.server.blob.deduplication.BloomFilterGCAlgorithm;
import org.apache.james.server.blob.deduplication.GenerationAwareBlobId;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskType;

public class BlobGCTask
implements Task {
    public static final TaskType TASK_TYPE = TaskType.of((String)"BlobGCTask");
    private final BlobStoreDAO blobStoreDAO;
    private final BlobId.Factory generationAwareBlobIdFactory;
    private final GenerationAwareBlobId.Configuration generationAwareBlobIdConfiguration;
    private final Set<BlobReferenceSource> blobReferenceSources;
    private final Clock clock;
    private final BucketName bucketName;
    private final int expectedBlobCount;
    private final int deletionWindowSize;
    private final double associatedProbability;
    private final BloomFilterGCAlgorithm.Context context;

    public static Builder.RequireBlobStoreDAO builder() {
        return blobStoreDao -> generationAwareBlobIdFactory -> generationAwareBlobIdConfiguration -> blobReferenceSources -> bucketName -> clock -> expectedBlobCount -> associatedProbability -> new Builder(blobStoreDao, generationAwareBlobIdFactory, generationAwareBlobIdConfiguration, blobReferenceSources, clock, bucketName, expectedBlobCount, associatedProbability);
    }

    public BlobGCTask(BlobStoreDAO blobStoreDAO, BlobId.Factory generationAwareBlobIdFactory, GenerationAwareBlobId.Configuration generationAwareBlobIdConfiguration, Set<BlobReferenceSource> blobReferenceSources, BucketName bucketName, Clock clock, int expectedBlobCount, int deletionWindowSize, double associatedProbability) {
        this.blobStoreDAO = blobStoreDAO;
        this.generationAwareBlobIdFactory = generationAwareBlobIdFactory;
        this.generationAwareBlobIdConfiguration = generationAwareBlobIdConfiguration;
        this.blobReferenceSources = blobReferenceSources;
        this.clock = clock;
        this.bucketName = bucketName;
        this.expectedBlobCount = expectedBlobCount;
        this.deletionWindowSize = deletionWindowSize;
        this.associatedProbability = associatedProbability;
        this.context = new BloomFilterGCAlgorithm.Context(expectedBlobCount, associatedProbability);
    }

    public Task.Result run() {
        BloomFilterGCAlgorithm gcAlgorithm = new BloomFilterGCAlgorithm(BlobReferenceAggregate.aggregate(this.blobReferenceSources), this.blobStoreDAO, this.generationAwareBlobIdFactory, this.generationAwareBlobIdConfiguration, this.clock);
        return (Task.Result)gcAlgorithm.gc(this.expectedBlobCount, this.deletionWindowSize, this.associatedProbability, this.bucketName, this.context).block();
    }

    public TaskType type() {
        return TASK_TYPE;
    }

    public Optional<TaskExecutionDetails.AdditionalInformation> details() {
        return Optional.of(AdditionalInformation.from(this.context, this.deletionWindowSize));
    }

    public Clock getClock() {
        return this.clock;
    }

    public BucketName getBucketName() {
        return this.bucketName;
    }

    public int getExpectedBlobCount() {
        return this.expectedBlobCount;
    }

    public double getAssociatedProbability() {
        return this.associatedProbability;
    }

    public int getDeletionWindowSize() {
        return this.deletionWindowSize;
    }

    public static class Builder {
        public static final int DEFAULT_DELETION_WINDOW_SIZE = 1000;
        private final BlobStoreDAO blobStoreDAO;
        private final BlobId.Factory generationAwareBlobIdFactory;
        private final GenerationAwareBlobId.Configuration generationAwareBlobIdConfiguration;
        private final Set<BlobReferenceSource> blobReferenceSources;
        private final Clock clock;
        private final BucketName bucketName;
        private final int expectedBlobCount;
        private final double associatedProbability;
        private Optional<Integer> deletionWindowSize;

        public Builder(BlobStoreDAO blobStoreDAO, BlobId.Factory generationAwareBlobIdFactory, GenerationAwareBlobId.Configuration generationAwareBlobIdConfiguration, Set<BlobReferenceSource> blobReferenceSources, Clock clock, BucketName bucketName, int expectedBlobCount, double associatedProbability) {
            this.blobStoreDAO = blobStoreDAO;
            this.generationAwareBlobIdFactory = generationAwareBlobIdFactory;
            this.generationAwareBlobIdConfiguration = generationAwareBlobIdConfiguration;
            this.blobReferenceSources = blobReferenceSources;
            this.clock = clock;
            this.bucketName = bucketName;
            this.expectedBlobCount = expectedBlobCount;
            this.deletionWindowSize = Optional.empty();
            this.associatedProbability = associatedProbability;
        }

        public Builder deletionWindowSize(int deletionWindowSize) {
            this.deletionWindowSize = Optional.of(deletionWindowSize);
            return this;
        }

        public Builder deletionWindowSize(Optional<Integer> deletionWindowSize) {
            this.deletionWindowSize = deletionWindowSize;
            return this;
        }

        public BlobGCTask build() {
            return new BlobGCTask(this.blobStoreDAO, this.generationAwareBlobIdFactory, this.generationAwareBlobIdConfiguration, this.blobReferenceSources, this.bucketName, this.clock, this.expectedBlobCount, this.deletionWindowSize.orElse(1000), this.associatedProbability);
        }

        @FunctionalInterface
        public static interface RequireBlobStoreDAO {
            public RequireGenerationAwareBlobIdFactory blobStoreDAO(BlobStoreDAO var1);
        }

        @FunctionalInterface
        public static interface RequireGenerationAwareBlobIdFactory {
            public RequireGenerationAwareBlobIdConfiguration generationAwareBlobIdFactory(BlobId.Factory var1);
        }

        @FunctionalInterface
        public static interface RequireGenerationAwareBlobIdConfiguration {
            public RequireBlobReferenceSources generationAwareBlobIdConfiguration(GenerationAwareBlobId.Configuration var1);
        }

        @FunctionalInterface
        public static interface RequireBlobReferenceSources {
            public RequireBucketName blobReferenceSource(Set<BlobReferenceSource> var1);
        }

        @FunctionalInterface
        public static interface RequireBucketName {
            public RequireClock bucketName(BucketName var1);
        }

        @FunctionalInterface
        public static interface RequireClock {
            public RequireExpectedBlobCount clock(Clock var1);
        }

        @FunctionalInterface
        public static interface RequireExpectedBlobCount {
            public RequireAssociatedProbability expectedBlobCount(int var1);
        }

        @FunctionalInterface
        public static interface RequireAssociatedProbability {
            public Builder associatedProbability(double var1);
        }
    }

    public static class AdditionalInformation
    implements TaskExecutionDetails.AdditionalInformation {
        private final Instant timestamp;
        private final long referenceSourceCount;
        private final long blobCount;
        private final long gcedBlobCount;
        private final long errorCount;
        private final long bloomFilterExpectedBlobCount;
        private final double bloomFilterAssociatedProbability;
        private final int deletionWindowSize;

        private static AdditionalInformation from(BloomFilterGCAlgorithm.Context context, int deletionWindowSize) {
            BloomFilterGCAlgorithm.Context.Snapshot snapshot = context.snapshot();
            return new AdditionalInformation(snapshot.getReferenceSourceCount(), snapshot.getBlobCount(), snapshot.getGcedBlobCount(), snapshot.getErrorCount(), snapshot.getBloomFilterExpectedBlobCount(), snapshot.getBloomFilterAssociatedProbability(), Clock.systemUTC().instant(), deletionWindowSize);
        }

        AdditionalInformation(long referenceSourceCount, long blobCount, long gcedBlobCount, long errorCount, long bloomFilterExpectedBlobCount, double bloomFilterAssociatedProbability, Instant timestamp, int deletionWindowSize) {
            this.referenceSourceCount = referenceSourceCount;
            this.blobCount = blobCount;
            this.gcedBlobCount = gcedBlobCount;
            this.errorCount = errorCount;
            this.bloomFilterExpectedBlobCount = bloomFilterExpectedBlobCount;
            this.bloomFilterAssociatedProbability = bloomFilterAssociatedProbability;
            this.timestamp = timestamp;
            this.deletionWindowSize = deletionWindowSize;
        }

        public Instant timestamp() {
            return this.timestamp;
        }

        public Instant getTimestamp() {
            return this.timestamp;
        }

        public long getReferenceSourceCount() {
            return this.referenceSourceCount;
        }

        public long getBlobCount() {
            return this.blobCount;
        }

        public long getGcedBlobCount() {
            return this.gcedBlobCount;
        }

        public long getErrorCount() {
            return this.errorCount;
        }

        public long getBloomFilterExpectedBlobCount() {
            return this.bloomFilterExpectedBlobCount;
        }

        public double getBloomFilterAssociatedProbability() {
            return this.bloomFilterAssociatedProbability;
        }

        public int getDeletionWindowSize() {
            return this.deletionWindowSize;
        }
    }
}

