/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailrepository.postgres;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.lambdas.Throwing;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import jakarta.inject.Inject;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.backends.postgres.PostgresCommons;
import org.apache.james.backends.postgres.utils.PostgresExecutor;
import org.apache.james.backends.postgres.utils.PostgresUtils;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.Store;
import org.apache.james.blob.mail.MimeMessagePartsId;
import org.apache.james.blob.mail.MimeMessageStore;
import org.apache.james.core.MailAddress;
import org.apache.james.core.MaybeSender;
import org.apache.james.mailrepository.api.MailKey;
import org.apache.james.mailrepository.api.MailRepositoryUrl;
import org.apache.james.mailrepository.postgres.PostgresMailRepositoryDataDefinition;
import org.apache.james.server.core.MailImpl;
import org.apache.james.server.core.MimeMessageWrapper;
import org.apache.james.util.AuditTrail;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeName;
import org.apache.mailet.AttributeValue;
import org.apache.mailet.Mail;
import org.apache.mailet.PerRecipientHeaders;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.postgres.extensions.types.Hstore;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class PostgresMailRepositoryContentDAO {
    private static final String HEADERS_SEPARATOR = ";  ";
    private final PostgresExecutor postgresExecutor;
    private final Store<MimeMessage, MimeMessagePartsId> mimeMessageStore;
    private final BlobId.Factory blobIdFactory;

    @Inject
    public PostgresMailRepositoryContentDAO(PostgresExecutor postgresExecutor, MimeMessageStore.Factory mimeMessageStoreFactory, BlobId.Factory blobIdFactory) {
        this.postgresExecutor = postgresExecutor;
        this.mimeMessageStore = mimeMessageStoreFactory.mimeMessageStore();
        this.blobIdFactory = blobIdFactory;
    }

    public long size(MailRepositoryUrl url) throws MessagingException {
        return (Long)this.sizeReactive(url).block();
    }

    public Mono<Long> sizeReactive(MailRepositoryUrl url) {
        return this.postgresExecutor.executeCount(context -> Mono.from((Publisher)context.selectCount().from(PostgresMailRepositoryDataDefinition.PostgresMailRepositoryContentTable.TABLE_NAME).where(PostgresMailRepositoryDataDefinition.PostgresMailRepositoryContentTable.URL.eq((Object)url.asString())))).map(Integer::longValue);
    }

    public MailKey store(Mail mail, MailRepositoryUrl url) throws MessagingException {
        MailKey mailKey = MailKey.forMail((Mail)mail);
        return (MailKey)this.storeMailBlob(mail).flatMap(mimeMessagePartsId -> this.storeMailMetadata(mail, mailKey, (MimeMessagePartsId)mimeMessagePartsId, url).doOnSuccess(this.auditTrailStoredMail(mail)).onErrorResume(PostgresUtils.UNIQUE_CONSTRAINT_VIOLATION_PREDICATE, e -> Mono.from((Publisher)this.mimeMessageStore.delete(mimeMessagePartsId)).thenReturn((Object)mailKey))).block();
    }

    private Mono<MimeMessagePartsId> storeMailBlob(Mail mail) throws MessagingException {
        return this.mimeMessageStore.save((Object)mail.getMessage());
    }

    private Mono<MailKey> storeMailMetadata(Mail mail, MailKey mailKey, MimeMessagePartsId mimeMessagePartsId, MailRepositoryUrl url) {
        return this.postgresExecutor.executeVoid(context -> Mono.from((Publisher)context.insertInto(PostgresMailRepositoryDataDefinition.PostgresMailRepositoryContentTable.TABLE_NAME).set(PostgresMailRepositoryDataDefinition.PostgresMailRepositoryContentTable.URL, (Object)url.asString()).set(PostgresMailRepositoryDataDefinition.PostgresMailRepositoryContentTable.KEY, (Object)mailKey.asString()).set(PostgresMailRepositoryDataDefinition.PostgresMailRepositoryContentTable.HEADER_BLOB_ID, (Object)mimeMessagePartsId.getHeaderBlobId().asString()).set(PostgresMailRepositoryDataDefinition.PostgresMailRepositoryContentTable.BODY_BLOB_ID, (Object)mimeMessagePartsId.getBodyBlobId().asString()).set(PostgresMailRepositoryDataDefinition.PostgresMailRepositoryContentTable.STATE, (Object)mail.getState()).set(PostgresMailRepositoryDataDefinition.PostgresMailRepositoryContentTable.ERROR, (Object)mail.getErrorMessage()).set(PostgresMailRepositoryDataDefinition.PostgresMailRepositoryContentTable.SENDER, (Object)mail.getMaybeSender().asString()).set(PostgresMailRepositoryDataDefinition.PostgresMailRepositoryContentTable.RECIPIENTS, (Object)this.asStringArray(mail.getRecipients())).set(PostgresMailRepositoryDataDefinition.PostgresMailRepositoryContentTable.REMOTE_ADDRESS, (Object)mail.getRemoteAddr()).set(PostgresMailRepositoryDataDefinition.PostgresMailRepositoryContentTable.REMOTE_HOST, (Object)mail.getRemoteHost()).set(PostgresMailRepositoryDataDefinition.PostgresMailRepositoryContentTable.LAST_UPDATED, (Object)((LocalDateTime)PostgresCommons.DATE_TO_LOCAL_DATE_TIME.apply(mail.getLastUpdated()))).set(PostgresMailRepositoryDataDefinition.PostgresMailRepositoryContentTable.ATTRIBUTES, (Object)this.asHstore(mail.attributes())).set(PostgresMailRepositoryDataDefinition.PostgresMailRepositoryContentTable.PER_RECIPIENT_SPECIFIC_HEADERS, (Object)this.asHstore((Multimap<MailAddress, PerRecipientHeaders.Header>)mail.getPerRecipientSpecificHeaders().getHeadersByRecipient())).onConflict(new Field[]{PostgresMailRepositoryDataDefinition.PostgresMailRepositoryContentTable.URL, PostgresMailRepositoryDataDefinition.PostgresMailRepositoryContentTable.KEY}).doUpdate().set(PostgresMailRepositoryDataDefinition.PostgresMailRepositoryContentTable.HEADER_BLOB_ID, (Object)mimeMessagePartsId.getHeaderBlobId().asString()).set(PostgresMailRepositoryDataDefinition.PostgresMailRepositoryContentTable.BODY_BLOB_ID, (Object)mimeMessagePartsId.getBodyBlobId().asString()).set(PostgresMailRepositoryDataDefinition.PostgresMailRepositoryContentTable.STATE, (Object)mail.getState()).set(PostgresMailRepositoryDataDefinition.PostgresMailRepositoryContentTable.ERROR, (Object)mail.getErrorMessage()).set(PostgresMailRepositoryDataDefinition.PostgresMailRepositoryContentTable.SENDER, (Object)mail.getMaybeSender().asString()).set(PostgresMailRepositoryDataDefinition.PostgresMailRepositoryContentTable.RECIPIENTS, (Object)this.asStringArray(mail.getRecipients())).set(PostgresMailRepositoryDataDefinition.PostgresMailRepositoryContentTable.REMOTE_ADDRESS, (Object)mail.getRemoteAddr()).set(PostgresMailRepositoryDataDefinition.PostgresMailRepositoryContentTable.REMOTE_HOST, (Object)mail.getRemoteHost()).set(PostgresMailRepositoryDataDefinition.PostgresMailRepositoryContentTable.LAST_UPDATED, (Object)((LocalDateTime)PostgresCommons.DATE_TO_LOCAL_DATE_TIME.apply(mail.getLastUpdated()))).set(PostgresMailRepositoryDataDefinition.PostgresMailRepositoryContentTable.ATTRIBUTES, (Object)this.asHstore(mail.attributes())).set(PostgresMailRepositoryDataDefinition.PostgresMailRepositoryContentTable.PER_RECIPIENT_SPECIFIC_HEADERS, (Object)this.asHstore((Multimap<MailAddress, PerRecipientHeaders.Header>)mail.getPerRecipientSpecificHeaders().getHeadersByRecipient())))).thenReturn((Object)mailKey);
    }

    private Consumer<MailKey> auditTrailStoredMail(Mail mail) {
        return Throwing.consumer(any -> AuditTrail.entry().protocol("mailrepository").action("store").parameters((Supplier)Throwing.supplier(() -> ImmutableMap.of((Object)"mailId", (Object)mail.getName(), (Object)"mimeMessageId", (Object)Optional.ofNullable(mail.getMessage()).map(Throwing.function(MimeMessage::getMessageID)).orElse(""), (Object)"sender", (Object)mail.getMaybeSender().asString(), (Object)"recipients", (Object)StringUtils.join((Object[])new Collection[]{mail.getRecipients()})))).log("PostgresMailRepository stored mail."));
    }

    private String[] asStringArray(Collection<MailAddress> mailAddresses) {
        return (String[])mailAddresses.stream().map(MailAddress::asString).toArray(String[]::new);
    }

    private Hstore asHstore(Multimap<MailAddress, PerRecipientHeaders.Header> multimap) {
        return Hstore.hstore((Map)((Map)multimap.asMap().entrySet().stream().map(recipientToHeaders -> Pair.of((Object)((MailAddress)recipientToHeaders.getKey()).asString(), (Object)this.asString((Collection)recipientToHeaders.getValue()))).collect(ImmutableMap.toImmutableMap(Pair::getLeft, Pair::getRight))));
    }

    private String asString(Collection<PerRecipientHeaders.Header> headers) {
        return StringUtils.join((Iterable)((Iterable)headers.stream().map(PerRecipientHeaders.Header::asString).collect(ImmutableList.toImmutableList())), (String)HEADERS_SEPARATOR);
    }

    private Hstore asHstore(Stream<Attribute> attributes) {
        return Hstore.hstore((Map)((Map)attributes.flatMap(attribute -> attribute.getValue().toJson().map(JsonNode::toString).map(value -> Pair.of((Object)attribute.getName().asString(), (Object)value)).stream()).collect(ImmutableMap.toImmutableMap(Pair::getLeft, Pair::getRight))));
    }

    public Iterator<MailKey> list(MailRepositoryUrl url) throws MessagingException {
        return this.listMailKeys(url).toStream().iterator();
    }

    private Flux<MailKey> listMailKeys(MailRepositoryUrl url) {
        return this.postgresExecutor.executeRows(context -> Flux.from((Publisher)context.select(PostgresMailRepositoryDataDefinition.PostgresMailRepositoryContentTable.KEY).from(PostgresMailRepositoryDataDefinition.PostgresMailRepositoryContentTable.TABLE_NAME).where(PostgresMailRepositoryDataDefinition.PostgresMailRepositoryContentTable.URL.eq((Object)url.asString())))).map(record -> new MailKey((String)record.get(PostgresMailRepositoryDataDefinition.PostgresMailRepositoryContentTable.KEY)));
    }

    public Mail retrieve(MailKey key, MailRepositoryUrl url) {
        return this.postgresExecutor.executeRow(context -> Mono.from((Publisher)context.select(new SelectFieldOrAsterisk[0]).from(PostgresMailRepositoryDataDefinition.PostgresMailRepositoryContentTable.TABLE_NAME).where(PostgresMailRepositoryDataDefinition.PostgresMailRepositoryContentTable.URL.eq((Object)url.asString())).and(PostgresMailRepositoryDataDefinition.PostgresMailRepositoryContentTable.KEY.eq((Object)key.asString())))).flatMap(this::toMail).blockOptional().orElse(null);
    }

    private Mono<Mail> toMail(Record record) {
        return this.mimeMessageStore.read((Object)this.toMimeMessagePartsId(record)).map((Function)Throwing.function(mimeMessage -> this.toMail(record, (MimeMessage)mimeMessage)));
    }

    private Mail toMail(Record record, MimeMessage mimeMessage) throws MessagingException {
        List recipients = (List)Arrays.stream((String[])record.get(PostgresMailRepositoryDataDefinition.PostgresMailRepositoryContentTable.RECIPIENTS)).map(Throwing.function(MailAddress::new)).collect(ImmutableList.toImmutableList());
        PerRecipientHeaders perRecipientHeaders = this.getPerRecipientHeaders(record);
        List attributes = (List)((LinkedHashMap)record.get(PostgresMailRepositoryDataDefinition.PostgresMailRepositoryContentTable.ATTRIBUTES, LinkedHashMap.class)).entrySet().stream().map(Throwing.function(entry -> new Attribute(AttributeName.of((String)((String)entry.getKey())), AttributeValue.fromJsonString((String)((String)entry.getValue()))))).collect(ImmutableList.toImmutableList());
        MailImpl mail = MailImpl.builder().name((String)record.get(PostgresMailRepositoryDataDefinition.PostgresMailRepositoryContentTable.KEY)).sender(MaybeSender.getMailSender((String)((String)record.get(PostgresMailRepositoryDataDefinition.PostgresMailRepositoryContentTable.SENDER)))).addRecipients((Collection)recipients).lastUpdated((Date)PostgresCommons.LOCAL_DATE_TIME_DATE_FUNCTION.apply((LocalDateTime)record.get(PostgresMailRepositoryDataDefinition.PostgresMailRepositoryContentTable.LAST_UPDATED, LocalDateTime.class))).errorMessage((String)record.get(PostgresMailRepositoryDataDefinition.PostgresMailRepositoryContentTable.ERROR)).remoteHost((String)record.get(PostgresMailRepositoryDataDefinition.PostgresMailRepositoryContentTable.REMOTE_HOST)).remoteAddr((String)record.get(PostgresMailRepositoryDataDefinition.PostgresMailRepositoryContentTable.REMOTE_ADDRESS)).state((String)record.get(PostgresMailRepositoryDataDefinition.PostgresMailRepositoryContentTable.STATE)).addAllHeadersForRecipients(perRecipientHeaders).addAttributes((Collection)attributes).build();
        if (mimeMessage instanceof MimeMessageWrapper) {
            mail.setMessageNoCopy((MimeMessageWrapper)mimeMessage);
        } else {
            mail.setMessage(mimeMessage);
        }
        return mail;
    }

    private PerRecipientHeaders getPerRecipientHeaders(Record record) {
        PerRecipientHeaders perRecipientHeaders = new PerRecipientHeaders();
        ((LinkedHashMap)record.get(PostgresMailRepositoryDataDefinition.PostgresMailRepositoryContentTable.PER_RECIPIENT_SPECIFIC_HEADERS, LinkedHashMap.class)).entrySet().stream().flatMap(this::recipientToHeaderStream).forEach(recipientToHeaderPair -> perRecipientHeaders.addHeaderForRecipient((PerRecipientHeaders.Header)recipientToHeaderPair.getRight(), (MailAddress)recipientToHeaderPair.getLeft()));
        return perRecipientHeaders;
    }

    private Stream<Pair<MailAddress, PerRecipientHeaders.Header>> recipientToHeaderStream(Map.Entry<String, String> recipientToHeadersString) {
        List headers = Splitter.on((String)HEADERS_SEPARATOR).splitToList((CharSequence)recipientToHeadersString.getValue());
        return headers.stream().map(headerAsString -> Pair.of((Object)this.asMailAddress((String)recipientToHeadersString.getKey()), (Object)PerRecipientHeaders.Header.fromString((String)headerAsString)));
    }

    private MailAddress asMailAddress(String mailAddress) {
        return (MailAddress)Throwing.supplier(() -> new MailAddress(mailAddress)).get();
    }

    private MimeMessagePartsId toMimeMessagePartsId(Record record) {
        return MimeMessagePartsId.builder().headerBlobId(this.blobIdFactory.parse((String)record.get(PostgresMailRepositoryDataDefinition.PostgresMailRepositoryContentTable.HEADER_BLOB_ID))).bodyBlobId(this.blobIdFactory.parse((String)record.get(PostgresMailRepositoryDataDefinition.PostgresMailRepositoryContentTable.BODY_BLOB_ID))).build();
    }

    public void remove(MailKey key, MailRepositoryUrl url) {
        this.removeReactive(key, url).block();
    }

    private Mono<Void> removeReactive(MailKey key, MailRepositoryUrl url) {
        return this.getMimeMessagePartsId(key, url).flatMap(mimeMessagePartsId -> this.deleteMailMetadata(key, url).then(this.deleteMailBlob((MimeMessagePartsId)mimeMessagePartsId)));
    }

    private Mono<MimeMessagePartsId> getMimeMessagePartsId(MailKey key, MailRepositoryUrl url) {
        return this.postgresExecutor.executeRow(context -> Mono.from((Publisher)context.select(PostgresMailRepositoryDataDefinition.PostgresMailRepositoryContentTable.HEADER_BLOB_ID, PostgresMailRepositoryDataDefinition.PostgresMailRepositoryContentTable.BODY_BLOB_ID).from(PostgresMailRepositoryDataDefinition.PostgresMailRepositoryContentTable.TABLE_NAME).where(PostgresMailRepositoryDataDefinition.PostgresMailRepositoryContentTable.URL.eq((Object)url.asString())).and(PostgresMailRepositoryDataDefinition.PostgresMailRepositoryContentTable.KEY.eq((Object)key.asString())))).map(this::toMimeMessagePartsId);
    }

    private Mono<Void> deleteMailMetadata(MailKey key, MailRepositoryUrl url) {
        return this.postgresExecutor.executeVoid(context -> Mono.from((Publisher)context.deleteFrom(PostgresMailRepositoryDataDefinition.PostgresMailRepositoryContentTable.TABLE_NAME).where(PostgresMailRepositoryDataDefinition.PostgresMailRepositoryContentTable.URL.eq((Object)url.asString())).and(PostgresMailRepositoryDataDefinition.PostgresMailRepositoryContentTable.KEY.eq((Object)key.asString()))));
    }

    private Mono<Void> deleteMailBlob(MimeMessagePartsId mimeMessagePartsId) {
        return Mono.from((Publisher)this.mimeMessageStore.delete((Object)mimeMessagePartsId));
    }

    public void remove(Collection<MailKey> keys, MailRepositoryUrl url) {
        Flux.fromIterable(keys).concatMap(mailKey -> this.removeReactive((MailKey)mailKey, url)).then().block();
    }

    public void removeAll(MailRepositoryUrl url) {
        this.listMailKeys(url).flatMap(mailKey -> this.removeReactive((MailKey)mailKey, url), 16).then().block();
    }

    public Flux<BlobId> listBlobs() {
        return this.postgresExecutor.executeRows(dslContext -> Flux.from((Publisher)dslContext.select(PostgresMailRepositoryDataDefinition.PostgresMailRepositoryContentTable.HEADER_BLOB_ID, PostgresMailRepositoryDataDefinition.PostgresMailRepositoryContentTable.BODY_BLOB_ID).from(PostgresMailRepositoryDataDefinition.PostgresMailRepositoryContentTable.TABLE_NAME))).flatMapIterable(record -> ImmutableList.of((Object)this.blobIdFactory.parse((String)record.get(PostgresMailRepositoryDataDefinition.PostgresMailRepositoryContentTable.HEADER_BLOB_ID)), (Object)this.blobIdFactory.parse((String)record.get(PostgresMailRepositoryDataDefinition.PostgresMailRepositoryContentTable.BODY_BLOB_ID))));
    }
}

