/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.webadmin;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Scopes;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import org.apache.james.backends.cassandra.migration.CassandraMigrationService;
import org.apache.james.backends.cassandra.migration.Migration;
import org.apache.james.backends.cassandra.migration.MigrationTask;
import org.apache.james.backends.cassandra.versions.CassandraSchemaVersionManager;
import org.apache.james.backends.cassandra.versions.SchemaTransition;
import org.apache.james.backends.cassandra.versions.SchemaVersion;
import org.apache.james.mailbox.cassandra.quota.migration.CassandraCurrentQuotaManagerMigration;
import org.apache.james.mailbox.cassandra.quota.migration.CassandraPerUserMaxQuotaManagerMigration;
import org.apache.james.sieve.cassandra.migration.SieveQuotaMigration;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.routes.CassandraMailboxMergingRoutes;
import org.apache.james.webadmin.routes.CassandraMigrationRoutes;

public class CassandraRoutesModule
extends AbstractModule {
    private static final SchemaTransition FROM_V12_TO_V13 = SchemaTransition.to((SchemaVersion)new SchemaVersion(13));
    private static final SchemaTransition FROM_V13_TO_V14 = SchemaTransition.to((SchemaVersion)new SchemaVersion(14));
    private static final SchemaTransition FROM_V14_TO_V15 = SchemaTransition.to((SchemaVersion)new SchemaVersion(15));

    protected void configure() {
        this.bind(MigrationTask.Impl.class).in(Scopes.SINGLETON);
        this.bind(CassandraRoutesModule.class).in(Scopes.SINGLETON);
        this.bind(CassandraMailboxMergingRoutes.class).in(Scopes.SINGLETON);
        this.bind(CassandraMigrationService.class).in(Scopes.SINGLETON);
        this.bind(MigrationTask.Factory.class).to(MigrationTask.Impl.class);
        Multibinder routesMultibinder = Multibinder.newSetBinder((Binder)this.binder(), Routes.class);
        routesMultibinder.addBinding().to(CassandraMigrationRoutes.class);
        routesMultibinder.addBinding().to(CassandraMailboxMergingRoutes.class);
        MapBinder allMigrationClazzBinder = MapBinder.newMapBinder((Binder)this.binder(), SchemaTransition.class, Migration.class);
        allMigrationClazzBinder.addBinding((Object)FROM_V12_TO_V13).to(CassandraCurrentQuotaManagerMigration.class);
        allMigrationClazzBinder.addBinding((Object)FROM_V13_TO_V14).to(CassandraPerUserMaxQuotaManagerMigration.class);
        allMigrationClazzBinder.addBinding((Object)FROM_V14_TO_V15).to(SieveQuotaMigration.class);
        this.bind(SchemaVersion.class).annotatedWith((Annotation)Names.named((String)"latestVersion")).toInstance((Object)CassandraSchemaVersionManager.MAX_VERSION);
    }
}

