/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.postgres.user;

import org.apache.james.backends.postgres.utils.PostgresExecutor;
import org.apache.james.mailbox.postgres.user.PostgresSubscriptionDataDefinition;
import org.jooq.Field;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class PostgresSubscriptionDAO {
    protected final PostgresExecutor executor;

    public PostgresSubscriptionDAO(PostgresExecutor executor) {
        this.executor = executor;
    }

    public Mono<Void> save(String username, String mailbox) {
        return this.executor.executeVoid(dsl -> Mono.from((Publisher)dsl.insertInto(PostgresSubscriptionDataDefinition.TABLE_NAME, PostgresSubscriptionDataDefinition.USER, PostgresSubscriptionDataDefinition.MAILBOX).values((Object)username, (Object)mailbox).onConflict(new Field[]{PostgresSubscriptionDataDefinition.USER, PostgresSubscriptionDataDefinition.MAILBOX}).doNothing().returningResult(PostgresSubscriptionDataDefinition.MAILBOX)));
    }

    public Mono<Void> delete(String username, String mailbox) {
        return this.executor.executeVoid(dsl -> Mono.from((Publisher)dsl.deleteFrom(PostgresSubscriptionDataDefinition.TABLE_NAME).where(PostgresSubscriptionDataDefinition.USER.eq((Object)username)).and(PostgresSubscriptionDataDefinition.MAILBOX.eq((Object)mailbox))));
    }

    public Flux<String> findMailboxByUser(String username) {
        return this.executor.executeRows(dsl -> Flux.from((Publisher)dsl.selectFrom(PostgresSubscriptionDataDefinition.TABLE_NAME).where(PostgresSubscriptionDataDefinition.USER.eq((Object)username)))).map(record -> (String)record.get(PostgresSubscriptionDataDefinition.MAILBOX));
    }
}

