/*
 * Decompiled with CFR 0.152.
 */
package org.jooq;

import java.math.BigDecimal;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jooq.Data;

public final class Decfloat
extends Number
implements Data {
    private final String data;
    private transient BigDecimal coefficient;
    private transient int exponent;
    private transient Special special;

    private Decfloat(String data) {
        this.data = String.valueOf(data);
    }

    @Override
    @NotNull
    public final String data() {
        return this.data;
    }

    @NotNull
    public static final Decfloat valueOf(String data) {
        return new Decfloat(data);
    }

    @NotNull
    public static final Decfloat decfloat(String data) {
        return new Decfloat(data);
    }

    @Nullable
    public static final Decfloat decfloatOrNull(String data) {
        return data == null ? null : Decfloat.decfloat(data);
    }

    public final boolean isNaN() {
        this.parse();
        return this.special == Special.NAN;
    }

    public final boolean isPositiveInfinity() {
        this.parse();
        return this.special == Special.POSITIVE_INFINITY;
    }

    public final boolean isNegativeInfinity() {
        this.parse();
        return this.special == Special.NEGATIVE_INFINITY;
    }

    @Override
    public final double doubleValue() {
        return Double.valueOf(this.data);
    }

    @Override
    public final float floatValue() {
        return Float.valueOf(this.data).floatValue();
    }

    @Override
    public final int intValue() {
        return (int)this.doubleValue();
    }

    @Override
    public final long longValue() {
        return (long)this.doubleValue();
    }

    public int hashCode() {
        this.parse();
        if (this.special != null) {
            return this.special.hashCode();
        }
        if (this.coefficient != null) {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.coefficient == null ? 0 : this.coefficient.hashCode());
            result = 31 * result + this.exponent;
            return result;
        }
        return this.data.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Decfloat) {
            Decfloat x = (Decfloat)obj;
            this.parse();
            x.parse();
            if (this.special != null && x.special != null) {
                return this.special == x.special;
            }
            if (this.coefficient != null && x.coefficient != null) {
                return Objects.equals(this.coefficient, x.coefficient) && this.exponent == x.exponent;
            }
            return Objects.equals(this.data, x.data);
        }
        return false;
    }

    public String toString() {
        this.parse();
        if (this.special != null) {
            switch (this.special.ordinal()) {
                case 0: {
                    return "NaN";
                }
                case 1: {
                    return "Infinity";
                }
                case 2: {
                    return "-Infinity";
                }
            }
        } else if (this.coefficient != null) {
            return this.exponent != 0 ? String.valueOf(this.coefficient) + "E" + this.exponent : this.coefficient.toString();
        }
        return String.valueOf(this.data);
    }

    private final void parse() {
        String lc;
        if (this.coefficient != null || this.special != null) {
            return;
        }
        switch (lc = this.data.toLowerCase()) {
            case "+nan": 
            case "nan": 
            case "-nan": {
                this.special = Special.NAN;
                break;
            }
            case "+infinity": 
            case "infinity": 
            case "+inf": 
            case "inf": {
                this.special = Special.POSITIVE_INFINITY;
                break;
            }
            case "-infinity": 
            case "-inf": {
                this.special = Special.NEGATIVE_INFINITY;
                break;
            }
            default: {
                int i = lc.indexOf("e");
                try {
                    if (i == -1) {
                        this.coefficient = new BigDecimal(this.data);
                    } else {
                        this.coefficient = new BigDecimal(this.data.substring(0, i));
                        this.exponent = Integer.parseInt(this.data.substring(i + 1));
                    }
                    this.normalise();
                }
                catch (NumberFormatException numberFormatException) {}
                break;
            }
        }
    }

    private final void normalise() {
        int scale = this.coefficient.scale();
        int precision = this.coefficient.precision();
        int n = precision - scale - 1;
        if (n != 0) {
            this.coefficient = this.coefficient.movePointLeft(n);
            this.exponent += n;
        }
        this.coefficient = this.coefficient.stripTrailingZeros();
    }

    private static enum Special {
        NAN,
        POSITIVE_INFINITY,
        NEGATIVE_INFINITY;

    }
}

