/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.cassandra.components;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.metadata.schema.KeyspaceMetadata;
import com.datastax.oss.driver.api.querybuilder.schema.CreateType;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.apache.james.backends.cassandra.init.configuration.JamesExecutionProfiles;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class CassandraType {
    private final String name;
    private final CreateType createStatement;

    public CassandraType(String name, CreateType createStatement) {
        this.name = name;
        this.createStatement = createStatement;
    }

    public String getName() {
        return this.name;
    }

    public Mono<InitializationStatus> initialize(KeyspaceMetadata keyspaceMetadata, CqlSession session) {
        if (keyspaceMetadata.getUserDefinedTypes().get(CqlIdentifier.fromCql((String)this.name)) != null) {
            return Mono.just((Object)((Object)InitializationStatus.ALREADY_DONE));
        }
        return Mono.from((Publisher)session.executeReactive(this.createStatement.build().setExecutionProfile(JamesExecutionProfiles.getTableCreationProfile(session)))).thenReturn((Object)InitializationStatus.FULL);
    }

    public final boolean equals(Object o) {
        if (o instanceof CassandraType) {
            CassandraType that = (CassandraType)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.createStatement, that.createStatement);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.name, this.createStatement);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("createStatement", (Object)this.createStatement).toString();
    }

    public static enum InitializationStatus {
        ALREADY_DONE,
        PARTIAL,
        FULL;


        public InitializationStatus reduce(InitializationStatus other) {
            if (this == other) {
                return this;
            }
            return PARTIAL;
        }
    }
}

