/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.util.pngj;

import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.logging.Logger;
import org.jetbrains.letsPlot.commons.logging.PrintlnLogger;
import org.jetbrains.letsPlot.util.pngj.ChunkSeqReaderPng;
import org.jetbrains.letsPlot.util.pngj.Deinterlacer;
import org.jetbrains.letsPlot.util.pngj.InputPngStream;
import org.jetbrains.letsPlot.util.pngj.OutputPngStream;
import org.jetbrains.letsPlot.util.pngj.PngReader;
import org.jetbrains.letsPlot.util.pngj.PngjInputException;
import org.jetbrains.letsPlot.util.pngj.PngjOutputException;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u000e\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0010\u0005\n\u0002\b\b\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001J$\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0006H\u0007J\u000e\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013J\u001e\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u000fJ\u001e\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u000fJ\u000e\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000fJ&\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u000fJ\u0016\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u000fJ\u0016\u0010 \u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u000fJ\u000e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$J\u000e\u0010%\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020$J\u000e\u0010&\u001a\u00020\f2\u0006\u0010#\u001a\u00020$J\u000e\u0010'\u001a\u00020\u00132\u0006\u0010(\u001a\u00020\u000fJ\u000e\u0010)\u001a\u00020\f2\u0006\u0010*\u001a\u00020+J\u000e\u0010,\u001a\u00020\u000f2\u0006\u0010-\u001a\u00020.J&\u0010/\u001a\u00020\f2\u0006\u0010-\u001a\u00020.2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u00100\u001a\u00020\u000fJ\u0018\u00101\u001a\u00020\u000f2\b\u0010\u0016\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u00102\u001a\u00020\u000f2\u0006\u0010-\u001a\u00020.J\u0018\u00103\u001a\u00020\u000f2\b\u0010\u0016\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u00104\u001a\u00020\u000f2\u0006\u0010-\u001a\u00020.J\u0018\u00105\u001a\u00020\u000f2\b\u0010\u0016\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u00106\u001a\u00020\f2\u0006\u0010-\u001a\u00020.2\u0006\u00100\u001a\u00020\"J\u0016\u00107\u001a\u00020\f2\u0006\u00108\u001a\u0002092\u0006\u0010\u0016\u001a\u00020:J\u0016\u00107\u001a\u00020\f2\u0006\u00108\u001a\u0002092\u0006\u0010;\u001a\u00020\bJ\u0016\u0010<\u001a\u00020\f2\u0006\u00108\u001a\u0002092\u0006\u0010\u0016\u001a\u00020\bJ&\u0010<\u001a\u00020\f2\u0006\u00108\u001a\u0002092\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010=\u001a\u00020\u000fJ\u0016\u0010>\u001a\u00020\f2\u0006\u00108\u001a\u0002092\u0006\u0010=\u001a\u00020\u000fJ \u0010?\u001a\u00020\f2\u0006\u0010=\u001a\u00020\u000f2\b\u0010\u0016\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010@\u001a\u00020\f2\u0006\u00108\u001a\u0002092\u0006\u0010=\u001a\u00020\u000fJ \u0010A\u001a\u00020\f2\u0006\u0010=\u001a\u00020\u000f2\b\u0010\u0016\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006B"}, d2={"Lorg/jetbrains/letsPlot/util/pngj/PngHelperInternal;", "", "()V", "LOGGER", "Lorg/jetbrains/letsPlot/commons/logging/Logger;", "isDebug", "", "pngIdSignature", "", "getPngIdSignature", "()[B", "debug", "", "obj", "offset", "", "newLine", "doubleToInt100000", "d", "", "filterPaethPredictor", "a", "b", "c", "filterRowAverage", "r", "left", "up", "filterRowNone", "filterRowPaeth", "upleft", "filterRowSub", "filterRowUp", "getDigest", "", "pngr", "Lorg/jetbrains/letsPlot/util/pngj/PngReader;", "getRawIdatBytes", "initCrcForTests", "intToDouble100000", "i", "logdebug", "msg", "", "readByte", "inputStream", "Lorg/jetbrains/letsPlot/util/pngj/InputPngStream;", "readBytes", "len", "readInt1fromByte", "readInt2", "readInt2fromBytes", "readInt4", "readInt4fromBytes", "skipBytes", "writeByte", "os", "Lorg/jetbrains/letsPlot/util/pngj/OutputPngStream;", "", "bs", "writeBytes", "n", "writeInt2", "writeInt2tobytes", "writeInt4", "writeInt4tobytes", "plot-api"})
public final class PngHelperInternal {
    @NotNull
    public static final PngHelperInternal INSTANCE = new PngHelperInternal();
    private static final boolean isDebug = false;
    @NotNull
    private static final Logger LOGGER;

    private PngHelperInternal() {
    }

    @NotNull
    public final byte[] getPngIdSignature() {
        byte[] byArray = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
        return byArray;
    }

    public final int doubleToInt100000(double d) {
        return (int)(d * 100000.0 + 0.5);
    }

    public final double intToDouble100000(int i) {
        return (double)i / 100000.0;
    }

    public final int readByte(@NotNull InputPngStream inputStream) {
        int n;
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        try {
            n = inputStream.read();
        }
        catch (Throwable e) {
            throw new PngjInputException("error reading byte", e);
        }
        return n;
    }

    public final int readInt2(@NotNull InputPngStream inputStream) {
        int n;
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        try {
            int b1 = inputStream.read();
            int b2 = inputStream.read();
            n = b1 == -1 || b2 == -1 ? -1 : b1 << 8 | b2;
        }
        catch (Throwable e) {
            throw new PngjInputException("error reading Int2", e);
        }
        return n;
    }

    public final int readInt4(@NotNull InputPngStream inputStream) {
        int n;
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        try {
            int b1 = inputStream.read();
            int b2 = inputStream.read();
            int b3 = inputStream.read();
            int b4 = inputStream.read();
            n = b1 == -1 || b2 == -1 || b3 == -1 || b4 == -1 ? -1 : b1 << 24 | b2 << 16 | (b3 << 8) + b4;
        }
        catch (Throwable e) {
            throw new PngjInputException("error reading Int4", e);
        }
        return n;
    }

    public final int readInt1fromByte(@Nullable byte[] b, int offset) {
        if (!(b != null)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return b[offset] & 0xFF;
    }

    public final int readInt2fromBytes(@Nullable byte[] b, int offset) {
        if (!(b != null)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return (b[offset] & 0xFF) << 8 | b[offset + 1] & 0xFF;
    }

    public final int readInt4fromBytes(@Nullable byte[] b, int offset) {
        if (!(b != null)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return (b[offset] & 0xFF) << 24 | (b[offset + 1] & 0xFF) << 16 | (b[offset + 2] & 0xFF) << 8 | b[offset + 3] & 0xFF;
    }

    public final void writeByte(@NotNull OutputPngStream os, byte b) {
        Intrinsics.checkNotNullParameter((Object)os, (String)"os");
        try {
            os.write(b);
        }
        catch (Throwable e) {
            throw new PngjOutputException(e);
        }
    }

    public final void writeByte(@NotNull OutputPngStream os, @NotNull byte[] bs) {
        Intrinsics.checkNotNullParameter((Object)os, (String)"os");
        Intrinsics.checkNotNullParameter((Object)bs, (String)"bs");
        try {
            os.write(bs);
        }
        catch (Throwable e) {
            throw new PngjOutputException(e);
        }
    }

    public final void writeInt2(@NotNull OutputPngStream os, int n) {
        Intrinsics.checkNotNullParameter((Object)os, (String)"os");
        byte[] byArray = new byte[]{(byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
        byte[] temp = byArray;
        this.writeBytes(os, temp);
    }

    public final void writeInt4(@NotNull OutputPngStream os, int n) {
        Intrinsics.checkNotNullParameter((Object)os, (String)"os");
        byte[] temp = new byte[4];
        this.writeInt4tobytes(n, temp, 0);
        this.writeBytes(os, temp);
    }

    public final void writeInt2tobytes(int n, @Nullable byte[] b, int offset) {
        if (!(b != null)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        b[offset] = (byte)(n >> 8 & 0xFF);
        b[offset + 1] = (byte)(n & 0xFF);
    }

    public final void writeInt4tobytes(int n, @Nullable byte[] b, int offset) {
        if (!(b != null)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        b[offset] = (byte)(n >> 24 & 0xFF);
        b[offset + 1] = (byte)(n >> 16 & 0xFF);
        b[offset + 2] = (byte)(n >> 8 & 0xFF);
        b[offset + 3] = (byte)(n & 0xFF);
    }

    public final void readBytes(@NotNull InputPngStream inputStream, @NotNull byte[] b, int offset, int len) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        if (len == 0) {
            return;
        }
        try {
            int n;
            for (int read = 0; read < len; read += n) {
                n = inputStream.read(b, offset + read, len - read);
                if (n >= 1) continue;
                throw new PngjInputException("error reading bytes, " + n + " !=" + len);
            }
        }
        catch (Throwable e) {
            throw new PngjInputException("error reading", e);
        }
    }

    public final void skipBytes(@NotNull InputPngStream inputStream, long len) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        long len2 = len;
        try {
            while (len2 > 0L) {
                long n1 = inputStream.skip(len2);
                if (n1 > 0L) {
                    len2 -= n1;
                    continue;
                }
                if (n1 == 0L) {
                    if (inputStream.read() == -1) break;
                    long l = len2;
                    len2 = l + -1L;
                    continue;
                }
                throw new Throwable("skip() returned a negative value ???");
            }
        }
        catch (Throwable e) {
            throw new PngjInputException(e);
        }
    }

    public final void writeBytes(@NotNull OutputPngStream os, @NotNull byte[] b) {
        Intrinsics.checkNotNullParameter((Object)os, (String)"os");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        try {
            os.write(b);
        }
        catch (Throwable e) {
            throw new PngjOutputException(e);
        }
    }

    public final void writeBytes(@NotNull OutputPngStream os, @NotNull byte[] b, int offset, int n) {
        Intrinsics.checkNotNullParameter((Object)os, (String)"os");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        try {
            os.write(b, offset, n);
        }
        catch (Throwable e) {
            throw new PngjOutputException(e);
        }
    }

    public final void logdebug(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
    }

    public final int filterRowNone(int r) {
        return r & 0xFF;
    }

    public final int filterRowSub(int r, int left) {
        return r - left & 0xFF;
    }

    public final int filterRowUp(int r, int up) {
        return r - up & 0xFF;
    }

    public final int filterRowAverage(int r, int left, int up) {
        return r - (left + up) / 2 & 0xFF;
    }

    public final int filterRowPaeth(int r, int left, int up, int upleft) {
        return r - this.filterPaethPredictor(left, up, upleft) & 0xFF;
    }

    public final int filterPaethPredictor(int a, int b, int c) {
        int pc;
        int p = a + b - c;
        int pa = p >= a ? p - a : a - p;
        int pb = p >= b ? p - b : b - p;
        int n = pc = p >= c ? p - c : c - p;
        return pa <= pb && pa <= pc ? a : (pb <= pc ? b : c);
    }

    public final void debug(@Nullable Object obj) {
        this.debug(obj, 1, true);
    }

    @JvmOverloads
    public final void debug(@Nullable Object obj, int offset, boolean newLine) {
    }

    public static /* synthetic */ void debug$default(PngHelperInternal pngHelperInternal, Object object, int n, boolean bl, int n2, Object object2) {
        if ((n2 & 4) != 0) {
            bl = true;
        }
        pngHelperInternal.debug(object, n, bl);
    }

    public final long getDigest(@NotNull PngReader pngr) {
        Intrinsics.checkNotNullParameter((Object)pngr, (String)"pngr");
        return pngr.getSimpleDigest();
    }

    public final void initCrcForTests(@NotNull PngReader pngr) {
        Intrinsics.checkNotNullParameter((Object)pngr, (String)"pngr");
        pngr.prepareSimpleDigestComputation();
    }

    public final long getRawIdatBytes(@NotNull PngReader r) {
        long l;
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        if (r.isInterlaced()) {
            ChunkSeqReaderPng chunkSeqReaderPng = r.getChunkseq();
            Intrinsics.checkNotNull((Object)chunkSeqReaderPng);
            Deinterlacer deinterlacer = chunkSeqReaderPng.getDeinterlacer();
            Intrinsics.checkNotNull((Object)deinterlacer);
            l = deinterlacer.getTotalRawBytes();
        } else {
            l = r.getCurImgInfo().getTotalRawBytes();
        }
        return l;
    }

    @JvmOverloads
    public final void debug(@Nullable Object obj, int offset) {
        PngHelperInternal.debug$default(this, obj, offset, false, 4, null);
    }

    static {
        String string = Reflection.getOrCreateKotlinClass(PngHelperInternal.class).getSimpleName();
        if (string == null) {
            string = "PngHelperInternal";
        }
        LOGGER = (Logger)new PrintlnLogger(string);
    }
}

