/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.config.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.config.gui.AbstractConfigGui;
import org.apache.jmeter.gui.GUIMenuSortOrder;
import org.apache.jmeter.gui.JBooleanPropertyEditor;
import org.apache.jmeter.gui.JTextComponentBinding;
import org.apache.jmeter.gui.TestElementMetadata;
import org.apache.jmeter.gui.util.HorizontalPanel;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.protocol.http.config.gui.UrlConfigGui;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerBase;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerBaseSchema;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerFactory;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.JEditableCheckBox;
import org.apache.jorphan.gui.JFactory;

@GUIMenuSortOrder(value=5)
@TestElementMetadata(labelResource="url_config_title")
public class HttpDefaultsGui
extends AbstractConfigGui {
    private static final long serialVersionUID = 242L;
    private UrlConfigGui urlConfigGui;
    private final JBooleanPropertyEditor retrieveEmbeddedResources = new JBooleanPropertyEditor(HTTPSamplerBaseSchema.INSTANCE.getRetrieveEmbeddedResources(), JMeterUtils.getResString((String)"web_testing_retrieve_images"));
    private final JBooleanPropertyEditor concurrentDwn = new JBooleanPropertyEditor(HTTPSamplerBaseSchema.INSTANCE.getConcurrentDownload(), JMeterUtils.getResString((String)"web_testing_concurrent_download"));
    private JTextField concurrentPool;
    private final JBooleanPropertyEditor useMD5 = new JBooleanPropertyEditor(HTTPSamplerBaseSchema.INSTANCE.getStoreAsMD5(), JMeterUtils.getResString((String)"response_save_as_md5"));
    private JTextField embeddedAllowRE;
    private JTextField embeddedExcludeRE;
    private JTextField sourceIpAddr;
    private final JComboBox<String> sourceIpType = new JComboBox<String>(HTTPSamplerBase.getSourceTypeList());
    private JTextField proxyScheme;
    private JTextField proxyHost;
    private JTextField proxyPort;
    private JTextField proxyUser;
    private JPasswordField proxyPass;
    private final JComboBox<String> httpImplementation = new JComboBox<String>(HTTPSamplerFactory.getImplementations());
    private JTextField connectTimeOut;
    private JTextField responseTimeOut;

    public HttpDefaultsGui() {
        this.init();
        HTTPSamplerBaseSchema.INSTANCE schema = HTTPSamplerBaseSchema.INSTANCE;
        this.bindingGroup.addAll(Arrays.asList(this.retrieveEmbeddedResources, this.concurrentDwn, new JTextComponentBinding((JTextComponent)this.concurrentPool, schema.getConcurrentDownloadPoolSize()), this.useMD5, new JTextComponentBinding((JTextComponent)this.embeddedAllowRE, schema.getEmbeddedUrlAllowRegex()), new JTextComponentBinding((JTextComponent)this.embeddedExcludeRE, schema.getEmbeddedUrlExcludeRegex()), new JTextComponentBinding((JTextComponent)this.sourceIpAddr, schema.getIpSource()), new JTextComponentBinding((JTextComponent)this.proxyScheme, schema.getProxy().getScheme()), new JTextComponentBinding((JTextComponent)this.proxyHost, schema.getProxy().getHost()), new JTextComponentBinding((JTextComponent)this.proxyPort, schema.getProxy().getPort()), new JTextComponentBinding((JTextComponent)this.proxyUser, schema.getProxy().getUsername()), new JTextComponentBinding((JTextComponent)this.proxyPass, schema.getProxy().getPassword()), new JTextComponentBinding((JTextComponent)this.connectTimeOut, schema.getConnectTimeout()), new JTextComponentBinding((JTextComponent)this.responseTimeOut, schema.getResponseTimeout())));
    }

    public String getLabelResource() {
        return "url_config_title";
    }

    public TestElement createTestElement() {
        ConfigTestElement config = new ConfigTestElement();
        this.modifyTestElement((TestElement)config);
        return config;
    }

    public void modifyTestElement(TestElement config) {
        super.modifyTestElement(config);
        this.urlConfigGui.modifyTestElement(config);
        this.enableConcurrentDwn();
        HTTPSamplerBaseSchema.INSTANCE httpSchema = HTTPSamplerBaseSchema.INSTANCE;
        if (this.concurrentDwn.getValue().equals(JEditableCheckBox.Value.of((boolean)false))) {
            config.removeProperty(httpSchema.getConcurrentDownloadPoolSize());
        }
        if (!StringUtils.isEmpty((CharSequence)this.sourceIpAddr.getText())) {
            config.set(httpSchema.getIpSourceType(), this.sourceIpType.getSelectedIndex());
        } else {
            config.removeProperty(httpSchema.getIpSourceType());
        }
        config.set(httpSchema.getImplementation(), String.valueOf(this.httpImplementation.getSelectedItem()));
    }

    public void clearGui() {
        super.clearGui();
        this.urlConfigGui.clear();
    }

    public void configure(TestElement el) {
        super.configure(el);
        AbstractTestElement samplerBase = (AbstractTestElement)el;
        this.urlConfigGui.configure(el);
        HTTPSamplerBaseSchema.INSTANCE httpSchema = HTTPSamplerBaseSchema.INSTANCE;
        this.sourceIpType.setSelectedIndex(samplerBase.get(httpSchema.getIpSourceType()));
        this.httpImplementation.setSelectedItem(samplerBase.getString(httpSchema.getImplementation()));
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(this.makeBorder());
        this.urlConfigGui = new UrlConfigGui(false, true, false);
        HorizontalPanel httpOptions = new HorizontalPanel();
        httpOptions.add(this.getImplementationPanel());
        httpOptions.add(this.getTimeOutPanel());
        VerticalPanel advancedPanel = new VerticalPanel();
        advancedPanel.add((Component)httpOptions);
        advancedPanel.add(this.createEmbeddedRsrcPanel());
        advancedPanel.add(this.createSourceAddrPanel());
        advancedPanel.add(this.getProxyServerPanel());
        advancedPanel.add(this.createOptionalTasksPanel());
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.add(JMeterUtils.getResString((String)"web_testing_basic"), this.urlConfigGui);
        tabbedPane.add(JMeterUtils.getResString((String)"web_testing_advanced"), (Component)advancedPanel);
        JPanel emptyPanel = new JPanel();
        emptyPanel.setMaximumSize(new Dimension());
        this.add(this.makeTitlePanel(), "North");
        this.add(tabbedPane, "Center");
        this.add(emptyPanel, "South");
    }

    private JPanel getTimeOutPanel() {
        HorizontalPanel timeOut = new HorizontalPanel();
        timeOut.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString((String)"web_server_timeout_title")));
        JPanel connPanel = this.getConnectTimeOutPanel();
        JPanel reqPanel = this.getResponseTimeOutPanel();
        timeOut.add(connPanel);
        timeOut.add(reqPanel);
        return timeOut;
    }

    private JPanel getConnectTimeOutPanel() {
        this.connectTimeOut = new JTextField(10);
        JLabel label = new JLabel(JMeterUtils.getResString((String)"web_server_timeout_connect"));
        label.setLabelFor(this.connectTimeOut);
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        panel.add((Component)label, "West");
        panel.add((Component)this.connectTimeOut, "Center");
        return panel;
    }

    private JPanel getResponseTimeOutPanel() {
        this.responseTimeOut = new JTextField(10);
        JLabel label = new JLabel(JMeterUtils.getResString((String)"web_server_timeout_response"));
        label.setLabelFor(this.responseTimeOut);
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        panel.add((Component)label, "West");
        panel.add((Component)this.responseTimeOut, "Center");
        return panel;
    }

    protected JPanel createEmbeddedRsrcPanel() {
        this.retrieveEmbeddedResources.addPropertyChangeListener("value", ev -> this.enableConcurrentDwn());
        this.concurrentDwn.addPropertyChangeListener("value", ev -> this.enableConcurrentDwn());
        this.concurrentPool = new JTextField(2);
        this.concurrentPool.setMinimumSize(new Dimension(10, (int)this.concurrentPool.getPreferredSize().getHeight()));
        this.concurrentPool.setMaximumSize(new Dimension(60, (int)this.concurrentPool.getPreferredSize().getHeight()));
        JPanel embeddedRsrcPanel = new JPanel((LayoutManager)new MigLayout());
        embeddedRsrcPanel.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString((String)"web_testing_retrieve_title")));
        embeddedRsrcPanel.add((Component)this.retrieveEmbeddedResources);
        embeddedRsrcPanel.add((Component)this.concurrentDwn);
        embeddedRsrcPanel.add((Component)this.concurrentPool, "wrap");
        this.embeddedAllowRE = HttpDefaultsGui.addTextFieldWithLabel(embeddedRsrcPanel, JMeterUtils.getResString((String)"web_testing_embedded_url_pattern"));
        this.embeddedExcludeRE = HttpDefaultsGui.addTextFieldWithLabel(embeddedRsrcPanel, JMeterUtils.getResString((String)"web_testing_embedded_url_exclude_pattern"));
        return embeddedRsrcPanel;
    }

    private static JTextField addTextFieldWithLabel(JPanel panel, String labelText) {
        JLabel label = new JLabel(labelText);
        JTextField field = new JTextField(100);
        label.setLabelFor(field);
        panel.add(label);
        panel.add((Component)field, "span");
        return field;
    }

    protected JPanel createSourceAddrPanel() {
        HorizontalPanel sourceAddrPanel = new HorizontalPanel();
        sourceAddrPanel.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString((String)"web_testing_source_ip")));
        this.sourceIpType.setSelectedIndex(HTTPSamplerBase.SourceType.HOSTNAME.ordinal());
        sourceAddrPanel.add(this.sourceIpType);
        this.sourceIpAddr = new JTextField();
        sourceAddrPanel.add(this.sourceIpAddr);
        return sourceAddrPanel;
    }

    protected JPanel createOptionalTasksPanel() {
        VerticalPanel checkBoxPanel = new VerticalPanel();
        checkBoxPanel.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString((String)"optional_tasks")));
        checkBoxPanel.add((Component)this.useMD5);
        return checkBoxPanel;
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    private void enableConcurrentDwn() {
        boolean enable = !JEditableCheckBox.Value.of((boolean)false).equals(this.retrieveEmbeddedResources.getValue());
        this.concurrentDwn.setEnabled(enable);
        this.embeddedAllowRE.setEnabled(enable);
        this.embeddedExcludeRE.setEnabled(enable);
        this.concurrentPool.setEnabled(enable && !this.concurrentDwn.getValue().equals(JEditableCheckBox.Value.of((boolean)false)));
    }

    protected final JPanel getImplementationPanel() {
        HorizontalPanel implPanel = new HorizontalPanel();
        implPanel.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString((String)"web_server_client")));
        implPanel.add(new JLabel(JMeterUtils.getResString((String)"http_implementation")));
        this.httpImplementation.addItem("");
        implPanel.add(this.httpImplementation);
        return implPanel;
    }

    protected final JPanel getProxyServerPanel() {
        HorizontalPanel proxyServer = new HorizontalPanel();
        proxyServer.add((Component)this.getProxySchemePanel(), "West");
        proxyServer.add((Component)this.getProxyHostPanel(), "Center");
        proxyServer.add((Component)this.getProxyPortPanel(), "East");
        HorizontalPanel proxyLogin = new HorizontalPanel();
        proxyLogin.add(this.getProxyUserPanel());
        proxyLogin.add(this.getProxyPassPanel());
        HorizontalPanel proxyServerPanel = new HorizontalPanel();
        proxyServerPanel.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString((String)"web_proxy_server_title")));
        proxyServerPanel.add((Component)proxyServer);
        proxyServerPanel.add((Component)proxyLogin);
        return proxyServerPanel;
    }

    private JPanel getProxySchemePanel() {
        this.proxyScheme = new JTextField(5);
        JLabel label = new JLabel(JMeterUtils.getResString((String)"web_proxy_scheme"));
        label.setLabelFor(this.proxyScheme);
        JFactory.small((JLabel)label);
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        panel.add((Component)label, "West");
        panel.add((Component)this.proxyScheme, "Center");
        return panel;
    }

    private JPanel getProxyHostPanel() {
        this.proxyHost = new JTextField(10);
        JLabel label = new JLabel(JMeterUtils.getResString((String)"web_server_domain"));
        label.setLabelFor(this.proxyHost);
        JFactory.small((JLabel)label);
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        panel.add((Component)label, "West");
        panel.add((Component)this.proxyHost, "Center");
        return panel;
    }

    private JPanel getProxyPortPanel() {
        this.proxyPort = new JTextField(10);
        JLabel label = new JLabel(JMeterUtils.getResString((String)"web_server_port"));
        label.setLabelFor(this.proxyPort);
        JFactory.small((JLabel)label);
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        panel.add((Component)label, "West");
        panel.add((Component)this.proxyPort, "Center");
        return panel;
    }

    private JPanel getProxyUserPanel() {
        this.proxyUser = new JTextField(5);
        JLabel label = new JLabel(JMeterUtils.getResString((String)"username"));
        label.setLabelFor(this.proxyUser);
        JFactory.small((JLabel)label);
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        panel.add((Component)label, "West");
        panel.add((Component)this.proxyUser, "Center");
        return panel;
    }

    private JPanel getProxyPassPanel() {
        this.proxyPass = new JPasswordField(5);
        JLabel label = new JLabel(JMeterUtils.getResString((String)"password"));
        label.setLabelFor(this.proxyPass);
        JFactory.small((JLabel)label);
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        panel.add((Component)label, "West");
        panel.add((Component)this.proxyPass, "Center");
        return panel;
    }
}

