/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.commons.time.interval;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.formatting.datetime.DateTimeFormatUtil;
import org.jetbrains.letsPlot.commons.intern.datetime.Duration;
import org.jetbrains.letsPlot.core.commons.data.DataType;
import org.jetbrains.letsPlot.core.commons.time.interval.DurationInterval;
import org.jetbrains.letsPlot.core.commons.time.interval.MonthInterval;
import org.jetbrains.letsPlot.core.commons.time.interval.QuarterInterval;
import org.jetbrains.letsPlot.core.commons.time.interval.SemesterInterval;
import org.jetbrains.letsPlot.core.commons.time.interval.YearInterval;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0004\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\b\u0004\b&\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0012H&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR \u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\b0\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/letsPlot/core/commons/time/interval/TimeInterval;", "", "count", "", "(I)V", "getCount", "()I", "tickFormatPattern", "", "getTickFormatPattern", "()Ljava/lang/String;", "tickFormatter", "Lkotlin/Function1;", "", "getTickFormatter", "()Lkotlin/jvm/functions/Function1;", "range", "", "", "start", "end", "Companion", "plot-base"})
public abstract class TimeInterval {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int count;

    protected TimeInterval(int count) {
        this.count = count;
    }

    public final int getCount() {
        return this.count;
    }

    @NotNull
    public abstract String getTickFormatPattern();

    @NotNull
    public Function1<Number, String> getTickFormatter() {
        return DateTimeFormatUtil.INSTANCE.formatterDateUTC(this.getTickFormatPattern());
    }

    @NotNull
    public abstract List<Double> range(double var1, double var3);

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/letsPlot/core/commons/time/interval/TimeInterval$Companion;", "", "()V", "days", "Lorg/jetbrains/letsPlot/core/commons/time/interval/TimeInterval;", "count", "", "fromIntervalDataType", "dataType", "Lorg/jetbrains/letsPlot/core/commons/data/DataType;", "hours", "milliseconds", "minutes", "months", "quarter", "seconds", "semester", "weeks", "years", "plot-base"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TimeInterval milliseconds(int count) {
            return new DurationInterval(Duration.Companion.getMS(), count);
        }

        @NotNull
        public final TimeInterval seconds(int count) {
            return new DurationInterval(Duration.Companion.getSECOND(), count);
        }

        @NotNull
        public final TimeInterval minutes(int count) {
            return new DurationInterval(Duration.Companion.getMINUTE(), count);
        }

        @NotNull
        public final TimeInterval hours(int count) {
            return new DurationInterval(Duration.Companion.getHOUR(), count);
        }

        @NotNull
        public final TimeInterval days(int count) {
            return new DurationInterval(Duration.Companion.getDAY(), count);
        }

        @NotNull
        public final TimeInterval weeks(int count) {
            return new DurationInterval(Duration.Companion.getWEEK(), count);
        }

        @NotNull
        public final TimeInterval months(int count) {
            return new MonthInterval(count);
        }

        private final TimeInterval quarter(int count) {
            return new QuarterInterval(count);
        }

        private final TimeInterval semester(int count) {
            return new SemesterInterval(count);
        }

        @NotNull
        public final TimeInterval years(int count) {
            return new YearInterval(count);
        }

        @NotNull
        public final TimeInterval fromIntervalDataType(@NotNull DataType dataType) {
            TimeInterval timeInterval;
            Intrinsics.checkNotNullParameter((Object)((Object)dataType), (String)"dataType");
            switch (WhenMappings.$EnumSwitchMapping$0[dataType.ordinal()]) {
                case 1: {
                    timeInterval = this.days(1);
                    break;
                }
                case 2: {
                    timeInterval = this.months(1);
                    break;
                }
                case 3: {
                    timeInterval = this.quarter(1);
                    break;
                }
                case 4: {
                    timeInterval = this.semester(1);
                    break;
                }
                case 5: {
                    timeInterval = this.years(1);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Can't create interval from data type: " + (Object)((Object)dataType));
                }
            }
            return timeInterval;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[DataType.values().length];
                try {
                    nArray[DataType.INSTANT_OF_DAY.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DataType.INSTANT_OF_MONTH.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DataType.INSTANT_OF_QUARTER.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DataType.INSTANT_OF_HALF_YEAR.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DataType.INSTANT_OF_YEAR.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

