/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.java.sampler;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.engine.util.ConfigMergabilityIndicator;
import org.apache.jmeter.gui.GUIMenuSortOrder;
import org.apache.jmeter.protocol.java.sampler.BeanShellSamplerSchema;
import org.apache.jmeter.samplers.Entry;
import org.apache.jmeter.samplers.Interruptible;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.schema.BaseTestElementSchema;
import org.apache.jmeter.testelement.schema.PropertiesAccessor;
import org.apache.jmeter.util.BeanShellInterpreter;
import org.apache.jmeter.util.BeanShellTestElement;
import org.apache.jorphan.util.JMeterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GUIMenuSortOrder(value=0x7FFFFFFF)
public class BeanShellSampler
extends BeanShellTestElement
implements Sampler,
Interruptible,
ConfigMergabilityIndicator {
    private static final Set<String> APPLIABLE_CONFIG_CLASSES = new HashSet<String>(Arrays.asList("org.apache.jmeter.config.gui.SimpleConfigGui"));
    private static final Logger log = LoggerFactory.getLogger(BeanShellSampler.class);
    private static final long serialVersionUID = 4L;
    public static final String FILENAME = "BeanShellSampler.filename";
    public static final String SCRIPT = "BeanShellSampler.query";
    public static final String PARAMETERS = "BeanShellSampler.parameters";
    public static final String INIT_FILE = "beanshell.sampler.init";
    public static final String RESET_INTERPRETER = "BeanShellSampler.resetInterpreter";
    private volatile transient BeanShellInterpreter savedBsh = null;

    public BeanShellSamplerSchema getSchema() {
        return BeanShellSamplerSchema.INSTANCE;
    }

    public PropertiesAccessor<? extends BeanShellSampler, ? extends BeanShellSamplerSchema> getProps() {
        return new PropertiesAccessor((TestElement)this, (BaseTestElementSchema)this.getSchema());
    }

    protected String getInitFileProperty() {
        return INIT_FILE;
    }

    public String getScript() {
        return this.get(this.getSchema().getScript());
    }

    public String getFilename() {
        return this.get(this.getSchema().getFilename());
    }

    public String getParameters() {
        return this.get(this.getSchema().getParameters());
    }

    public boolean isResetInterpreter() {
        return this.get(this.getSchema().getResetInterpreter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SampleResult sample(Entry e) {
        SampleResult res = new SampleResult();
        boolean isSuccessful = false;
        res.setSampleLabel(this.getName());
        res.sampleStart();
        BeanShellInterpreter bshInterpreter = this.getBeanShellInterpreter();
        if (bshInterpreter == null) {
            res.sampleEnd();
            res.setResponseCode("503");
            res.setResponseMessage("BeanShell Interpreter not found");
            res.setSuccessful(false);
            return res;
        }
        try {
            bshInterpreter.set("SampleResult", (Object)res);
            bshInterpreter.set("ResponseCode", (Object)"200");
            bshInterpreter.set("ResponseMessage", (Object)"OK");
            bshInterpreter.set("IsSuccess", true);
            res.setDataType("text");
            this.savedBsh = bshInterpreter;
            Object bshOut = this.processFileOrScript(bshInterpreter, res);
            this.savedBsh = null;
            if (bshOut != null) {
                String out = bshOut.toString();
                res.setResponseData(out, null);
            }
            res.setResponseCode(bshInterpreter.get("ResponseCode").toString());
            res.setResponseMessage(bshInterpreter.get("ResponseMessage").toString());
            isSuccessful = Boolean.valueOf(bshInterpreter.get("IsSuccess").toString());
        }
        catch (NoClassDefFoundError ex) {
            log.error("BeanShell Jar missing? {}", (Object)ex.toString());
            res.setResponseCode("501");
            res.setResponseMessage(ex.toString());
            res.setStopThread(true);
        }
        catch (Exception ex) {
            if (log.isWarnEnabled()) {
                log.warn("Exception executing script. {}", (Object)ex.toString());
            }
            res.setResponseCode("500");
            res.setResponseMessage(ex.toString());
        }
        finally {
            this.savedBsh = null;
        }
        res.sampleEnd();
        res.setSuccessful(isSuccessful);
        return res;
    }

    public boolean interrupt() {
        if (this.savedBsh != null) {
            block3: {
                try {
                    this.savedBsh.evalNoLog("interrupt()");
                }
                catch (JMeterException ignored) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug("{} : {}", ((Object)((Object)this)).getClass(), (Object)ignored.getLocalizedMessage());
                }
            }
            return true;
        }
        return false;
    }

    public boolean applies(ConfigTestElement configElement) {
        String guiClass = configElement.getProperty("TestElement.gui_class").getStringValue();
        return APPLIABLE_CONFIG_CLASSES.contains(guiClass);
    }
}

