/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config;

import com.google.common.annotations.VisibleForTesting;
import com.netflix.config.ConcurrentCompositeConfiguration;
import com.netflix.config.ConcurrentMapConfiguration;
import com.netflix.config.ConfigurationManager;
import com.netflix.config.DynamicProperty;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.config.WatchedUpdateListener;
import com.netflix.config.WatchedUpdateResult;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.EnvironmentConfiguration;
import org.apache.commons.configuration.PropertyConverter;
import org.apache.commons.configuration.SystemConfiguration;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.reflect.FieldUtils;
import org.apache.servicecomb.config.ConcurrentMapConfigurationExt;
import org.apache.servicecomb.config.ConfigMapping;
import org.apache.servicecomb.config.DynamicConfigurationExt;
import org.apache.servicecomb.config.DynamicWatchedConfigurationExt;
import org.apache.servicecomb.config.archaius.scheduler.NeverStartPollingScheduler;
import org.apache.servicecomb.config.archaius.sources.ConfigModel;
import org.apache.servicecomb.config.archaius.sources.MicroserviceConfigLoader;
import org.apache.servicecomb.config.archaius.sources.MicroserviceConfigurationSource;
import org.apache.servicecomb.config.event.DynamicConfigurationChangedEvent;
import org.apache.servicecomb.config.spi.ConfigCenterConfigurationSource;
import org.apache.servicecomb.config.spi.ConfigCenterConfigurationSourceLoader;
import org.apache.servicecomb.foundation.common.event.EventManager;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;

public final class ConfigUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigUtil.class);
    private static final String IS_PRINT_URL = "servicecomb.config.log.verbose";
    private static Map<String, Object> localConfig = new HashMap<String, Object>();
    private static final Map<String, Map<String, Object>> EXTRA_CONFIG_MAP = new LinkedHashMap<String, Map<String, Object>>();

    private ConfigUtil() {
    }

    public static void setConfigs(Map<String, Object> config) {
        localConfig = config;
    }

    public static void addConfig(String key, Object value) {
        localConfig.put(key, value);
    }

    public static Object getProperty(String key) {
        AbstractConfiguration config = ConfigurationManager.getConfigInstance();
        return ConfigUtil.getProperty(config, key);
    }

    public static Object getProperty(Object config, String key) {
        if (config instanceof Configuration) {
            Configuration configuration = (Configuration)config;
            return configuration.getProperty(key);
        }
        return null;
    }

    public static List<String> getStringList(@Nonnull Configuration config, @Nonnull String key) {
        return ConfigUtil.parseArrayValue(config.getString(key)).stream().map(v -> Objects.toString(v, null)).collect(Collectors.toList());
    }

    public static List<String> parseArrayValue(String value) {
        return PropertyConverter.split((String)value, (char)',', (boolean)true);
    }

    public static ConcurrentCompositeConfiguration createLocalConfig() {
        boolean isPrintUrl;
        MicroserviceConfigLoader loader = new MicroserviceConfigLoader();
        loader.loadAndSort();
        if (localConfig.size() > 0) {
            ConfigModel model = new ConfigModel();
            model.setConfig(localConfig);
            loader.getConfigModels().add(model);
        }
        if (isPrintUrl = DynamicPropertyFactory.getInstance().getBooleanProperty(IS_PRINT_URL, true).get()) {
            LOGGER.info("create local config from paths=[{}]", (Object)StringUtils.join(loader.getConfigModels(), (String)","));
        }
        ConcurrentCompositeConfiguration config = ConfigUtil.createLocalConfig(loader.getConfigModels());
        return config;
    }

    private static ConcurrentCompositeConfiguration createLocalConfig(List<ConfigModel> configModelList) {
        ConcurrentCompositeConfiguration config = new ConcurrentCompositeConfiguration();
        ConfigUtil.duplicateCseConfigToServicecomb(config, (AbstractConfiguration)new ConcurrentMapConfigurationExt((AbstractConfiguration)new SystemConfiguration()), "configFromSystem");
        ConfigUtil.duplicateCseConfigToServicecomb(config, ConfigUtil.convertEnvVariable((AbstractConfiguration)new ConcurrentMapConfigurationExt((AbstractConfiguration)new EnvironmentConfiguration())), "configFromEnvironment");
        EXTRA_CONFIG_MAP.entrySet().stream().filter(mapEntry -> !((Map)mapEntry.getValue()).isEmpty()).forEachOrdered(configMapEntry -> ConfigUtil.duplicateCseConfigToServicecomb(config, (AbstractConfiguration)new ConcurrentMapConfigurationExt((Map)configMapEntry.getValue()), (String)configMapEntry.getKey()));
        config.addConfiguration((AbstractConfiguration)new DynamicConfigurationExt(new MicroserviceConfigurationSource(configModelList), new NeverStartPollingScheduler()), "configFromYamlFile");
        ConfigUtil.duplicateCseConfigToServicecombAtFront(config, (AbstractConfiguration)new ConcurrentMapConfigurationExt(ConfigMapping.getConvertedMap((Configuration)config)), "configFromMapping");
        return config;
    }

    public static AbstractConfiguration convertEnvVariable(AbstractConfiguration source) {
        Iterator keys = source.getKeys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            CharSequence[] separatedKey = key.split("_");
            if (separatedKey.length == 1) continue;
            String newKey = String.join((CharSequence)".", separatedKey);
            source.addProperty(newKey, source.getProperty(key));
        }
        return source;
    }

    @VisibleForTesting
    static void duplicateCseConfigToServicecomb(AbstractConfiguration source) {
        Iterator keys = source.getKeys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (!key.startsWith("cse.")) continue;
            String servicecombKey = "servicecomb." + key.substring(key.indexOf(".") + 1);
            if (!source.containsKey(servicecombKey)) {
                source.addProperty(servicecombKey, source.getProperty(key));
                continue;
            }
            LOGGER.warn("Key {} with an ambiguous item {} exists, it's recommended to use only one of them.", (Object)key, (Object)servicecombKey);
        }
    }

    private static void duplicateCseConfigToServicecomb(ConcurrentCompositeConfiguration compositeConfiguration, AbstractConfiguration source, String sourceName) {
        ConfigUtil.duplicateCseConfigToServicecomb(source);
        compositeConfiguration.addConfiguration(source, sourceName);
    }

    private static void duplicateCseConfigToServicecombAtFront(ConcurrentCompositeConfiguration compositeConfiguration, AbstractConfiguration source, String sourceName) {
        ConfigUtil.duplicateCseConfigToServicecomb(source);
        compositeConfiguration.addConfigurationAtFront(source, sourceName);
    }

    private static ConfigCenterConfigurationSource createConfigCenterConfigurationSource(Configuration localConfiguration) {
        ConfigCenterConfigurationSource configCenterConfigurationSource = ConfigCenterConfigurationSourceLoader.getConfigCenterConfigurationSource(localConfiguration);
        if (null == configCenterConfigurationSource) {
            LOGGER.info("none of config center source enabled.");
            return null;
        }
        LOGGER.info("use config center source {}", (Object)configCenterConfigurationSource.getClass().getName());
        return configCenterConfigurationSource;
    }

    private static void createDynamicWatchedConfiguration(ConcurrentCompositeConfiguration localConfiguration, ConfigCenterConfigurationSource configCenterConfigurationSource) {
        ConcurrentMapConfigurationExt injectConfig = new ConcurrentMapConfigurationExt();
        localConfiguration.addConfigurationAtFront((AbstractConfiguration)injectConfig, "extraInjectConfig");
        configCenterConfigurationSource.addUpdateListener(new ServiceCombPropertyUpdateListener(injectConfig));
        DynamicWatchedConfigurationExt configFromConfigCenter = new DynamicWatchedConfigurationExt(configCenterConfigurationSource);
        ConfigUtil.duplicateCseConfigToServicecomb((AbstractConfiguration)configFromConfigCenter);
        localConfiguration.addConfigurationAtFront((AbstractConfiguration)configFromConfigCenter, "configCenterConfig");
    }

    public static ConfigCenterConfigurationSource installDynamicConfig() {
        if (ConfigurationManager.isConfigurationInstalled()) {
            LOGGER.warn("Configuration installed by others, will ignore this configuration.");
            return null;
        }
        ConcurrentCompositeConfiguration compositeConfig = ConfigUtil.createLocalConfig();
        ConfigCenterConfigurationSource configCenterConfigurationSource = ConfigUtil.createConfigCenterConfigurationSource((Configuration)compositeConfig);
        if (configCenterConfigurationSource != null) {
            ConfigUtil.createDynamicWatchedConfiguration(compositeConfig, configCenterConfigurationSource);
            configCenterConfigurationSource.init((Configuration)compositeConfig);
        }
        ConfigurationManager.install((AbstractConfiguration)compositeConfig);
        return configCenterConfigurationSource;
    }

    public static void destroyConfigCenterConfigurationSource() {
        SPIServiceUtils.getAllService(ConfigCenterConfigurationSource.class).forEach(source -> {
            try {
                source.destroy();
            }
            catch (Throwable e) {
                LOGGER.error("Failed to destroy {}", (Object)source.getClass().getName());
            }
        });
    }

    public static void addExtraConfig(String extraConfigName, Map<String, Object> extraConfig) {
        EXTRA_CONFIG_MAP.put(extraConfigName, extraConfig);
    }

    public static void clearExtraConfig() {
        EXTRA_CONFIG_MAP.clear();
    }

    public static ConcurrentHashMap<String, DynamicProperty> getAllDynamicProperties() {
        try {
            return (ConcurrentHashMap)FieldUtils.readDeclaredStaticField(DynamicProperty.class, (String)"ALL_PROPS", (boolean)true);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    public static CopyOnWriteArraySet<Runnable> getCallbacks(DynamicProperty property) {
        try {
            return (CopyOnWriteArraySet)FieldUtils.readDeclaredField((Object)property, (String)"callbacks", (boolean)true);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    public static Set<String> propertiesWithPrefix(Environment environment, String prefix) {
        HashSet<String> result = new HashSet<String>();
        for (PropertySource propertySource : ((ConfigurableEnvironment)environment).getPropertySources()) {
            if (!(propertySource instanceof EnumerablePropertySource)) continue;
            for (String key : ((EnumerablePropertySource)propertySource).getPropertyNames()) {
                if (!key.startsWith(prefix)) continue;
                result.add(key);
            }
        }
        return result;
    }

    private static class ServiceCombPropertyUpdateListener
    implements WatchedUpdateListener {
        private final ConcurrentMapConfiguration injectConfig;

        ServiceCombPropertyUpdateListener(ConcurrentMapConfiguration injectConfig) {
            this.injectConfig = injectConfig;
        }

        public void updateConfiguration(WatchedUpdateResult watchedUpdateResult) {
            Map changes;
            Map deletes;
            Map adds = watchedUpdateResult.getAdded();
            if (adds != null) {
                for (Map.Entry entry : adds.entrySet()) {
                    String add = (String)entry.getKey();
                    if (!add.startsWith("cse.")) continue;
                    String key = "servicecomb." + add.substring(add.indexOf(".") + 1);
                    this.injectConfig.addProperty(key, entry.getValue());
                }
            }
            if ((deletes = watchedUpdateResult.getDeleted()) != null) {
                for (String delete : deletes.keySet()) {
                    if (!delete.startsWith("cse.")) continue;
                    this.injectConfig.clearProperty("servicecomb." + delete.substring(delete.indexOf(".") + 1));
                }
            }
            if ((changes = watchedUpdateResult.getChanged()) != null) {
                for (Map.Entry entry : changes.entrySet()) {
                    String change = (String)entry.getKey();
                    if (!change.startsWith("cse.")) continue;
                    String key = "servicecomb." + change.substring(change.indexOf(".") + 1);
                    this.injectConfig.setProperty(key, entry.getValue());
                }
            }
            EventManager.post((Object)new DynamicConfigurationChangedEvent(watchedUpdateResult));
        }
    }
}

