/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.codec.protobuf.utils;

import io.protostuff.compiler.model.Proto;
import io.swagger.models.Swagger;
import java.util.Map;
import org.apache.servicecomb.codec.protobuf.internal.converter.SwaggerToProtoGenerator;
import org.apache.servicecomb.core.definition.SchemaMeta;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.apache.servicecomb.foundation.protobuf.ProtoMapper;
import org.apache.servicecomb.foundation.protobuf.ProtoMapperFactory;

public class ScopedProtobufSchemaManager {
    private final Map<String, ProtoMapper> mapperCache = new ConcurrentHashMapEx();

    public ProtoMapper getOrCreateProtoMapper(SchemaMeta schemaMeta) {
        return this.mapperCache.computeIfAbsent(schemaMeta.getSchemaId(), key -> {
            Swagger swagger = schemaMeta.getSwagger();
            SwaggerToProtoGenerator generator = new SwaggerToProtoGenerator(schemaMeta.getMicroserviceQualifiedName(), swagger);
            Proto proto = generator.convert();
            ProtoMapperFactory protoMapperFactory = new ProtoMapperFactory();
            return protoMapperFactory.create(proto);
        });
    }
}

