/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.util;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.sysds.runtime.util.DependencyTask;
import org.apache.sysds.runtime.util.DependencyThreadPool;

public abstract class DependencyWrapperTask<E>
extends DependencyTask<E> {
    private final List<Future<Future<?>>> _wrappedTaskFutures = new ArrayList();
    private final CompletableFuture<Void> _submitted = new CompletableFuture();
    private final DependencyThreadPool _pool;

    public DependencyWrapperTask(DependencyThreadPool pool) {
        super(() -> null, new ArrayList());
        this._pool = pool;
    }

    public void addWrappedTaskFuture(Future<Future<?>> future) {
        this._wrappedTaskFutures.add(future);
    }

    public List<Future<Future<?>>> getWrappedTaskFuture() throws ExecutionException, InterruptedException {
        this._submitted.get();
        return this._wrappedTaskFutures;
    }

    public abstract List<DependencyTask<?>> getWrappedTasks();

    @Override
    public E call() throws Exception {
        List<DependencyTask<?>> wrappedTasks = this.getWrappedTasks();
        this._dependantTasks.forEach(t -> wrappedTasks.forEach(w -> w.addDependent((DependencyTask<?>)t)));
        this._pool.submitAll(wrappedTasks).forEach(this::addWrappedTaskFuture);
        this._submitted.complete(null);
        return super.call();
    }
}

