/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress;

import java.util.EnumSet;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.conf.DMLConfig;
import org.apache.sysds.runtime.compress.CompressionSettings;
import org.apache.sysds.runtime.compress.DMLCompressionException;
import org.apache.sysds.runtime.compress.cocode.CoCoderFactory;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.insertionsort.InsertionSorterFactory;
import org.apache.sysds.runtime.compress.cost.CostEstimatorFactory;
import org.apache.sysds.runtime.compress.estim.sample.SampleEstimatorFactory;

public class CompressionSettingsBuilder {
    private double samplingRatio;
    private double samplePower = 0.65;
    private boolean allowSharedDictionary = false;
    private String transposeInput;
    private int seed = -1;
    private boolean lossy = false;
    private EnumSet<AColGroup.CompressionType> validCompressions;
    private boolean sortValuesByLength = true;
    private int maxColGroupCoCode = 10000;
    private double coCodePercentage = 0.01;
    private int minimumSampleSize = 3000;
    private int maxSampleSize = 1000000;
    private SampleEstimatorFactory.EstimationType estimationType = SampleEstimatorFactory.EstimationType.HassAndStokes;
    private CoCoderFactory.PartitionerType columnPartitioner;
    private CostEstimatorFactory.CostType costType;
    private double minimumCompressionRatio = 1.0;
    private boolean isInSparkInstruction = false;
    private InsertionSorterFactory.SORT_TYPE sdcSortType = InsertionSorterFactory.SORT_TYPE.MATERIALIZE;

    public CompressionSettingsBuilder() {
        String[] validCompressionsString;
        DMLConfig conf = ConfigurationManager.getDMLConfig();
        this.lossy = conf.getBooleanValue("sysds.compressed.lossy");
        this.validCompressions = EnumSet.of(AColGroup.CompressionType.UNCOMPRESSED, AColGroup.CompressionType.CONST, AColGroup.CompressionType.EMPTY);
        for (String comp : validCompressionsString = conf.getTextValue("sysds.compressed.valid.compressions").split(",")) {
            this.validCompressions.add(AColGroup.CompressionType.valueOf(comp));
        }
        this.samplingRatio = conf.getDoubleValue("sysds.compressed.sampling.ratio");
        this.columnPartitioner = CoCoderFactory.PartitionerType.valueOf(conf.getTextValue("sysds.compressed.cocode"));
        this.costType = CostEstimatorFactory.CostType.valueOf(conf.getTextValue("sysds.compressed.costmodel"));
        this.transposeInput = conf.getTextValue("sysds.compressed.transpose");
        this.seed = DMLScript.SEED;
    }

    public CompressionSettingsBuilder copySettings(CompressionSettings that) {
        this.samplingRatio = that.samplingRatio;
        this.allowSharedDictionary = that.allowSharedDictionary;
        this.transposeInput = that.transposeInput;
        this.seed = that.seed;
        this.lossy = that.lossy;
        this.validCompressions = EnumSet.copyOf(that.validCompressions);
        this.sortValuesByLength = that.sortTuplesByFrequency;
        this.columnPartitioner = that.columnPartitioner;
        this.maxColGroupCoCode = that.maxColGroupCoCode;
        this.coCodePercentage = that.coCodePercentage;
        this.minimumSampleSize = that.minimumSampleSize;
        return this;
    }

    public CompressionSettingsBuilder setLossy(boolean lossy) {
        this.lossy = lossy;
        return this;
    }

    public CompressionSettingsBuilder setSamplingRatio(double samplingRatio) {
        this.samplingRatio = samplingRatio;
        return this;
    }

    public CompressionSettingsBuilder setSortValuesByLength(boolean sortValuesByLength) {
        this.sortValuesByLength = sortValuesByLength;
        return this;
    }

    public CompressionSettingsBuilder setAllowSharedDictionary(boolean allowSharedDictionary) {
        this.allowSharedDictionary = allowSharedDictionary;
        return this;
    }

    public CompressionSettingsBuilder setTransposeInput(String transposeInput) {
        switch (transposeInput) {
            case "auto": 
            case "true": 
            case "false": {
                this.transposeInput = transposeInput;
                break;
            }
            default: {
                throw new DMLCompressionException("Invalid transpose technique");
            }
        }
        return this;
    }

    public CompressionSettingsBuilder setSeed(int seed) {
        this.seed = seed;
        return this;
    }

    public CompressionSettingsBuilder setValidCompressions(EnumSet<AColGroup.CompressionType> validCompressions) {
        if (!validCompressions.contains((Object)AColGroup.CompressionType.UNCOMPRESSED)) {
            validCompressions.add(AColGroup.CompressionType.UNCOMPRESSED);
        }
        if (!validCompressions.contains((Object)AColGroup.CompressionType.CONST)) {
            validCompressions.add(AColGroup.CompressionType.CONST);
        }
        if (!validCompressions.contains((Object)AColGroup.CompressionType.EMPTY)) {
            validCompressions.add(AColGroup.CompressionType.EMPTY);
        }
        this.validCompressions = validCompressions;
        return this;
    }

    public CompressionSettingsBuilder addValidCompression(AColGroup.CompressionType cp) {
        this.validCompressions.add(cp);
        return this;
    }

    public CompressionSettingsBuilder clearValidCompression() {
        this.validCompressions = EnumSet.of(AColGroup.CompressionType.UNCOMPRESSED, AColGroup.CompressionType.EMPTY, AColGroup.CompressionType.CONST);
        return this;
    }

    public CompressionSettingsBuilder setColumnPartitioner(CoCoderFactory.PartitionerType columnPartitioner) {
        this.columnPartitioner = columnPartitioner;
        return this;
    }

    public CompressionSettingsBuilder setMaxColGroupCoCode(int maxColGroupCoCode) {
        this.maxColGroupCoCode = maxColGroupCoCode;
        return this;
    }

    public CompressionSettingsBuilder setCoCodePercentage(double coCodePercentage) {
        this.coCodePercentage = coCodePercentage;
        return this;
    }

    public CompressionSettingsBuilder setMinimumSampleSize(int minimumSampleSize) {
        this.minimumSampleSize = minimumSampleSize;
        return this;
    }

    public CompressionSettingsBuilder setMaxSampleSize(int maxSampleSize) {
        this.maxSampleSize = maxSampleSize;
        return this;
    }

    public CompressionSettingsBuilder setEstimationType(SampleEstimatorFactory.EstimationType estimationType) {
        this.estimationType = estimationType;
        return this;
    }

    public CompressionSettingsBuilder setCostType(CostEstimatorFactory.CostType costType) {
        this.costType = costType;
        return this;
    }

    public CompressionSettingsBuilder setMinimumCompressionRatio(double ratio) {
        this.minimumCompressionRatio = ratio;
        return this;
    }

    public CompressionSettingsBuilder setIsInSparkInstruction() {
        this.isInSparkInstruction = true;
        return this;
    }

    public CompressionSettingsBuilder setSDCSortType(InsertionSorterFactory.SORT_TYPE sdcSortType) {
        this.sdcSortType = sdcSortType;
        return this;
    }

    public CompressionSettings create() {
        return new CompressionSettings(this.samplingRatio, this.samplePower, this.allowSharedDictionary, this.transposeInput, this.seed, this.lossy, this.validCompressions, this.sortValuesByLength, this.columnPartitioner, this.maxColGroupCoCode, this.coCodePercentage, this.minimumSampleSize, this.maxSampleSize, this.estimationType, this.costType, this.minimumCompressionRatio, this.isInSparkInstruction, this.sdcSortType);
    }
}

