/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.caching;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.runtime.controlprogram.caching.ByteBuffer;
import org.apache.sysds.runtime.controlprogram.caching.CacheBlock;
import org.apache.sysds.runtime.controlprogram.caching.CacheEvictionQueue;
import org.apache.sysds.runtime.controlprogram.caching.CacheMaintenanceService;
import org.apache.sysds.runtime.controlprogram.caching.CacheStatistics;
import org.apache.sysds.runtime.controlprogram.caching.CacheableData;
import org.apache.sysds.runtime.util.LocalFileUtils;

public class LazyWriteBuffer {
    protected static final Log LOG = LogFactory.getLog((String)LazyWriteBuffer.class.getName());
    private static long _limit;
    private static long _size;
    private static CacheEvictionQueue _mQueue;
    private static CacheMaintenanceService _fClean;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int writeBlock(String fname, CacheBlock<?> cb) throws IOException {
        long lSize = LazyWriteBuffer.getCacheBlockSize(cb);
        boolean requiresWrite = lSize > _limit || !ByteBuffer.isValidCapacity(lSize, cb);
        int numEvicted = 0;
        if (!requiresWrite) {
            ByteBuffer bbuff = new ByteBuffer(lSize);
            CacheEvictionQueue cacheEvictionQueue = _mQueue;
            synchronized (cacheEvictionQueue) {
                numEvicted += LazyWriteBuffer.evict(lSize);
                _mQueue.addLast(fname, bbuff);
                _size += lSize;
            }
            _fClean.serializeData(bbuff, cb);
            if (DMLScript.STATISTICS) {
                CacheStatistics.incrementBPoolWrites();
                CacheStatistics.incrementFSWrites(numEvicted);
            }
        } else {
            LocalFileUtils.writeCacheBlockToLocal(fname, cb);
            if (DMLScript.STATISTICS) {
                CacheStatistics.incrementFSWrites();
            }
            ++numEvicted;
        }
        return numEvicted;
    }

    private static int evict(long lSize) throws IOException {
        int numEvicted = 0;
        while (_size + lSize > _limit && !_mQueue.isEmpty()) {
            Map.Entry<String, ByteBuffer> entry = _mQueue.removeFirst();
            String ftmp = entry.getKey();
            ByteBuffer tmp = entry.getValue();
            if (tmp == null) continue;
            tmp.checkSerialized();
            tmp.evictBuffer(ftmp);
            tmp.freeMemory();
            _size -= tmp.getSize();
            ++numEvicted;
        }
        return numEvicted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteBlock(String fname) {
        boolean requiresDelete = true;
        CacheEvictionQueue cacheEvictionQueue = _mQueue;
        synchronized (cacheEvictionQueue) {
            ByteBuffer ldata = (ByteBuffer)_mQueue.remove(fname);
            if (ldata != null) {
                _size -= ldata.getSize();
                requiresDelete = false;
                ldata.freeMemory();
            }
        }
        if (requiresDelete) {
            _fClean.deleteFile(fname);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CacheBlock<?> readBlock(String fname, boolean matrix) throws IOException {
        CacheBlock<?> cb = null;
        ByteBuffer ldata = null;
        CacheEvictionQueue cacheEvictionQueue = _mQueue;
        synchronized (cacheEvictionQueue) {
            ldata = (ByteBuffer)_mQueue.get(fname);
            if (CacheableData.CACHING_BUFFER_POLICY == RPolicy.LRU && ldata != null) {
                _mQueue.remove(fname);
                _mQueue.addLast(fname, ldata);
            }
        }
        if (ldata != null) {
            cb = ldata.deserializeBlock();
            if (DMLScript.STATISTICS) {
                CacheStatistics.incrementFSBuffHits();
            }
        } else {
            cb = LocalFileUtils.readCacheBlockFromLocal(fname, matrix);
            if (DMLScript.STATISTICS) {
                CacheStatistics.incrementFSHits();
            }
        }
        return cb;
    }

    public static void init() {
        _mQueue = new CacheEvictionQueue();
        _fClean = new CacheMaintenanceService();
        _limit = OptimizerUtils.getBufferPoolLimit();
        _size = 0L;
    }

    public static void cleanup() {
        if (_mQueue != null) {
            _mQueue.clear();
        }
        if (_fClean != null) {
            _fClean.close();
        }
    }

    public static long getWriteBufferLimit() {
        return _limit;
    }

    public static void setWriteBufferLimit(long limit) {
        _limit = limit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getWriteBufferSize() {
        CacheEvictionQueue cacheEvictionQueue = _mQueue;
        synchronized (cacheEvictionQueue) {
            return _size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getWriteBufferFree() {
        CacheEvictionQueue cacheEvictionQueue = _mQueue;
        synchronized (cacheEvictionQueue) {
            return _limit - _size;
        }
    }

    public static int getQueueSize() {
        return _mQueue.size();
    }

    public static long getCacheBlockSize(CacheBlock<?> cb) {
        return cb.isShallowSerialize() ? cb.getInMemorySize() : cb.getExactSerializedSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printStatus(String position) {
        System.out.println("WRITE BUFFER STATUS (" + position + ") --");
        CacheEvictionQueue cacheEvictionQueue = _mQueue;
        synchronized (cacheEvictionQueue) {
            System.out.println("\tWB: Buffer Meta Data: limit=" + _limit + ", size[bytes]=" + _size + ", size[elements]=" + _mQueue.size() + "/" + _mQueue.size());
            int count = _mQueue.size();
            for (Map.Entry entry : _mQueue.entrySet()) {
                String fname = (String)entry.getKey();
                ByteBuffer bbuff = (ByteBuffer)entry.getValue();
                System.out.println("\tWB: buffer element (" + count + "): " + fname + ", " + (bbuff.isShallow() ? bbuff._cdata.getClass().getSimpleName() : "?") + ", " + bbuff.getSize() + ", " + bbuff.isShallow());
                --count;
            }
        }
    }

    public static void forceEviction() throws IOException {
        while (!_mQueue.isEmpty()) {
            Map.Entry<String, ByteBuffer> entry = _mQueue.removeFirst();
            ByteBuffer tmp = entry.getValue();
            if (tmp == null) continue;
            tmp.checkSerialized();
            tmp.evictBuffer(entry.getKey());
            tmp.freeMemory();
        }
    }

    public static ExecutorService getUtilThreadPool() {
        return _fClean != null ? LazyWriteBuffer._fClean._pool : null;
    }

    public static enum RPolicy {
        FIFO,
        LRU;

    }
}

