/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.frame.data.columns;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.io.Writable;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.utils.MemoryEstimates;

public class ColumnMetadata
implements Serializable,
Writable {
    private static final long serialVersionUID = -90094082422100311L;
    private static final long DEFAULT_DISTINCT = -1L;
    private long _ndistinct = -1L;
    private String _mvValue = null;

    public ColumnMetadata() {
    }

    public ColumnMetadata(long ndistinct) {
        this._ndistinct = ndistinct;
    }

    public ColumnMetadata(long ndistinct, String mvVal) {
        this._ndistinct = ndistinct <= 0L ? -1L : ndistinct;
        this.setMvValue(mvVal);
    }

    public ColumnMetadata(ColumnMetadata that) {
        this._ndistinct = that._ndistinct;
        this._mvValue = that._mvValue;
    }

    public long getNumDistinct() {
        return this._ndistinct;
    }

    public void setNumDistinct(long ndistinct) {
        this._ndistinct = ndistinct <= 0L ? -1L : ndistinct;
    }

    public String getMvValue() {
        return this._mvValue;
    }

    public void setMvValue(String mvVal) {
        this._mvValue = mvVal == null ? null : (mvVal.equals("") ? null : mvVal);
    }

    public boolean isDefault() {
        return this._mvValue == null && this._ndistinct == -1L;
    }

    public long getInMemorySize() {
        long size = 16L;
        size += 8L;
        return size += MemoryEstimates.stringCost(this._mvValue);
    }

    public long getExactSerializedSize() {
        return 8 + IOUtilFunctions.getUTFSize(this.getMvValue());
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(this._ndistinct);
        out.writeUTF(this._mvValue != null ? this._mvValue : "");
    }

    public void readFields(DataInput in) throws IOException {
        this._ndistinct = in.readLong();
        this._mvValue = in.readUTF();
        if (this._mvValue.equals("")) {
            this._mvValue = null;
        }
    }

    public static ColumnMetadata read(DataInput in) throws IOException {
        ColumnMetadata ret = new ColumnMetadata();
        ret.readFields(in);
        return ret;
    }

    public boolean equals(Object that) {
        return that instanceof ColumnMetadata ? this.equals((ColumnMetadata)that) : false;
    }

    public boolean equals(ColumnMetadata that) {
        if (that._ndistinct != this._ndistinct) {
            return false;
        }
        if (that._mvValue == null) {
            return this._mvValue == null;
        }
        if (this._mvValue == null) {
            return false;
        }
        return that._mvValue.equals(this._mvValue);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        if (this._ndistinct != -1L) {
            sb.append(":");
            sb.append(this._ndistinct);
        }
        if (this._mvValue != null) {
            sb.append("--" + this._mvValue);
        }
        return sb.toString();
    }
}

