/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.sysds.common.Types;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import org.apache.sysds.runtime.io.FileFormatPropertiesCSV;
import org.apache.sysds.runtime.io.FrameWriterTextCSV;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.util.CommonThreadPool;
import org.apache.sysds.runtime.util.HDFSTool;
import org.apache.sysds.utils.stats.InfrastructureAnalyzer;

public class FrameWriterTextCSVParallel
extends FrameWriterTextCSV {
    public FrameWriterTextCSVParallel(FileFormatPropertiesCSV props) {
        super(props);
    }

    @Override
    protected void writeCSVFrameToHDFS(Path path, JobConf job, FrameBlock src, long rlen, long clen, FileFormatPropertiesCSV csvprops) throws IOException {
        int numPartFiles = Math.max((int)(OptimizerUtils.estimateSizeTextOutput(rlen, clen, rlen * clen, Types.FileFormat.CSV) / InfrastructureAnalyzer.getHDFSBlockSize()), 1);
        int numThreads = OptimizerUtils.getParallelTextWriteParallelism();
        numThreads = Math.min(numThreads, numPartFiles);
        if (!this._forcedParallel && numThreads <= 1) {
            super.writeCSVFrameToHDFS(path, job, src, rlen, clen, csvprops);
            return;
        }
        HDFSTool.createDirIfNotExistOnHDFS(path, "777");
        FileSystem fs = IOUtilFunctions.getFileSystem(path, (Configuration)job);
        ExecutorService pool = CommonThreadPool.get(numThreads);
        try {
            ArrayList<WriteFileTask> tasks = new ArrayList<WriteFileTask>();
            int blklen = (int)Math.ceil((double)rlen / (double)numThreads);
            int i = 0;
            while (i < numThreads & (long)(i * blklen) < rlen) {
                Path newPath = new Path(path, IOUtilFunctions.getPartFileName(i));
                tasks.add(new WriteFileTask(newPath, job, fs, src, i * blklen, (int)Math.min((long)((i + 1) * blklen), rlen), csvprops));
                ++i;
            }
            for (Future task : pool.invokeAll(tasks)) {
                task.get();
            }
            if (fs instanceof LocalFileSystem) {
                i = 0;
                while (i < numThreads & (long)(i * blklen) < rlen) {
                    IOUtilFunctions.deleteCrcFilesFromLocalFileSystem(fs, new Path(path, IOUtilFunctions.getPartFileName(i)));
                    ++i;
                }
            }
        }
        catch (Exception e) {
            throw new IOException("Failed parallel write of csv output.", e);
        }
        finally {
            pool.shutdown();
        }
    }

    private class WriteFileTask
    implements Callable<Object> {
        private Path _path = null;
        private JobConf _job = null;
        private FileSystem _fs = null;
        private FrameBlock _src = null;
        private int _rl = -1;
        private int _ru = -1;
        private FileFormatPropertiesCSV _csvprops = null;

        public WriteFileTask(Path path, JobConf job, FileSystem fs, FrameBlock src, int rl, int ru, FileFormatPropertiesCSV csvprops) {
            this._path = path;
            this._fs = fs;
            this._job = job;
            this._src = src;
            this._rl = rl;
            this._ru = ru;
            this._csvprops = csvprops;
        }

        @Override
        public Object call() throws Exception {
            FrameWriterTextCSV.writeCSVFrameToFile(this._path, this._job, this._fs, this._src, this._rl, this._ru, this._csvprops);
            return null;
        }
    }
}

