// +build go1.9

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package desktopvirtualization

import (
	"context"

	original "github.com/Azure/azure-sdk-for-go/services/preview/desktopvirtualization/mgmt/2020-11-02-preview/desktopvirtualization"
)

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type ApplicationGroupType = original.ApplicationGroupType

const (
	ApplicationGroupTypeDesktop   ApplicationGroupType = original.ApplicationGroupTypeDesktop
	ApplicationGroupTypeRemoteApp ApplicationGroupType = original.ApplicationGroupTypeRemoteApp
)

type ApplicationType = original.ApplicationType

const (
	ApplicationTypeDesktop   ApplicationType = original.ApplicationTypeDesktop
	ApplicationTypeRemoteApp ApplicationType = original.ApplicationTypeRemoteApp
)

type CommandLineSetting = original.CommandLineSetting

const (
	Allow      CommandLineSetting = original.Allow
	DoNotAllow CommandLineSetting = original.DoNotAllow
	Require    CommandLineSetting = original.Require
)

type HostPoolType = original.HostPoolType

const (
	Personal HostPoolType = original.Personal
	Pooled   HostPoolType = original.Pooled
)

type LoadBalancerType = original.LoadBalancerType

const (
	BreadthFirst LoadBalancerType = original.BreadthFirst
	DepthFirst   LoadBalancerType = original.DepthFirst
	Persistent   LoadBalancerType = original.Persistent
)

type PersonalDesktopAssignmentType = original.PersonalDesktopAssignmentType

const (
	Automatic PersonalDesktopAssignmentType = original.Automatic
	Direct    PersonalDesktopAssignmentType = original.Direct
)

type PreferredAppGroupType = original.PreferredAppGroupType

const (
	PreferredAppGroupTypeDesktop          PreferredAppGroupType = original.PreferredAppGroupTypeDesktop
	PreferredAppGroupTypeNone             PreferredAppGroupType = original.PreferredAppGroupTypeNone
	PreferredAppGroupTypeRailApplications PreferredAppGroupType = original.PreferredAppGroupTypeRailApplications
)

type RegistrationTokenOperation = original.RegistrationTokenOperation

const (
	Delete RegistrationTokenOperation = original.Delete
	None   RegistrationTokenOperation = original.None
	Update RegistrationTokenOperation = original.Update
)

type RemoteApplicationType = original.RemoteApplicationType

const (
	InBuilt         RemoteApplicationType = original.InBuilt
	MsixApplication RemoteApplicationType = original.MsixApplication
)

type SSOSecretType = original.SSOSecretType

const (
	Certificate           SSOSecretType = original.Certificate
	CertificateInKeyVault SSOSecretType = original.CertificateInKeyVault
	SharedKey             SSOSecretType = original.SharedKey
	SharedKeyInKeyVault   SSOSecretType = original.SharedKeyInKeyVault
)

type SessionState = original.SessionState

const (
	Active                 SessionState = original.Active
	Disconnected           SessionState = original.Disconnected
	LogOff                 SessionState = original.LogOff
	Pending                SessionState = original.Pending
	Unknown                SessionState = original.Unknown
	UserProfileDiskMounted SessionState = original.UserProfileDiskMounted
)

type Status = original.Status

const (
	StatusAvailable     Status = original.StatusAvailable
	StatusDisconnected  Status = original.StatusDisconnected
	StatusShutdown      Status = original.StatusShutdown
	StatusUnavailable   Status = original.StatusUnavailable
	StatusUpgradeFailed Status = original.StatusUpgradeFailed
	StatusUpgrading     Status = original.StatusUpgrading
)

type UpdateState = original.UpdateState

const (
	UpdateStateFailed    UpdateState = original.UpdateStateFailed
	UpdateStateInitial   UpdateState = original.UpdateStateInitial
	UpdateStatePending   UpdateState = original.UpdateStatePending
	UpdateStateStarted   UpdateState = original.UpdateStateStarted
	UpdateStateSucceeded UpdateState = original.UpdateStateSucceeded
)

type Application = original.Application
type ApplicationGroup = original.ApplicationGroup
type ApplicationGroupList = original.ApplicationGroupList
type ApplicationGroupListIterator = original.ApplicationGroupListIterator
type ApplicationGroupListPage = original.ApplicationGroupListPage
type ApplicationGroupPatch = original.ApplicationGroupPatch
type ApplicationGroupPatchProperties = original.ApplicationGroupPatchProperties
type ApplicationGroupProperties = original.ApplicationGroupProperties
type ApplicationGroupsClient = original.ApplicationGroupsClient
type ApplicationList = original.ApplicationList
type ApplicationListIterator = original.ApplicationListIterator
type ApplicationListPage = original.ApplicationListPage
type ApplicationPatch = original.ApplicationPatch
type ApplicationPatchProperties = original.ApplicationPatchProperties
type ApplicationProperties = original.ApplicationProperties
type ApplicationsClient = original.ApplicationsClient
type AzureEntityResource = original.AzureEntityResource
type BaseClient = original.BaseClient
type CloudError = original.CloudError
type CloudErrorProperties = original.CloudErrorProperties
type Desktop = original.Desktop
type DesktopList = original.DesktopList
type DesktopPatch = original.DesktopPatch
type DesktopPatchProperties = original.DesktopPatchProperties
type DesktopProperties = original.DesktopProperties
type DesktopsClient = original.DesktopsClient
type ExpandMsixImage = original.ExpandMsixImage
type ExpandMsixImageList = original.ExpandMsixImageList
type ExpandMsixImageListIterator = original.ExpandMsixImageListIterator
type ExpandMsixImageListPage = original.ExpandMsixImageListPage
type ExpandMsixImageProperties = original.ExpandMsixImageProperties
type HostPool = original.HostPool
type HostPoolList = original.HostPoolList
type HostPoolListIterator = original.HostPoolListIterator
type HostPoolListPage = original.HostPoolListPage
type HostPoolPatch = original.HostPoolPatch
type HostPoolPatchProperties = original.HostPoolPatchProperties
type HostPoolProperties = original.HostPoolProperties
type HostPoolsClient = original.HostPoolsClient
type MSIXImageURI = original.MSIXImageURI
type MSIXPackage = original.MSIXPackage
type MSIXPackageList = original.MSIXPackageList
type MSIXPackageListIterator = original.MSIXPackageListIterator
type MSIXPackageListPage = original.MSIXPackageListPage
type MSIXPackagePatch = original.MSIXPackagePatch
type MSIXPackagePatchProperties = original.MSIXPackagePatchProperties
type MSIXPackageProperties = original.MSIXPackageProperties
type MSIXPackagesClient = original.MSIXPackagesClient
type MsixImagesClient = original.MsixImagesClient
type MsixPackageApplications = original.MsixPackageApplications
type MsixPackageDependencies = original.MsixPackageDependencies
type OperationsClient = original.OperationsClient
type ProxyResource = original.ProxyResource
type RegistrationInfo = original.RegistrationInfo
type RegistrationInfoPatch = original.RegistrationInfoPatch
type Resource = original.Resource
type ResourceProviderOperation = original.ResourceProviderOperation
type ResourceProviderOperationDisplay = original.ResourceProviderOperationDisplay
type ResourceProviderOperationList = original.ResourceProviderOperationList
type SendMessage = original.SendMessage
type SessionHost = original.SessionHost
type SessionHostList = original.SessionHostList
type SessionHostListIterator = original.SessionHostListIterator
type SessionHostListPage = original.SessionHostListPage
type SessionHostPatch = original.SessionHostPatch
type SessionHostPatchProperties = original.SessionHostPatchProperties
type SessionHostProperties = original.SessionHostProperties
type SessionHostsClient = original.SessionHostsClient
type StartMenuItem = original.StartMenuItem
type StartMenuItemList = original.StartMenuItemList
type StartMenuItemListIterator = original.StartMenuItemListIterator
type StartMenuItemListPage = original.StartMenuItemListPage
type StartMenuItemProperties = original.StartMenuItemProperties
type StartMenuItemsClient = original.StartMenuItemsClient
type TrackedResource = original.TrackedResource
type UserSession = original.UserSession
type UserSessionList = original.UserSessionList
type UserSessionListIterator = original.UserSessionListIterator
type UserSessionListPage = original.UserSessionListPage
type UserSessionProperties = original.UserSessionProperties
type UserSessionsClient = original.UserSessionsClient
type Workspace = original.Workspace
type WorkspaceList = original.WorkspaceList
type WorkspaceListIterator = original.WorkspaceListIterator
type WorkspaceListPage = original.WorkspaceListPage
type WorkspacePatch = original.WorkspacePatch
type WorkspacePatchProperties = original.WorkspacePatchProperties
type WorkspaceProperties = original.WorkspaceProperties
type WorkspacesClient = original.WorkspacesClient

func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewApplicationGroupListIterator(page ApplicationGroupListPage) ApplicationGroupListIterator {
	return original.NewApplicationGroupListIterator(page)
}
func NewApplicationGroupListPage(cur ApplicationGroupList, getNextPage func(context.Context, ApplicationGroupList) (ApplicationGroupList, error)) ApplicationGroupListPage {
	return original.NewApplicationGroupListPage(cur, getNextPage)
}
func NewApplicationGroupsClient(subscriptionID string) ApplicationGroupsClient {
	return original.NewApplicationGroupsClient(subscriptionID)
}
func NewApplicationGroupsClientWithBaseURI(baseURI string, subscriptionID string) ApplicationGroupsClient {
	return original.NewApplicationGroupsClientWithBaseURI(baseURI, subscriptionID)
}
func NewApplicationListIterator(page ApplicationListPage) ApplicationListIterator {
	return original.NewApplicationListIterator(page)
}
func NewApplicationListPage(cur ApplicationList, getNextPage func(context.Context, ApplicationList) (ApplicationList, error)) ApplicationListPage {
	return original.NewApplicationListPage(cur, getNextPage)
}
func NewApplicationsClient(subscriptionID string) ApplicationsClient {
	return original.NewApplicationsClient(subscriptionID)
}
func NewApplicationsClientWithBaseURI(baseURI string, subscriptionID string) ApplicationsClient {
	return original.NewApplicationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewDesktopsClient(subscriptionID string) DesktopsClient {
	return original.NewDesktopsClient(subscriptionID)
}
func NewDesktopsClientWithBaseURI(baseURI string, subscriptionID string) DesktopsClient {
	return original.NewDesktopsClientWithBaseURI(baseURI, subscriptionID)
}
func NewExpandMsixImageListIterator(page ExpandMsixImageListPage) ExpandMsixImageListIterator {
	return original.NewExpandMsixImageListIterator(page)
}
func NewExpandMsixImageListPage(cur ExpandMsixImageList, getNextPage func(context.Context, ExpandMsixImageList) (ExpandMsixImageList, error)) ExpandMsixImageListPage {
	return original.NewExpandMsixImageListPage(cur, getNextPage)
}
func NewHostPoolListIterator(page HostPoolListPage) HostPoolListIterator {
	return original.NewHostPoolListIterator(page)
}
func NewHostPoolListPage(cur HostPoolList, getNextPage func(context.Context, HostPoolList) (HostPoolList, error)) HostPoolListPage {
	return original.NewHostPoolListPage(cur, getNextPage)
}
func NewHostPoolsClient(subscriptionID string) HostPoolsClient {
	return original.NewHostPoolsClient(subscriptionID)
}
func NewHostPoolsClientWithBaseURI(baseURI string, subscriptionID string) HostPoolsClient {
	return original.NewHostPoolsClientWithBaseURI(baseURI, subscriptionID)
}
func NewMSIXPackageListIterator(page MSIXPackageListPage) MSIXPackageListIterator {
	return original.NewMSIXPackageListIterator(page)
}
func NewMSIXPackageListPage(cur MSIXPackageList, getNextPage func(context.Context, MSIXPackageList) (MSIXPackageList, error)) MSIXPackageListPage {
	return original.NewMSIXPackageListPage(cur, getNextPage)
}
func NewMSIXPackagesClient(subscriptionID string) MSIXPackagesClient {
	return original.NewMSIXPackagesClient(subscriptionID)
}
func NewMSIXPackagesClientWithBaseURI(baseURI string, subscriptionID string) MSIXPackagesClient {
	return original.NewMSIXPackagesClientWithBaseURI(baseURI, subscriptionID)
}
func NewMsixImagesClient(subscriptionID string) MsixImagesClient {
	return original.NewMsixImagesClient(subscriptionID)
}
func NewMsixImagesClientWithBaseURI(baseURI string, subscriptionID string) MsixImagesClient {
	return original.NewMsixImagesClientWithBaseURI(baseURI, subscriptionID)
}
func NewOperationsClient(subscriptionID string) OperationsClient {
	return original.NewOperationsClient(subscriptionID)
}
func NewOperationsClientWithBaseURI(baseURI string, subscriptionID string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewSessionHostListIterator(page SessionHostListPage) SessionHostListIterator {
	return original.NewSessionHostListIterator(page)
}
func NewSessionHostListPage(cur SessionHostList, getNextPage func(context.Context, SessionHostList) (SessionHostList, error)) SessionHostListPage {
	return original.NewSessionHostListPage(cur, getNextPage)
}
func NewSessionHostsClient(subscriptionID string) SessionHostsClient {
	return original.NewSessionHostsClient(subscriptionID)
}
func NewSessionHostsClientWithBaseURI(baseURI string, subscriptionID string) SessionHostsClient {
	return original.NewSessionHostsClientWithBaseURI(baseURI, subscriptionID)
}
func NewStartMenuItemListIterator(page StartMenuItemListPage) StartMenuItemListIterator {
	return original.NewStartMenuItemListIterator(page)
}
func NewStartMenuItemListPage(cur StartMenuItemList, getNextPage func(context.Context, StartMenuItemList) (StartMenuItemList, error)) StartMenuItemListPage {
	return original.NewStartMenuItemListPage(cur, getNextPage)
}
func NewStartMenuItemsClient(subscriptionID string) StartMenuItemsClient {
	return original.NewStartMenuItemsClient(subscriptionID)
}
func NewStartMenuItemsClientWithBaseURI(baseURI string, subscriptionID string) StartMenuItemsClient {
	return original.NewStartMenuItemsClientWithBaseURI(baseURI, subscriptionID)
}
func NewUserSessionListIterator(page UserSessionListPage) UserSessionListIterator {
	return original.NewUserSessionListIterator(page)
}
func NewUserSessionListPage(cur UserSessionList, getNextPage func(context.Context, UserSessionList) (UserSessionList, error)) UserSessionListPage {
	return original.NewUserSessionListPage(cur, getNextPage)
}
func NewUserSessionsClient(subscriptionID string) UserSessionsClient {
	return original.NewUserSessionsClient(subscriptionID)
}
func NewUserSessionsClientWithBaseURI(baseURI string, subscriptionID string) UserSessionsClient {
	return original.NewUserSessionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func NewWorkspaceListIterator(page WorkspaceListPage) WorkspaceListIterator {
	return original.NewWorkspaceListIterator(page)
}
func NewWorkspaceListPage(cur WorkspaceList, getNextPage func(context.Context, WorkspaceList) (WorkspaceList, error)) WorkspaceListPage {
	return original.NewWorkspaceListPage(cur, getNextPage)
}
func NewWorkspacesClient(subscriptionID string) WorkspacesClient {
	return original.NewWorkspacesClient(subscriptionID)
}
func NewWorkspacesClientWithBaseURI(baseURI string, subscriptionID string) WorkspacesClient {
	return original.NewWorkspacesClientWithBaseURI(baseURI, subscriptionID)
}
func PossibleApplicationGroupTypeValues() []ApplicationGroupType {
	return original.PossibleApplicationGroupTypeValues()
}
func PossibleApplicationTypeValues() []ApplicationType {
	return original.PossibleApplicationTypeValues()
}
func PossibleCommandLineSettingValues() []CommandLineSetting {
	return original.PossibleCommandLineSettingValues()
}
func PossibleHostPoolTypeValues() []HostPoolType {
	return original.PossibleHostPoolTypeValues()
}
func PossibleLoadBalancerTypeValues() []LoadBalancerType {
	return original.PossibleLoadBalancerTypeValues()
}
func PossiblePersonalDesktopAssignmentTypeValues() []PersonalDesktopAssignmentType {
	return original.PossiblePersonalDesktopAssignmentTypeValues()
}
func PossiblePreferredAppGroupTypeValues() []PreferredAppGroupType {
	return original.PossiblePreferredAppGroupTypeValues()
}
func PossibleRegistrationTokenOperationValues() []RegistrationTokenOperation {
	return original.PossibleRegistrationTokenOperationValues()
}
func PossibleRemoteApplicationTypeValues() []RemoteApplicationType {
	return original.PossibleRemoteApplicationTypeValues()
}
func PossibleSSOSecretTypeValues() []SSOSecretType {
	return original.PossibleSSOSecretTypeValues()
}
func PossibleSessionStateValues() []SessionState {
	return original.PossibleSessionStateValues()
}
func PossibleStatusValues() []Status {
	return original.PossibleStatusValues()
}
func PossibleUpdateStateValues() []UpdateState {
	return original.PossibleUpdateStateValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
