package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListScenario invokes the arms.ListScenario API synchronously
func (client *Client) ListScenario(request *ListScenarioRequest) (response *ListScenarioResponse, err error) {
	response = CreateListScenarioResponse()
	err = client.DoAction(request, response)
	return
}

// ListScenarioWithChan invokes the arms.ListScenario API asynchronously
func (client *Client) ListScenarioWithChan(request *ListScenarioRequest) (<-chan *ListScenarioResponse, <-chan error) {
	responseChan := make(chan *ListScenarioResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListScenario(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListScenarioWithCallback invokes the arms.ListScenario API asynchronously
func (client *Client) ListScenarioWithCallback(request *ListScenarioRequest, callback func(response *ListScenarioResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListScenarioResponse
		var err error
		defer close(result)
		response, err = client.ListScenario(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListScenarioRequest is the request struct for api ListScenario
type ListScenarioRequest struct {
	*requests.RpcRequest
	Scenario string `position:"Query" name:"Scenario"`
	AppId    string `position:"Query" name:"AppId"`
	Name     string `position:"Query" name:"Name"`
	Sign     string `position:"Query" name:"Sign"`
}

// ListScenarioResponse is the response struct for api ListScenario
type ListScenarioResponse struct {
	*responses.BaseResponse
	RequestId     string              `json:"RequestId" xml:"RequestId"`
	ArmsScenarios []ArmsScenariosItem `json:"ArmsScenarios" xml:"ArmsScenarios"`
}

// CreateListScenarioRequest creates a request to invoke ListScenario API
func CreateListScenarioRequest() (request *ListScenarioRequest) {
	request = &ListScenarioRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "ListScenario", "", "")
	request.Method = requests.POST
	return
}

// CreateListScenarioResponse creates a response to parse from ListScenario response
func CreateListScenarioResponse() (response *ListScenarioResponse) {
	response = &ListScenarioResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
