package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// EnableService invokes the cloudcallcenter.EnableService API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/enableservice.html
func (client *Client) EnableService(request *EnableServiceRequest) (response *EnableServiceResponse, err error) {
	response = CreateEnableServiceResponse()
	err = client.DoAction(request, response)
	return
}

// EnableServiceWithChan invokes the cloudcallcenter.EnableService API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/enableservice.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) EnableServiceWithChan(request *EnableServiceRequest) (<-chan *EnableServiceResponse, <-chan error) {
	responseChan := make(chan *EnableServiceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.EnableService(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// EnableServiceWithCallback invokes the cloudcallcenter.EnableService API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/enableservice.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) EnableServiceWithCallback(request *EnableServiceRequest, callback func(response *EnableServiceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *EnableServiceResponse
		var err error
		defer close(result)
		response, err = client.EnableService(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// EnableServiceRequest is the request struct for api EnableService
type EnableServiceRequest struct {
	*requests.RpcRequest
	AliyunPk requests.Integer `position:"Query" name:"AliyunPk"`
}

// EnableServiceResponse is the response struct for api EnableService
type EnableServiceResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
}

// CreateEnableServiceRequest creates a request to invoke EnableService API
func CreateEnableServiceRequest() (request *EnableServiceRequest) {
	request = &EnableServiceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "EnableService", "", "")
	request.Method = requests.POST
	return
}

// CreateEnableServiceResponse creates a response to parse from EnableService response
func CreateEnableServiceResponse() (response *EnableServiceResponse) {
	response = &EnableServiceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
