package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateSubAccountPermission invokes the cloudwf.CreateSubAccountPermission API synchronously
// api document: https://help.aliyun.com/api/cloudwf/createsubaccountpermission.html
func (client *Client) CreateSubAccountPermission(request *CreateSubAccountPermissionRequest) (response *CreateSubAccountPermissionResponse, err error) {
	response = CreateCreateSubAccountPermissionResponse()
	err = client.DoAction(request, response)
	return
}

// CreateSubAccountPermissionWithChan invokes the cloudwf.CreateSubAccountPermission API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/createsubaccountpermission.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateSubAccountPermissionWithChan(request *CreateSubAccountPermissionRequest) (<-chan *CreateSubAccountPermissionResponse, <-chan error) {
	responseChan := make(chan *CreateSubAccountPermissionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateSubAccountPermission(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateSubAccountPermissionWithCallback invokes the cloudwf.CreateSubAccountPermission API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/createsubaccountpermission.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateSubAccountPermissionWithCallback(request *CreateSubAccountPermissionRequest, callback func(response *CreateSubAccountPermissionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateSubAccountPermissionResponse
		var err error
		defer close(result)
		response, err = client.CreateSubAccountPermission(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateSubAccountPermissionRequest is the request struct for api CreateSubAccountPermission
type CreateSubAccountPermissionRequest struct {
	*requests.RpcRequest
	Uid            requests.Integer `position:"Query" name:"Uid"`
	ShopGroupIds   *[]string        `position:"Query" name:"ShopGroupIds"  type:"Repeated"`
	ShopIds        *[]string        `position:"Query" name:"ShopIds"  type:"Repeated"`
	PagePermission string           `position:"Query" name:"PagePermission"`
	PermissionType requests.Integer `position:"Query" name:"PermissionType"`
	BusinessIds    *[]string        `position:"Query" name:"BusinessIds"  type:"Repeated"`
}

// CreateSubAccountPermissionResponse is the response struct for api CreateSubAccountPermission
type CreateSubAccountPermissionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateCreateSubAccountPermissionRequest creates a request to invoke CreateSubAccountPermission API
func CreateCreateSubAccountPermissionRequest() (request *CreateSubAccountPermissionRequest) {
	request = &CreateSubAccountPermissionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "CreateSubAccountPermission", "cloudwf", "openAPI")
	return
}

// CreateCreateSubAccountPermissionResponse creates a response to parse from CreateSubAccountPermission response
func CreateCreateSubAccountPermissionResponse() (response *CreateSubAccountPermissionResponse) {
	response = &CreateSubAccountPermissionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
