package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SaveApRadioConfig invokes the cloudwf.SaveApRadioConfig API synchronously
// api document: https://help.aliyun.com/api/cloudwf/saveapradioconfig.html
func (client *Client) SaveApRadioConfig(request *SaveApRadioConfigRequest) (response *SaveApRadioConfigResponse, err error) {
	response = CreateSaveApRadioConfigResponse()
	err = client.DoAction(request, response)
	return
}

// SaveApRadioConfigWithChan invokes the cloudwf.SaveApRadioConfig API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/saveapradioconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SaveApRadioConfigWithChan(request *SaveApRadioConfigRequest) (<-chan *SaveApRadioConfigResponse, <-chan error) {
	responseChan := make(chan *SaveApRadioConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SaveApRadioConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SaveApRadioConfigWithCallback invokes the cloudwf.SaveApRadioConfig API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/saveapradioconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SaveApRadioConfigWithCallback(request *SaveApRadioConfigRequest, callback func(response *SaveApRadioConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SaveApRadioConfigResponse
		var err error
		defer close(result)
		response, err = client.SaveApRadioConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SaveApRadioConfigRequest is the request struct for api SaveApRadioConfig
type SaveApRadioConfigRequest struct {
	*requests.RpcRequest
	RequireMode        string           `position:"Query" name:"RequireMode"`
	Htmode             string           `position:"Query" name:"Htmode"`
	Frag               requests.Integer `position:"Query" name:"Frag"`
	Minrate            requests.Integer `position:"Query" name:"Minrate"`
	McastRate          requests.Integer `position:"Query" name:"McastRate"`
	Probereq           requests.Integer `position:"Query" name:"Probereq"`
	Channel            requests.Integer `position:"Query" name:"Channel"`
	Shortgi            requests.Integer `position:"Query" name:"Shortgi"`
	Hwmode             string           `position:"Query" name:"Hwmode"`
	Uapsd              requests.Integer `position:"Query" name:"Uapsd"`
	BeaconInt          requests.Integer `position:"Query" name:"BeaconInt"`
	Mac                string           `position:"Query" name:"Mac"`
	Rts                requests.Integer `position:"Query" name:"Rts"`
	Txpower            requests.Integer `position:"Query" name:"Txpower"`
	Noscan             requests.Integer `position:"Query" name:"Noscan"`
	BcastRate          requests.Integer `position:"Query" name:"BcastRate"`
	Disabled           requests.Integer `position:"Query" name:"Disabled"`
	InstantlyEffective requests.Integer `position:"Query" name:"InstantlyEffective"`
	Id                 requests.Integer `position:"Query" name:"Id"`
	RadioIndex         requests.Integer `position:"Query" name:"RadioIndex"`
}

// SaveApRadioConfigResponse is the response struct for api SaveApRadioConfig
type SaveApRadioConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateSaveApRadioConfigRequest creates a request to invoke SaveApRadioConfig API
func CreateSaveApRadioConfigRequest() (request *SaveApRadioConfigRequest) {
	request = &SaveApRadioConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "SaveApRadioConfig", "cloudwf", "openAPI")
	return
}

// CreateSaveApRadioConfigResponse creates a response to parse from SaveApRadioConfig response
func CreateSaveApRadioConfigResponse() (response *SaveApRadioConfigResponse) {
	response = &SaveApRadioConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
