package domain

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CancelOperationAudit invokes the domain.CancelOperationAudit API synchronously
func (client *Client) CancelOperationAudit(request *CancelOperationAuditRequest) (response *CancelOperationAuditResponse, err error) {
	response = CreateCancelOperationAuditResponse()
	err = client.DoAction(request, response)
	return
}

// CancelOperationAuditWithChan invokes the domain.CancelOperationAudit API asynchronously
func (client *Client) CancelOperationAuditWithChan(request *CancelOperationAuditRequest) (<-chan *CancelOperationAuditResponse, <-chan error) {
	responseChan := make(chan *CancelOperationAuditResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CancelOperationAudit(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CancelOperationAuditWithCallback invokes the domain.CancelOperationAudit API asynchronously
func (client *Client) CancelOperationAuditWithCallback(request *CancelOperationAuditRequest, callback func(response *CancelOperationAuditResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CancelOperationAuditResponse
		var err error
		defer close(result)
		response, err = client.CancelOperationAudit(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CancelOperationAuditRequest is the request struct for api CancelOperationAudit
type CancelOperationAuditRequest struct {
	*requests.RpcRequest
	AuditRecordId requests.Integer `position:"Query" name:"AuditRecordId"`
	Lang          string           `position:"Query" name:"Lang"`
}

// CancelOperationAuditResponse is the response struct for api CancelOperationAudit
type CancelOperationAuditResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCancelOperationAuditRequest creates a request to invoke CancelOperationAudit API
func CreateCancelOperationAuditRequest() (request *CancelOperationAuditRequest) {
	request = &CancelOperationAuditRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Domain", "2018-01-29", "CancelOperationAudit", "", "")
	request.Method = requests.POST
	return
}

// CreateCancelOperationAuditResponse creates a response to parse from CancelOperationAudit response
func CreateCancelOperationAuditResponse() (response *CancelOperationAuditResponse) {
	response = &CancelOperationAuditResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
