package ga

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteIpSet invokes the ga.DeleteIpSet API synchronously
func (client *Client) DeleteIpSet(request *DeleteIpSetRequest) (response *DeleteIpSetResponse, err error) {
	response = CreateDeleteIpSetResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteIpSetWithChan invokes the ga.DeleteIpSet API asynchronously
func (client *Client) DeleteIpSetWithChan(request *DeleteIpSetRequest) (<-chan *DeleteIpSetResponse, <-chan error) {
	responseChan := make(chan *DeleteIpSetResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteIpSet(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteIpSetWithCallback invokes the ga.DeleteIpSet API asynchronously
func (client *Client) DeleteIpSetWithCallback(request *DeleteIpSetRequest, callback func(response *DeleteIpSetResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteIpSetResponse
		var err error
		defer close(result)
		response, err = client.DeleteIpSet(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteIpSetRequest is the request struct for api DeleteIpSet
type DeleteIpSetRequest struct {
	*requests.RpcRequest
	ClientToken   string `position:"Query" name:"ClientToken"`
	IpSetId       string `position:"Query" name:"IpSetId"`
	AcceleratorId string `position:"Query" name:"AcceleratorId"`
}

// DeleteIpSetResponse is the response struct for api DeleteIpSet
type DeleteIpSetResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteIpSetRequest creates a request to invoke DeleteIpSet API
func CreateDeleteIpSetRequest() (request *DeleteIpSetRequest) {
	request = &DeleteIpSetRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ga", "2019-11-20", "DeleteIpSet", "gaplus", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteIpSetResponse creates a response to parse from DeleteIpSet response
func CreateDeleteIpSetResponse() (response *DeleteIpSetResponse) {
	response = &DeleteIpSetResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
