package imageaudit

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ScanImage invokes the imageaudit.ScanImage API synchronously
func (client *Client) ScanImage(request *ScanImageRequest) (response *ScanImageResponse, err error) {
	response = CreateScanImageResponse()
	err = client.DoAction(request, response)
	return
}

// ScanImageWithChan invokes the imageaudit.ScanImage API asynchronously
func (client *Client) ScanImageWithChan(request *ScanImageRequest) (<-chan *ScanImageResponse, <-chan error) {
	responseChan := make(chan *ScanImageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ScanImage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ScanImageWithCallback invokes the imageaudit.ScanImage API asynchronously
func (client *Client) ScanImageWithCallback(request *ScanImageRequest, callback func(response *ScanImageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ScanImageResponse
		var err error
		defer close(result)
		response, err = client.ScanImage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ScanImageRequest is the request struct for api ScanImage
type ScanImageRequest struct {
	*requests.RpcRequest
	Scene *[]string        `position:"Body" name:"Scene"  type:"Repeated"`
	Task  *[]ScanImageTask `position:"Body" name:"Task"  type:"Repeated"`
}

// ScanImageTask is a repeated param struct in ScanImageRequest
type ScanImageTask struct {
	DataId               string `name:"DataId"`
	ImageURL             string `name:"ImageURL"`
	MaxFrames            string `name:"MaxFrames"`
	Interval             string `name:"Interval"`
	ImageTimeMillisecond string `name:"ImageTimeMillisecond"`
}

// ScanImageResponse is the response struct for api ScanImage
type ScanImageResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateScanImageRequest creates a request to invoke ScanImage API
func CreateScanImageRequest() (request *ScanImageRequest) {
	request = &ScanImageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imageaudit", "2019-12-30", "ScanImage", "imageaudit", "openAPI")
	request.Method = requests.POST
	return
}

// CreateScanImageResponse creates a response to parse from ScanImage response
func CreateScanImageResponse() (response *ScanImageResponse) {
	response = &ScanImageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
