package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifySAGAdminPassword invokes the smartag.ModifySAGAdminPassword API synchronously
func (client *Client) ModifySAGAdminPassword(request *ModifySAGAdminPasswordRequest) (response *ModifySAGAdminPasswordResponse, err error) {
	response = CreateModifySAGAdminPasswordResponse()
	err = client.DoAction(request, response)
	return
}

// ModifySAGAdminPasswordWithChan invokes the smartag.ModifySAGAdminPassword API asynchronously
func (client *Client) ModifySAGAdminPasswordWithChan(request *ModifySAGAdminPasswordRequest) (<-chan *ModifySAGAdminPasswordResponse, <-chan error) {
	responseChan := make(chan *ModifySAGAdminPasswordResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifySAGAdminPassword(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifySAGAdminPasswordWithCallback invokes the smartag.ModifySAGAdminPassword API asynchronously
func (client *Client) ModifySAGAdminPasswordWithCallback(request *ModifySAGAdminPasswordRequest, callback func(response *ModifySAGAdminPasswordResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifySAGAdminPasswordResponse
		var err error
		defer close(result)
		response, err = client.ModifySAGAdminPassword(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifySAGAdminPasswordRequest is the request struct for api ModifySAGAdminPassword
type ModifySAGAdminPasswordRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Password             string           `position:"Query" name:"Password"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	SmartAGId            string           `position:"Query" name:"SmartAGId"`
	SmartAGSn            string           `position:"Query" name:"SmartAGSn"`
}

// ModifySAGAdminPasswordResponse is the response struct for api ModifySAGAdminPassword
type ModifySAGAdminPasswordResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifySAGAdminPasswordRequest creates a request to invoke ModifySAGAdminPassword API
func CreateModifySAGAdminPasswordRequest() (request *ModifySAGAdminPasswordRequest) {
	request = &ModifySAGAdminPasswordRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "ModifySAGAdminPassword", "smartag", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifySAGAdminPasswordResponse creates a response to parse from ModifySAGAdminPassword response
func CreateModifySAGAdminPasswordResponse() (response *ModifySAGAdminPasswordResponse) {
	response = &ModifySAGAdminPasswordResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
