package airec

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteFilteringAlgorithm invokes the airec.DeleteFilteringAlgorithm API synchronously
func (client *Client) DeleteFilteringAlgorithm(request *DeleteFilteringAlgorithmRequest) (response *DeleteFilteringAlgorithmResponse, err error) {
	response = CreateDeleteFilteringAlgorithmResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteFilteringAlgorithmWithChan invokes the airec.DeleteFilteringAlgorithm API asynchronously
func (client *Client) DeleteFilteringAlgorithmWithChan(request *DeleteFilteringAlgorithmRequest) (<-chan *DeleteFilteringAlgorithmResponse, <-chan error) {
	responseChan := make(chan *DeleteFilteringAlgorithmResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteFilteringAlgorithm(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteFilteringAlgorithmWithCallback invokes the airec.DeleteFilteringAlgorithm API asynchronously
func (client *Client) DeleteFilteringAlgorithmWithCallback(request *DeleteFilteringAlgorithmRequest, callback func(response *DeleteFilteringAlgorithmResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteFilteringAlgorithmResponse
		var err error
		defer close(result)
		response, err = client.DeleteFilteringAlgorithm(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteFilteringAlgorithmRequest is the request struct for api DeleteFilteringAlgorithm
type DeleteFilteringAlgorithmRequest struct {
	*requests.RoaRequest
	InstanceId  string `position:"Path" name:"instanceId"`
	AlgorithmId string `position:"Path" name:"algorithmId"`
}

// DeleteFilteringAlgorithmResponse is the response struct for api DeleteFilteringAlgorithm
type DeleteFilteringAlgorithmResponse struct {
	*responses.BaseResponse
	RequestId string                           `json:"requestId" xml:"requestId"`
	Result    ResultInDeleteFilteringAlgorithm `json:"result" xml:"result"`
}

// CreateDeleteFilteringAlgorithmRequest creates a request to invoke DeleteFilteringAlgorithm API
func CreateDeleteFilteringAlgorithmRequest() (request *DeleteFilteringAlgorithmRequest) {
	request = &DeleteFilteringAlgorithmRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Airec", "2020-11-26", "DeleteFilteringAlgorithm", "/v2/openapi/instances/[instanceId]/filtering-algorithms/[algorithmId]", "airec", "openAPI")
	request.Method = requests.DELETE
	return
}

// CreateDeleteFilteringAlgorithmResponse creates a response to parse from DeleteFilteringAlgorithm response
func CreateDeleteFilteringAlgorithmResponse() (response *DeleteFilteringAlgorithmResponse) {
	response = &DeleteFilteringAlgorithmResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
