package alidns

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SwitchDnsGtmInstanceStrategyMode invokes the alidns.SwitchDnsGtmInstanceStrategyMode API synchronously
func (client *Client) SwitchDnsGtmInstanceStrategyMode(request *SwitchDnsGtmInstanceStrategyModeRequest) (response *SwitchDnsGtmInstanceStrategyModeResponse, err error) {
	response = CreateSwitchDnsGtmInstanceStrategyModeResponse()
	err = client.DoAction(request, response)
	return
}

// SwitchDnsGtmInstanceStrategyModeWithChan invokes the alidns.SwitchDnsGtmInstanceStrategyMode API asynchronously
func (client *Client) SwitchDnsGtmInstanceStrategyModeWithChan(request *SwitchDnsGtmInstanceStrategyModeRequest) (<-chan *SwitchDnsGtmInstanceStrategyModeResponse, <-chan error) {
	responseChan := make(chan *SwitchDnsGtmInstanceStrategyModeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SwitchDnsGtmInstanceStrategyMode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SwitchDnsGtmInstanceStrategyModeWithCallback invokes the alidns.SwitchDnsGtmInstanceStrategyMode API asynchronously
func (client *Client) SwitchDnsGtmInstanceStrategyModeWithCallback(request *SwitchDnsGtmInstanceStrategyModeRequest, callback func(response *SwitchDnsGtmInstanceStrategyModeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SwitchDnsGtmInstanceStrategyModeResponse
		var err error
		defer close(result)
		response, err = client.SwitchDnsGtmInstanceStrategyMode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SwitchDnsGtmInstanceStrategyModeRequest is the request struct for api SwitchDnsGtmInstanceStrategyMode
type SwitchDnsGtmInstanceStrategyModeRequest struct {
	*requests.RpcRequest
	InstanceId   string `position:"Query" name:"InstanceId"`
	UserClientIp string `position:"Query" name:"UserClientIp"`
	StrategyMode string `position:"Query" name:"StrategyMode"`
	Lang         string `position:"Query" name:"Lang"`
}

// SwitchDnsGtmInstanceStrategyModeResponse is the response struct for api SwitchDnsGtmInstanceStrategyMode
type SwitchDnsGtmInstanceStrategyModeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSwitchDnsGtmInstanceStrategyModeRequest creates a request to invoke SwitchDnsGtmInstanceStrategyMode API
func CreateSwitchDnsGtmInstanceStrategyModeRequest() (request *SwitchDnsGtmInstanceStrategyModeRequest) {
	request = &SwitchDnsGtmInstanceStrategyModeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alidns", "2015-01-09", "SwitchDnsGtmInstanceStrategyMode", "alidns", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSwitchDnsGtmInstanceStrategyModeResponse creates a response to parse from SwitchDnsGtmInstanceStrategyMode response
func CreateSwitchDnsGtmInstanceStrategyModeResponse() (response *SwitchDnsGtmInstanceStrategyModeResponse) {
	response = &SwitchDnsGtmInstanceStrategyModeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
