package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateFabricOrganizationUser invokes the baas.CreateFabricOrganizationUser API synchronously
// api document: https://help.aliyun.com/api/baas/createfabricorganizationuser.html
func (client *Client) CreateFabricOrganizationUser(request *CreateFabricOrganizationUserRequest) (response *CreateFabricOrganizationUserResponse, err error) {
	response = CreateCreateFabricOrganizationUserResponse()
	err = client.DoAction(request, response)
	return
}

// CreateFabricOrganizationUserWithChan invokes the baas.CreateFabricOrganizationUser API asynchronously
// api document: https://help.aliyun.com/api/baas/createfabricorganizationuser.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateFabricOrganizationUserWithChan(request *CreateFabricOrganizationUserRequest) (<-chan *CreateFabricOrganizationUserResponse, <-chan error) {
	responseChan := make(chan *CreateFabricOrganizationUserResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateFabricOrganizationUser(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateFabricOrganizationUserWithCallback invokes the baas.CreateFabricOrganizationUser API asynchronously
// api document: https://help.aliyun.com/api/baas/createfabricorganizationuser.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateFabricOrganizationUserWithCallback(request *CreateFabricOrganizationUserRequest, callback func(response *CreateFabricOrganizationUserResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateFabricOrganizationUserResponse
		var err error
		defer close(result)
		response, err = client.CreateFabricOrganizationUser(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateFabricOrganizationUserRequest is the request struct for api CreateFabricOrganizationUser
type CreateFabricOrganizationUserRequest struct {
	*requests.RpcRequest
	Password       string `position:"Body" name:"Password"`
	Attrs          string `position:"Body" name:"Attrs"`
	OrganizationId string `position:"Body" name:"OrganizationId"`
	Username       string `position:"Body" name:"Username"`
}

// CreateFabricOrganizationUserResponse is the response struct for api CreateFabricOrganizationUser
type CreateFabricOrganizationUserResponse struct {
	*responses.BaseResponse
	RequestId string                               `json:"RequestId" xml:"RequestId"`
	Success   bool                                 `json:"Success" xml:"Success"`
	ErrorCode int                                  `json:"ErrorCode" xml:"ErrorCode"`
	Result    ResultInCreateFabricOrganizationUser `json:"Result" xml:"Result"`
}

// CreateCreateFabricOrganizationUserRequest creates a request to invoke CreateFabricOrganizationUser API
func CreateCreateFabricOrganizationUserRequest() (request *CreateFabricOrganizationUserRequest) {
	request = &CreateFabricOrganizationUserRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-12-21", "CreateFabricOrganizationUser", "baas", "openAPI")
	return
}

// CreateCreateFabricOrganizationUserResponse creates a response to parse from CreateFabricOrganizationUser response
func CreateCreateFabricOrganizationUserResponse() (response *CreateFabricOrganizationUserResponse) {
	response = &CreateFabricOrganizationUserResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
