package cdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeEsExceptionData invokes the cdn.DescribeEsExceptionData API synchronously
func (client *Client) DescribeEsExceptionData(request *DescribeEsExceptionDataRequest) (response *DescribeEsExceptionDataResponse, err error) {
	response = CreateDescribeEsExceptionDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeEsExceptionDataWithChan invokes the cdn.DescribeEsExceptionData API asynchronously
func (client *Client) DescribeEsExceptionDataWithChan(request *DescribeEsExceptionDataRequest) (<-chan *DescribeEsExceptionDataResponse, <-chan error) {
	responseChan := make(chan *DescribeEsExceptionDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeEsExceptionData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeEsExceptionDataWithCallback invokes the cdn.DescribeEsExceptionData API asynchronously
func (client *Client) DescribeEsExceptionDataWithCallback(request *DescribeEsExceptionDataRequest, callback func(response *DescribeEsExceptionDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeEsExceptionDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeEsExceptionData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeEsExceptionDataRequest is the request struct for api DescribeEsExceptionData
type DescribeEsExceptionDataRequest struct {
	*requests.RpcRequest
	StartTime string           `position:"Query" name:"StartTime"`
	EndTime   string           `position:"Query" name:"EndTime"`
	OwnerId   requests.Integer `position:"Query" name:"OwnerId"`
	RuleId    string           `position:"Query" name:"RuleId"`
}

// DescribeEsExceptionDataResponse is the response struct for api DescribeEsExceptionData
type DescribeEsExceptionDataResponse struct {
	*responses.BaseResponse
	RequestId string    `json:"RequestId" xml:"RequestId"`
	Contents  []Content `json:"Contents" xml:"Contents"`
}

// CreateDescribeEsExceptionDataRequest creates a request to invoke DescribeEsExceptionData API
func CreateDescribeEsExceptionDataRequest() (request *DescribeEsExceptionDataRequest) {
	request = &DescribeEsExceptionDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cdn", "2018-05-10", "DescribeEsExceptionData", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeEsExceptionDataResponse creates a response to parse from DescribeEsExceptionData response
func CreateDescribeEsExceptionDataResponse() (response *DescribeEsExceptionDataResponse) {
	response = &DescribeEsExceptionDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
