package cdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeIllegalUrlExportTask invokes the cdn.DescribeIllegalUrlExportTask API synchronously
func (client *Client) DescribeIllegalUrlExportTask(request *DescribeIllegalUrlExportTaskRequest) (response *DescribeIllegalUrlExportTaskResponse, err error) {
	response = CreateDescribeIllegalUrlExportTaskResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeIllegalUrlExportTaskWithChan invokes the cdn.DescribeIllegalUrlExportTask API asynchronously
func (client *Client) DescribeIllegalUrlExportTaskWithChan(request *DescribeIllegalUrlExportTaskRequest) (<-chan *DescribeIllegalUrlExportTaskResponse, <-chan error) {
	responseChan := make(chan *DescribeIllegalUrlExportTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeIllegalUrlExportTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeIllegalUrlExportTaskWithCallback invokes the cdn.DescribeIllegalUrlExportTask API asynchronously
func (client *Client) DescribeIllegalUrlExportTaskWithCallback(request *DescribeIllegalUrlExportTaskRequest, callback func(response *DescribeIllegalUrlExportTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeIllegalUrlExportTaskResponse
		var err error
		defer close(result)
		response, err = client.DescribeIllegalUrlExportTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeIllegalUrlExportTaskRequest is the request struct for api DescribeIllegalUrlExportTask
type DescribeIllegalUrlExportTaskRequest struct {
	*requests.RpcRequest
	TaskId  string           `position:"Query" name:"TaskId"`
	OwnerId requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeIllegalUrlExportTaskResponse is the response struct for api DescribeIllegalUrlExportTask
type DescribeIllegalUrlExportTaskResponse struct {
	*responses.BaseResponse
	RequestId   string `json:"RequestId" xml:"RequestId"`
	Status      string `json:"Status" xml:"Status"`
	DownloadUrl string `json:"DownloadUrl" xml:"DownloadUrl"`
}

// CreateDescribeIllegalUrlExportTaskRequest creates a request to invoke DescribeIllegalUrlExportTask API
func CreateDescribeIllegalUrlExportTaskRequest() (request *DescribeIllegalUrlExportTaskRequest) {
	request = &DescribeIllegalUrlExportTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cdn", "2018-05-10", "DescribeIllegalUrlExportTask", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeIllegalUrlExportTaskResponse creates a response to parse from DescribeIllegalUrlExportTask response
func CreateDescribeIllegalUrlExportTaskResponse() (response *DescribeIllegalUrlExportTaskResponse) {
	response = &DescribeIllegalUrlExportTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
