package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryNumberCorp invokes the cloudcallcenter.QueryNumberCorp API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/querynumbercorp.html
func (client *Client) QueryNumberCorp(request *QueryNumberCorpRequest) (response *QueryNumberCorpResponse, err error) {
	response = CreateQueryNumberCorpResponse()
	err = client.DoAction(request, response)
	return
}

// QueryNumberCorpWithChan invokes the cloudcallcenter.QueryNumberCorp API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/querynumbercorp.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryNumberCorpWithChan(request *QueryNumberCorpRequest) (<-chan *QueryNumberCorpResponse, <-chan error) {
	responseChan := make(chan *QueryNumberCorpResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryNumberCorp(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryNumberCorpWithCallback invokes the cloudcallcenter.QueryNumberCorp API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/querynumbercorp.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryNumberCorpWithCallback(request *QueryNumberCorpRequest, callback func(response *QueryNumberCorpResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryNumberCorpResponse
		var err error
		defer close(result)
		response, err = client.QueryNumberCorp(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryNumberCorpRequest is the request struct for api QueryNumberCorp
type QueryNumberCorpRequest struct {
	*requests.RpcRequest
	WorkOrderId string           `position:"Query" name:"WorkOrderId"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
	CurrentPage requests.Integer `position:"Query" name:"CurrentPage"`
	Status      string           `position:"Query" name:"Status"`
}

// QueryNumberCorpResponse is the response struct for api QueryNumberCorp
type QueryNumberCorpResponse struct {
	*responses.BaseResponse
	RequestId      string                `json:"RequestId" xml:"RequestId"`
	Success        bool                  `json:"Success" xml:"Success"`
	Code           string                `json:"Code" xml:"Code"`
	Message        string                `json:"Message" xml:"Message"`
	HttpStatusCode int                   `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Data           DataInQueryNumberCorp `json:"Data" xml:"Data"`
}

// CreateQueryNumberCorpRequest creates a request to invoke QueryNumberCorp API
func CreateQueryNumberCorpRequest() (request *QueryNumberCorpRequest) {
	request = &QueryNumberCorpRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "QueryNumberCorp", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryNumberCorpResponse creates a response to parse from QueryNumberCorp response
func CreateQueryNumberCorpResponse() (response *QueryNumberCorpResponse) {
	response = &QueryNumberCorpResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
